/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.xml;

import de.globalcube.bean.AlarmConfigBean;
import de.globalcube.bean.BatchConfigBean;
import de.globalcube.bean.ConfigBean;
import de.globalcube.bean.GeneralBean;
import de.globalcube.bean.ImageBean;
import de.globalcube.bean.ImageConfigBean;
import de.globalcube.bean.LogonBean;
import de.globalcube.bean.PublishBean;
import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.util.Utility;
import de.globalcube.xml.XMLLog;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLConfigReader
extends DefaultHandler {
    private XMLReader parser;
    private XMLLog xmllog;
    private Vector scorecards;
    private Vector reports;
    private Vector images;
    private Vector publishes;
    private ImageBean image;
    private ReportBean report;
    private ScorecardBean scorecard;
    public ConfigBean configBean;
    private PublishBean publish;
    private GeneralBean general;
    private CharArrayWriter contents = new CharArrayWriter();
    private boolean generalMode;
    private boolean scorecardsMode;
    private boolean publishesMode;
    private boolean alarmConfigMode;
    private int batchMode = 0;
    private String[] batchDesc = new String[3];
    private String[] batchActive = new String[3];

    public XMLConfigReader(XMLReader xMLReader) {
        this.parser = xMLReader;
    }

    public XMLConfigReader() {
        try {
            XMLReader xMLReader = XMLConfigReader.getXMLReaderFactory();
            this.setParser(xMLReader);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static XMLReader getXMLReaderFactory() {
        XMLReader xMLReader = null;
        try {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            try {
                xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException sAXException2) {
                xMLReader = new SAXParser();
            }
        }
        return xMLReader;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.contents.reset();
        if (string2.equals("Configuration")) {
            this.configBean = new ConfigBean();
            this.configBean.setName(attributes.getValue(attributes.getIndex("Name")));
        } else if (string2.equals("General")) {
            this.general = new GeneralBean();
            this.generalMode = true;
            this.scorecardsMode = false;
            this.publishesMode = false;
        } else if (string2.equals("AlarmConfig")) {
            this.general.setAlarmConfig(new AlarmConfigBean());
            this.alarmConfigMode = true;
        } else if (string2.equals("ImageConfig")) {
            this.general.setImageConfig(new ImageConfigBean());
            this.alarmConfigMode = false;
        } else if (string2.equals("BatchConfig")) {
            this.general.setBatchConfig(new BatchConfigBean());
        } else if (string2.equals("Scorecards")) {
            this.scorecards = new Vector();
            this.generalMode = false;
            this.scorecardsMode = true;
            this.publishesMode = false;
        } else if (string2.equals("Scorecard")) {
            this.scorecard = new ScorecardBean();
            this.scorecard.setID(attributes.getValue(attributes.getIndex("ID")));
            this.scorecard.setName(attributes.getValue(attributes.getIndex("Name")));
            this.scorecard.setDirectory(attributes.getValue(attributes.getIndex("Directory")));
        } else if (string2.equals("Reports")) {
            this.reports = new Vector();
        } else if (string2.equals("Report") && this.scorecardsMode) {
            this.report = new ReportBean();
        } else if (string2.equals("Publishes")) {
            this.publishes = new Vector();
            this.generalMode = false;
            this.scorecardsMode = false;
            this.publishesMode = true;
        } else if (string2.equals("Publish")) {
            this.publish = new PublishBean();
            this.publish.setName(attributes.getValue(attributes.getIndex("Name")));
            this.publish.setId(attributes.getValue(attributes.getIndex("ID")));
        } else if (string2.equals("Images")) {
            this.images = new Vector();
        } else if (string2.equals("Image")) {
            this.image = new ImageBean();
        } else if (string2.equals("LogonInfo")) {
            this.configBean.setLogon(new LogonBean());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("CubePath")) {
            this.general.setCubePath(this.contents.toString());
        } else if (string2.equals("ReportPath")) {
            this.general.setReportPath(this.contents.toString());
        } else if (string2.equals("WebReportPath")) {
            this.general.setWebReportPath(this.contents.toString());
        } else if (string2.equals("PublishPath")) {
            this.general.setPublishPath(this.contents.toString());
        } else if (string2.equals("PublishImagePath")) {
            this.general.setPublishImagePath(this.contents.toString());
        } else if (string2.equals("PublishAlarmPath")) {
            this.general.setPublishAlarmPath(this.contents.toString());
        } else if (string2.equals("WebServerName")) {
            this.general.setWebServerName(this.contents.toString());
        } else if (string2.equals("PortalStartPage")) {
            this.general.setPortalStartPage(this.contents.toString());
        } else if (string2.equals("PDFURL")) {
            this.general.setPdfURL(this.contents.toString());
        } else if (string2.equals("ReportURL")) {
            this.general.setReportURL(this.contents.toString());
        } else if (string2.equals("CubeURL")) {
            this.general.setCubeURL(this.contents.toString());
        } else if (string2.equals("GatewayURL")) {
            this.general.setGatewayURL(this.contents.toString());
        } else if (string2.equals("SecURL")) {
            this.general.setSecURL(this.contents.toString());
        } else if (string2.equals("SMTPHost")) {
            this.general.setSmtpHost(this.contents.toString());
        } else if (string2.equals("SMTPUser")) {
            this.general.setSmtpUser(this.contents.toString());
        } else if (string2.equals("SMTPPassword")) {
            this.general.setSmtpPassword(this.contents.toString());
        } else if (string2.equals("SenderMail")) {
            this.general.setSenderMail(this.contents.toString());
        } else if (string2.equals("GenerateImage")) {
            this.general.setGenerateImage(this.contents.toString());
        } else if (string2.equals("GeneratePPX")) {
            this.general.setGeneratePPX(this.contents.toString());
        } else if (string2.equals("GenerateAlert")) {
            this.general.setGenerateAlert(this.contents.toString());
        } else if (string2.equals("GenerateWeb")) {
            this.general.setGenerateWeb(this.contents.toString());
        } else if (string2.equals("EmailCreation")) {
            this.general.getAlarmConfig().setEmailCreation(this.contents.toString());
        } else if (string2.equals("GIFCreation")) {
            if (this.alarmConfigMode) {
                this.general.getAlarmConfig().setGIFCreation(this.contents.toString());
            } else {
                this.general.getImageConfig().setGIFCreation(this.contents.toString());
            }
        } else if (string2.equals("JPGCreation")) {
            if (this.alarmConfigMode) {
                this.general.getAlarmConfig().setJPGCreation(this.contents.toString());
            } else {
                this.general.getImageConfig().setJPGCreation(this.contents.toString());
            }
        } else if (string2.equals("Active") && this.generalMode) {
            this.batchActive[this.batchMode] = this.contents.toString();
        } else if (string2.equals("Description") && this.generalMode) {
            this.batchDesc[this.batchMode] = this.contents.toString();
            ++this.batchMode;
        } else if (string2.equals("Date")) {
            this.general.getBatchConfig().setDate(this.contents.toString());
        } else if (string2.equals("Time")) {
            this.general.getBatchConfig().setTime(this.contents.toString());
        } else if (string2.equals("Daily")) {
            this.general.getBatchConfig().setDaily(this.contents.toString());
        } else if (string2.equals("BatchConfig")) {
            this.general.getBatchConfig().setActive(this.batchActive);
            this.general.getBatchConfig().setBatch(this.batchDesc);
        } else if (string2.equals("RedLight")) {
            this.general.getImageColor().setRedLight(this.contents.toString());
        } else if (string2.equals("YellowLight")) {
            this.general.getImageColor().setYellowLight(this.contents.toString());
        } else if (string2.equals("GreenLight")) {
            this.general.getImageColor().setGreenLight(this.contents.toString());
        } else if (string2.equals("General")) {
            this.configBean.setGeneral(this.general);
        } else if (string2.equals("Name") && this.scorecardsMode) {
            this.report.setName(this.contents.toString());
        } else if (string2.equals("Description") && this.scorecardsMode) {
            this.report.setDescription(this.contents.toString());
        } else if (string2.equals("Active") && this.scorecardsMode) {
            this.report.setActive(this.contents.toString());
        } else if (string2.equals("ReportFile") && this.scorecardsMode) {
            this.report.setReportFile(this.contents.toString());
        } else if (string2.equals("RowData") && this.scorecardsMode) {
            this.report.setRowData(this.convertToInteger(this.report.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("ColData") && this.scorecardsMode) {
            this.report.setColData(this.convertToInteger(this.report.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("HoherZielwert") && this.scorecardsMode) {
            this.report.setHoherZielwert(this.contents.toString());
        } else if (string2.equals("LowValue") && this.scorecardsMode) {
            this.report.setLowValue(this.convertToDouble(this.report.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("HighValue") && this.scorecardsMode) {
            this.report.setHighValue(this.convertToDouble(this.report.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("Tolerance") && this.scorecardsMode) {
            this.report.setTolerance(this.convertToInteger(this.report.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("Format") && this.scorecardsMode) {
            this.report.setFormat(this.contents.toString());
        } else if (string2.equals("Weight") && this.scorecardsMode) {
            this.report.setWeight(this.contents.toString());
        } else if (string2.equals("MonthlyAccumulate") && this.scorecardsMode) {
            this.report.setMonthlyAccumulate(this.contents.toString());
        } else if (string2.equals("Email") && this.scorecardsMode) {
            this.report.setEmail(this.contents.toString());
        } else if (string2.equals("InfoURL") && this.scorecardsMode) {
            this.report.setInfoURL(this.contents.toString());
        } else if (string2.equals("Report") && this.scorecardsMode) {
            this.reports.addElement(this.report);
        } else if (string2.equals("Reports") && this.scorecardsMode) {
            this.scorecard.setReports(this.reports);
        } else if (string2.equals("Scorecard") && this.scorecardsMode) {
            this.scorecards.addElement(this.scorecard);
        } else if (string2.equals("Scorecards") && this.scorecardsMode) {
            this.configBean.setScorecards(this.scorecards);
        } else if (string2.equals("Name") && this.publishesMode) {
            this.image.setName(this.contents.toString());
        } else if (string2.equals("Description") && this.publishesMode) {
            this.image.setDescription(this.contents.toString());
        } else if (string2.equals("Report") && this.publishesMode) {
            this.image.setReport(this.contents.toString());
        } else if (string2.equals("GIFGenerate") && this.publishesMode) {
            this.image.setGIFGenerate(this.contents.toString());
        } else if (string2.equals("JPGGenerate") && this.publishesMode) {
            this.image.setJPGGenerate(this.contents.toString());
        } else if (string2.equals("PDFGenerate") && this.publishesMode) {
            this.image.setPDFGenerate(this.contents.toString());
        } else if (string2.equals("XLSGenerate") && this.publishesMode) {
            this.image.setXLSGenerate(this.contents.toString());
        } else if (string2.equals("ImageType") && this.publishesMode) {
            this.image.setImageType(this.convertToInteger(this.image.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("PDFImageType") && this.publishesMode) {
            this.image.setPDFImageType(this.convertToInteger(this.image.getName() + "/" + string2, this.contents.toString()));
        } else if (string2.equals("ImageLayer") && this.publishesMode) {
            this.image.setImageLayer(this.contents.toString());
        } else if (string2.equals("PDFImageLayer") && this.publishesMode) {
            this.image.setPDFImageLayer(this.contents.toString());
        } else if (string2.equals("Ansicht") && this.publishesMode) {
            this.image.setAnsicht(this.contents.toString());
        } else if (string2.equals("Email") && this.publishesMode) {
            this.image.setEmail(this.contents.toString());
        } else if (string2.equals("Directory") && this.publishesMode) {
            this.image.setDirectory(this.contents.toString());
        } else if (string2.equals("Active") && this.publishesMode) {
            this.image.setActive(this.contents.toString());
        } else if (string2.equals("SendEmail") && this.publishesMode) {
            this.image.setSendEmail(this.contents.toString());
        } else if (string2.equals("Image") && this.publishesMode) {
            this.images.addElement(this.image);
        } else if (string2.equals("Images") && this.publishesMode) {
            this.publish.setImages(this.images);
        } else if (string2.equals("Publish") && this.publishesMode) {
            this.publishes.addElement(this.publish);
        } else if (string2.equals("Publishes") && this.publishesMode) {
            this.configBean.setPublishes(this.publishes);
        } else if (string2.equals("Customer")) {
            this.configBean.getLogon().setCustomer(this.contents.toString());
        } else if (string2.equals("SerialNumber")) {
            this.configBean.getLogon().setSerialNumber(this.contents.toString());
        } else if (string2.equals("Administrator")) {
            this.configBean.getLogon().setAdministrator(this.contents.toString());
        } else if (string2.equals("Password")) {
            this.configBean.getLogon().setPassword(this.contents.toString());
        }
    }

    private int convertToInteger(String string, String string2) {
        int n = -999;
        try {
            if (string2 == null) {
                n = 0;
                this.xmllog.println("Invalid number [" + string2 + "] at tag [" + string + "]");
            } else {
                n = new Integer(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.xmllog.println("Invalid number [" + string2 + "] at tag [" + string + "]");
            n = -999;
        }
        return n;
    }

    private double convertToDouble(String string, String string2) {
        double d = -999.0;
        try {
            if (string2 == null) {
                d = 0.0;
                this.xmllog.println("Invalid number [" + string2 + "] at tag [" + string + "]");
            } else {
                d = new Double(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.xmllog.println("Invalid number [" + string2 + "] at tag [" + string + "]");
            d = -999.0;
        }
        return d;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contents.write(cArray, n, n2);
    }

    private void setParser(XMLReader xMLReader) {
        this.parser = xMLReader;
    }

    public void parseXML(String string) {
        try {
            this.xmllog = new XMLLog(string);
            this.parser.parse(new InputSource(new FileReader(string)));
            this.xmllog.writeLog();
            Utility.setConfigBean(this.configBean);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.xmllog.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        this.xmllog.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) {
        this.xmllog.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            File file = new File("GVO.xml");
            XMLConfigReader xMLConfigReader = new XMLConfigReader();
            xMLConfigReader.parseXML(file.getAbsolutePath());
            ConfigBean configBean = Utility.getConfigBean();
            GeneralBean generalBean = configBean.getGeneral();
            Vector vector = configBean.getScorecards();
            Vector vector2 = configBean.getPublishes();
            LogonBean logonBean = configBean.getLogon();
            System.out.println(configBean.getName());
            System.out.println(" ");
            System.out.println("GENERAL");
            System.out.println("Cube Path " + generalBean.getCubePath());
            System.out.println("Report Path " + generalBean.getReportPath());
            System.out.println("WebReport Path " + generalBean.getWebReportPath());
            System.out.println("Publish Path " + generalBean.getPublishPath());
            System.out.println("PublishImagePath " + generalBean.getPublishImagePath());
            System.out.println("PublishAlarmPath " + generalBean.getPublishAlarmPath());
            System.out.println("WebServerName " + generalBean.getWebServerName());
            System.out.println("PortalStartPage " + generalBean.getPortalStartPage());
            System.out.println("PDFURL " + generalBean.getPdfURL());
            System.out.println("Cube URL " + generalBean.getCubeURL());
            System.out.println("Report URL " + generalBean.getReportURL());
            System.out.println("Gateway URL " + generalBean.getGatewayURL());
            System.out.println("Security URL " + generalBean.getSecURL());
            System.out.println("AlarmConfig Email Creation " + generalBean.getAlarmConfig().getEmailCreation());
            System.out.println("AlarmConfig GIF Creation " + generalBean.getAlarmConfig().getGIFCreation());
            System.out.println("AlarmConfig JPG Creation " + generalBean.getAlarmConfig().getJPGCreation());
            System.out.println("ImageConfig GIF Creation " + generalBean.getImageConfig().getGIFCreation());
            System.out.println("ImageConfig JPG Creation " + generalBean.getImageConfig().getJPGCreation());
            System.out.println("BatchConfig Date " + generalBean.getBatchConfig().getDate());
            System.out.println("BatchConfig Time " + generalBean.getBatchConfig().getTime());
            System.out.println("BatchConfig Daily " + generalBean.getBatchConfig().getDaily());
            System.out.println("BatchConfig1 Active " + generalBean.getBatchConfig().getActive()[0]);
            System.out.println("BatchConfig2 Active " + generalBean.getBatchConfig().getActive()[1]);
            System.out.println("BatchConfig3 Active " + generalBean.getBatchConfig().getActive()[2]);
            System.out.println("BatchConfig1 Desc " + generalBean.getBatchConfig().getBatch()[0]);
            System.out.println("BatchConfig2 Desc " + generalBean.getBatchConfig().getBatch()[1]);
            System.out.println("BatchConfig3 Desc " + generalBean.getBatchConfig().getBatch()[2]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

