/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.xml;

import de.globalcube.bean.ConfigBean;
import de.globalcube.bean.ImageBean;
import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLWebApplWriter {
    private ConfigBean configBean;
    private HashMap map;

    public XMLWebApplWriter(HashMap hashMap, String string) {
        this.map = hashMap;
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("Daten");
        this.writeResult(element, (Document)documentImpl);
        documentImpl.appendChild(element);
        this.writeXMLtoFile((Document)documentImpl, string);
    }

    private void writeXMLtoFile(Document document, String string) {
        try {
            Utility.createDir(new File(string).getParent());
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndenting(true);
            outputFormat.setEncoding("iso-8859-1");
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document.getDocumentElement());
            byte[] byArray = stringWriter.toString().getBytes();
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            fileOutputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeResult(Element element, Document document) {
        Object[] objectArray = this.map.keySet().toArray();
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = null;
        String string = "";
        Attr attr = null;
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            String string2 = (String)objectArray[n];
            vector = (Vector)this.map.get(string2);
            if (vector != null) {
                vector2 = (Vector)vector.get(0);
                vector3 = (Vector)vector.get(1);
            }
            string = string2.substring(0, 5);
            string2 = string2.substring(5);
            string = String.valueOf(new Integer(string));
            Element element2 = document.createElement(string2);
            attr = document.createAttribute("ID");
            attr.setValue(string);
            element2.setAttributeNode(attr);
            this.writeImages(element2, document, vector3);
            this.writeScorecards(element2, document, vector2);
            element.appendChild(element2);
            ++n;
        }
    }

    private void writeScorecards(Element element, Document document, Vector vector) {
        if (vector == null) {
            return;
        }
        Element element2 = document.createElement("Scorecards");
        int n = 0;
        while (n < vector.size()) {
            ScorecardBean scorecardBean = (ScorecardBean)vector.get(n);
            Vector vector2 = scorecardBean.getReports();
            int n2 = 0;
            while (n2 < vector2.size()) {
                ReportBean reportBean = (ReportBean)vector2.get(n2);
                if (reportBean.getActive() != null && reportBean.getActive().equals("J")) {
                    Element element3 = document.createElement("Bericht");
                    this.writeReport(element3, document, reportBean);
                    element2.appendChild(element3);
                }
                ++n2;
            }
            ++n;
        }
        element.appendChild(element2);
    }

    private void writeReport(Element element, Document document, ReportBean reportBean) {
        Element element2 = null;
        element2 = document.createElement("Titel");
        element2.appendChild(document.createTextNode(reportBean.getName()));
        element.appendChild(element2);
        element2 = document.createElement("Beschreibung");
        element2.appendChild(document.createTextNode(reportBean.getDescription()));
        element.appendChild(element2);
        element2 = document.createElement("Wert");
        element2.appendChild(document.createTextNode(reportBean.getFormattedCurrentValue()));
        element.appendChild(element2);
        element2 = document.createElement("Grafik");
        element2.appendChild(document.createTextNode("images/" + reportBean.getImageName()));
        element.appendChild(element2);
        element2 = document.createElement("URL");
        String string = Utility.getConfigBean().getGeneral().getReportURL() + Utility.URLMailEncode(reportBean.getReportFile());
        element2.appendChild(document.createCDATASection(string));
        element.appendChild(element2);
        element2 = document.createElement("HoherZielwert");
        element2.appendChild(document.createTextNode(reportBean.getHoherZielwert()));
        element.appendChild(element2);
        element2 = document.createElement("NiedrigerWert");
        element2.appendChild(document.createTextNode(reportBean.getFormattedLowValue()));
        element.appendChild(element2);
        element2 = document.createElement("HoherWert");
        element2.appendChild(document.createTextNode(reportBean.getFormattedHighValue()));
        element.appendChild(element2);
        element2 = document.createElement("Koordinaten");
        element2.appendChild(document.createTextNode(reportBean.getRowData() + "|" + reportBean.getColData()));
        element.appendChild(element2);
        element2 = document.createElement("Toleranz");
        element2.appendChild(document.createTextNode("" + reportBean.getTolerance()));
        element.appendChild(element2);
        element2 = document.createElement("Gewichtung");
        element2.appendChild(document.createTextNode(reportBean.getWeight()));
        element.appendChild(element2);
        element2 = document.createElement("Akkumulation");
        element2.appendChild(document.createTextNode(reportBean.getMonthlyAccumulate()));
        element.appendChild(element2);
        element2 = document.createElement("Email");
        element2.appendChild(document.createTextNode(reportBean.getEmail()));
        element.appendChild(element2);
        element2 = document.createElement("InfoURL");
        element2.appendChild(document.createTextNode(reportBean.getInfoURL()));
        element.appendChild(element2);
    }

    private void writeImages(Element element, Document document, Vector vector) {
        if (vector == null) {
            return;
        }
        Element element2 = document.createElement("Publish");
        int n = 0;
        while (n < vector.size()) {
            ImageBean imageBean = (ImageBean)vector.get(n);
            Element element3 = document.createElement("Bericht");
            this.writeImage(element3, document, imageBean);
            element2.appendChild(element3);
            ++n;
        }
        element.appendChild(element2);
    }

    private void writeImage(Element element, Document document, ImageBean imageBean) {
        Element element2 = null;
        element2 = document.createElement("Titel");
        element2.appendChild(document.createTextNode(imageBean.getDescription()));
        element.appendChild(element2);
        element2 = document.createElement("Ansicht");
        element2.appendChild(document.createTextNode(imageBean.getAnsicht()));
        element.appendChild(element2);
        element2 = document.createElement("URL");
        String string = "";
        if (imageBean.getAnsicht().equals("Web")) {
            string = Utility.getConfigBean().getGeneral().getReportURL() + Utility.URLMailEncode(imageBean.getReport());
            element2.appendChild(document.createCDATASection(string));
        } else if (imageBean.getAnsicht().equals("Web-PDF")) {
            string = Utility.getConfigBean().getGeneral().getPdfURL() + Utility.URLMailEncode(imageBean.getReport());
            element2.appendChild(document.createCDATASection(string));
        } else if (imageBean.getAnsicht().equals("Info-User")) {
            string = null;
            element2.appendChild(document.createTextNode(string));
        } else if (imageBean.getAnsicht().equals("Client")) {
            string = "http://" + Utility.getConfigBean().getGeneral().getWebServerName() + "/" + Utility.getConfigBean().getName() + "/report/" + Utility.URLMailEncode(imageBean.getReport()) + ".PPR";
            element2.appendChild(document.createTextNode(string));
        }
        element.appendChild(element2);
        element2 = document.createElement("Email");
        element2.appendChild(document.createTextNode(imageBean.getEmail()));
        element.appendChild(element2);
    }

    public static void main(String[] stringArray) {
        System.out.println("Test");
    }
}

