/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube;

import de.globalcube.Generate;
import de.globalcube.bean.GeneralBean;
import de.globalcube.bean.ImageBean;
import de.globalcube.bean.PublishBean;
import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.cognos.CognosWrapper;
import de.globalcube.util.Utility;
import de.globalcube.xml.XMLConfigReader;
import de.globalcube.xml.XMLWebApplWriter;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class Generate {
    private static String depth;
    private static String smtpUser;
    private static String smtpPassword;

    private static void sendEmail(String string, String string2, String string3, String string4, String string5, String string6) throws Exception {
        Session session;
        Object object;
        String string7 = Utility.getConfigBean().getGeneral().getSmtpHost();
        smtpUser = Utility.getConfigBean().getGeneral().getSmtpUser();
        smtpPassword = Utility.getConfigBean().getGeneral().getSmtpPassword();
        if (string7 == null || string7.length() == 0) {
            return;
        }
        Properties properties = new Properties();
        properties.put("mail.from", string);
        properties.put("mail.transport.protocol", "smtp");
        properties.put("mail.smtp.host", string7);
        if (!smtpUser.equals("") && !smtpPassword.equals("")) {
            properties.put("mail.smtp.user", smtpUser);
            properties.put("mail.smtp.password", smtpPassword);
            properties.put("mail.smtp.auth", "true");
            class MyAuthenticator
            extends Authenticator {
                MyAuthenticator() {
                }

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(Generate.access$000(), Generate.access$100());
                }
            }
            object = new MyAuthenticator();
            session = Session.getInstance((Properties)properties, (Authenticator)object);
        } else {
            session = Session.getInstance((Properties)properties, null);
        }
        object = new MimeMessage(session);
        String[] stringArray = string2.split(";");
        InternetAddress[] internetAddressArray = new InternetAddress[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            internetAddressArray[n] = new InternetAddress(stringArray[n]);
            ++n;
        }
        object.addRecipients(Message.RecipientType.TO, (Address[])internetAddressArray);
        object.setFrom((Address)new InternetAddress(string));
        object.setSubject(string3);
        object.setSentDate(new Date());
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string4);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        if (string5 != null && string5.length() > 0) {
            File[] fileArray = new File(string5).listFiles();
            int n2 = 0;
            while (n2 < fileArray.length) {
                String string8 = fileArray[n2].getName().toUpperCase();
                if (string8.startsWith(string6.toUpperCase()) && (string8.endsWith(".PDF") || string8.endsWith(".XLS"))) {
                    mimeBodyPart = new MimeBodyPart();
                    FileDataSource fileDataSource = new FileDataSource(string5 + string8);
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                    mimeBodyPart.setFileName(string8);
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                }
                ++n2;
            }
        }
        object.setContent((Multipart)mimeMultipart);
        Transport.send((Message)object);
    }

    private static void generatePPX() {
        File file = new File(Utility.getConfigBean().getGeneral().getReportPath());
        File[] fileArray = file.listFiles();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (!Generate.checkValidVersion()) {
            return;
        }
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                string = fileArray[n].getAbsolutePath().toUpperCase();
                string2 = fileArray[n].getName();
                if (string.endsWith(".PPR")) {
                    string3 = Utility.getConfigBean().getGeneral().getWebReportPath() + string2.substring(0, string2.length() - 4) + ".ppx";
                    CognosWrapper cognosWrapper = new CognosWrapper(string);
                    cognosWrapper.convertToPPX(string3);
                }
                ++n;
            }
        }
    }

    private static void generateImages() {
        int n;
        Vector vector = Utility.getConfigBean().getPublishes();
        String string = Utility.getConfigBean().getGeneral().getPublishImagePath();
        String string2 = null;
        PublishBean publishBean = null;
        Vector vector2 = null;
        ImageBean imageBean = null;
        CognosWrapper cognosWrapper = null;
        String string3 = Utility.getConfigBean().getGeneral().getReportPath();
        File file = null;
        Vector<String> vector3 = new Vector<String>();
        if (!Generate.checkValidVersion()) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            publishBean = (PublishBean)vector.elementAt(n2);
            vector2 = publishBean.getImages();
            n = 0;
            while (n < vector2.size()) {
                imageBean = (ImageBean)vector2.elementAt(n);
                if (imageBean.getGIFGenerate().equals("J") || imageBean.getJPGGenerate().equals("J") || imageBean.getXLSGenerate().equals("J") || imageBean.getPDFGenerate().equals("J")) {
                    string2 = Utility.checkPath(string + imageBean.getDirectory() + publishBean.getName());
                    Utility.createDir(string2);
                    file = new File(string3 + imageBean.getReport() + ".PPR");
                    if (file.exists() && imageBean.getReport() != null) {
                        cognosWrapper = new CognosWrapper(file.getAbsolutePath());
                        cognosWrapper.generateImages(imageBean, string2 + imageBean.getName());
                        cognosWrapper = null;
                        if (imageBean.getJPGGenerate().equals("N")) {
                            vector3.add(string2 + imageBean.getName() + ".jpg");
                        }
                        if (imageBean.getSendEmail().equals("J") && (imageBean.getPDFGenerate().equals("J") || imageBean.getXLSGenerate().equals("J")) && imageBean.getEmail().length() > 0) {
                            String string4 = Utility.getConfigBean().getGeneral().getSenderMail();
                            String string5 = imageBean.getEmail();
                            String string6 = imageBean.getDescription();
                            String string7 = "";
                            String string8 = string2 + imageBean.getName();
                            try {
                                Generate.sendEmail(string4, string5, string6, string7, string2, imageBean.getName());
                            }
                            catch (Exception exception) {
                                System.out.println("Error while trying to send an email !!");
                                exception.printStackTrace();
                            }
                        }
                    }
                }
                ++n;
            }
            ++n2;
        }
        Utility.wait(1000);
        n = 0;
        while (n < vector3.size()) {
            File file2 = new File((String)vector3.get(n));
            if (file2.exists()) {
                file2.delete();
            }
            ++n;
        }
    }

    private static void generateEmailAlert() {
        if (!Generate.checkValidVersion()) {
            return;
        }
        Vector vector = Utility.getConfigBean().getScorecards();
        Utility.initReports();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Generate.generateAlert((ScorecardBean)vector.elementAt(n));
                ++n;
            }
        }
    }

    private static void generateAlert(ScorecardBean scorecardBean) {
        StringBuffer stringBuffer = new StringBuffer();
        ReportBean reportBean = null;
        Vector vector = scorecardBean.getReports();
        String string = scorecardBean.getMaximumImage();
        String string2 = null;
        String string3 = scorecardBean.getID() + ".gif";
        int n = 0;
        String string4 = scorecardBean.getDirectory();
        depth = string4 != null && string4.length() > 0 ? "../" : "";
        int n2 = 0;
        while (n2 < vector.size()) {
            reportBean = (ReportBean)vector.elementAt(n2);
            if (Utility.isValidReport(reportBean)) {
                ++n;
                string2 = reportBean.getEmail();
                if (string2 != null && string2.length() > 0 && reportBean.getImageOrder() == 2) {
                    Generate.generateEmail(reportBean, scorecardBean.getID(), n2);
                }
            }
            ++n2;
        }
        File file = new File(Utility.getConfigBean().getGeneral().getPublishPath() + string);
        File file2 = new File(Utility.getConfigBean().getGeneral().getPublishAlarmPath() + string4 + string3);
        Utility.copyFile(file, file2);
    }

    private static void generateKPIHTML() {
        Vector vector = Utility.getConfigBean().getScorecards();
        Utility.initReports();
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                Generate.generateScorecardHTML((ScorecardBean)vector.elementAt(n));
                ++n;
            }
        }
    }

    private static void generateScorecardHTML(ScorecardBean scorecardBean) {
        StringBuffer stringBuffer = new StringBuffer();
        ReportBean reportBean = null;
        Vector vector = scorecardBean.getReports();
        String string = scorecardBean.getMaximumImage();
        String string2 = null;
        String string3 = null;
        String string4 = scorecardBean.getID() + ".htm";
        int n = 0;
        String string5 = scorecardBean.getDirectory();
        depth = string5 != null && string5.length() > 0 ? "../" : "";
        if (!Generate.checkValidVersion()) {
            return;
        }
        Generate.generateKPIHeader(stringBuffer, "Alarm\u00fcbersicht");
        Generate.generateKPITechTitle(stringBuffer, string, scorecardBean.getName());
        Generate.generateKPITechTableHeader(stringBuffer);
        int n2 = 0;
        while (n2 < vector.size()) {
            reportBean = (ReportBean)vector.elementAt(n2);
            if (Utility.isValidReport(reportBean)) {
                string3 = "kpidesc" + scorecardBean.getID() + "-" + ++n + ".htm";
                string2 = reportBean.getEmail();
                Generate.generateKPITechReport(stringBuffer, string3, reportBean);
                Generate.generateKPIDescHTML(reportBean, n, vector, scorecardBean.getID(), string5);
                if (string2 != null && string2.length() > 0 && reportBean.getImageOrder() == 2) {
                    Generate.generateEmail(reportBean, scorecardBean.getID(), n);
                }
            }
            ++n2;
        }
        Generate.generateKPITechFooter(stringBuffer, string2);
        Utility.writeToFile(Utility.getConfigBean().getGeneral().getPublishAlarmPath() + string5 + string4, stringBuffer);
        string4 = scorecardBean.getID() + ".gif";
        File file = new File(Utility.getConfigBean().getGeneral().getPublishPath() + string);
        File file2 = new File(Utility.getConfigBean().getGeneral().getPublishAlarmPath() + string5 + string4);
        Utility.copyFile(file, file2);
    }

    private static void generateKPIHeader(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\n");
        stringBuffer.append("<HTML>");
        stringBuffer.append("\n");
        stringBuffer.append("<HEAD>");
        stringBuffer.append("\n");
        stringBuffer.append("<TITLE>" + string + "</TITLE>");
        stringBuffer.append("\n");
        stringBuffer.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        stringBuffer.append("\n");
        stringBuffer.append("<link rel=\"stylesheet\" href=\"" + depth + "sytlesheets/kpistyles.css\"></HEAD>");
        stringBuffer.append("\n");
        stringBuffer.append("<BODY class=\"kpibackground\">");
        stringBuffer.append("\n");
        stringBuffer.append("<a> </a><center>");
        stringBuffer.append("<a href=\"../" + Utility.getConfigBean().getGeneral().getPortalStartPage() + "\" target=\"_parent\">");
        stringBuffer.append("<img SRC=\"" + depth + "images/diapps.jpg\" ALT=\"Web MIS Creator Home\" BORDER=0 ID=\"DICONS\"></a>");
        stringBuffer.append("\n");
        stringBuffer.append("<p></p>");
        stringBuffer.append("\n");
        stringBuffer.append("<p></p>");
    }

    private static void generateKPITechTitle(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("\n");
        stringBuffer.append("<b><div align=\"center\">");
        stringBuffer.append("\n");
        stringBuffer.append("<div class=\"kpititle\"><font size=\"+1\">");
        if (string != null && string.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append("<img src=\"" + depth + "Images/" + string + "\" border =\"0\">");
        }
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        stringBuffer.append("\n");
        stringBuffer.append("</font></div></b>");
        stringBuffer.append("\n");
        stringBuffer.append("<p></p>");
    }

    private static void generateKPITechTableHeader(StringBuffer stringBuffer) {
        stringBuffer.append("\n");
        stringBuffer.append("<table class=\"kpitable\" width=\"99%\" BORDER=1 CELLSPACING=3 CELLPADDING=1 >");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpitableheader\" width=5%>Status</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpitableheader\" width=35%>Zielgr\u00f6\u00dfe</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpitableheader\" width=35%>Zielwert</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpitableheader\" width=25%>Aktueller Wert</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
    }

    private static void generateKPITechReport(StringBuffer stringBuffer, String string, ReportBean reportBean) {
        String string2 = null;
        String string3 = reportBean.getImageName();
        int n = reportBean.getImageOrder();
        if (n == 0) {
            string2 = "kpigreenactual";
        } else if (n == 2) {
            string2 = "kpiredactual";
        } else if (n == 1) {
            string2 = "kpiyellowactual";
        }
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td width=5% height=\"17\"><p align=\"center\" >");
        stringBuffer.append("\n");
        stringBuffer.append("<a href=\"" + string + "\">");
        stringBuffer.append("<img src=\"" + depth + "Images/" + string3 + "\" border=\"0\"></a>");
        stringBuffer.append("\n");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpitext\" width=35% height=\"17\">");
        stringBuffer.append("\n");
        stringBuffer.append("<a href=\"" + Utility.checkPath(Utility.getConfigBean().getGeneral().getReportURL()) + reportBean.getReportFile() + "\">");
        stringBuffer.append("\n");
        stringBuffer.append(reportBean.getName());
        stringBuffer.append("\n");
        stringBuffer.append("</a>");
        stringBuffer.append("\n");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpitext\" width=35% height=\"17\">");
        stringBuffer.append("\n");
        stringBuffer.append(reportBean.getDescription());
        stringBuffer.append("\n");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td align=\"right\" width=25% height=\"17\"");
        stringBuffer.append("class=\"" + string2 + "\">");
        stringBuffer.append("\n");
        stringBuffer.append(reportBean.getFormattedCurrentValue());
        stringBuffer.append("\n");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
    }

    private static void generateKPITechFooter(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\n");
        stringBuffer.append("</TABLE>");
    }

    private static void generateKPIDescHTML(ReportBean reportBean, int n, Vector vector, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = "kpidesc" + string + "-" + n + ".htm";
        Object var7_7 = null;
        Generate.generateKPIHeader(stringBuffer, "Alarm Definition");
        Generate.generateKPIDescTitle(stringBuffer, reportBean);
        Generate.generateKPIDescTable(stringBuffer, reportBean, string, n, vector, string2);
        Utility.writeToFile(Utility.getConfigBean().getGeneral().getPublishAlarmPath() + string2 + string3, stringBuffer);
    }

    private static void generateKPIDescTitle(StringBuffer stringBuffer, ReportBean reportBean) {
        stringBuffer.append("\n");
        stringBuffer.append("<b><div align=\"center\">");
        stringBuffer.append("\n");
        stringBuffer.append("<img src=\"" + depth + "Images/" + reportBean.getImageName() + "\" border=0");
        stringBuffer.append("\n");
        stringBuffer.append("<div class=\"kpidesctitle\"><font size=\"+1\">");
        stringBuffer.append("\n");
        stringBuffer.append("<a href=\"" + Utility.checkPath(Utility.getConfigBean().getGeneral().getReportURL()) + reportBean.getReportFile() + "\">");
        stringBuffer.append("\n");
        stringBuffer.append(reportBean.getName());
        stringBuffer.append("\n");
        stringBuffer.append("</a></font></div></b>");
        stringBuffer.append("\n");
        stringBuffer.append("<p></p>");
    }

    private static void generateKPIDescTable(StringBuffer stringBuffer, ReportBean reportBean, String string, int n, Vector vector, String string2) {
        String string3 = null;
        int n2 = reportBean.getImageOrder();
        int n3 = vector.size();
        String string4 = "kpitech" + string + ".htm";
        if (string2 != null && string2.length() > 0) {
            string4 = string2.substring(0, string2.length() - 1) + ".htm";
        }
        if (n2 == 0) {
            string3 = "kpigreenactual";
        } else if (n2 == 2) {
            string3 = "kpiredactual";
        } else if (n2 == 1) {
            string3 = "kpiyellowactual";
        }
        stringBuffer.append("\n");
        stringBuffer.append("<table class=\"kpitable\" width=\"99%\" BORDER=1 >");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Oberer Zielwert:</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append(reportBean.getFormattedHighValue());
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Unterer Zielwert:</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append(reportBean.getFormattedLowValue());
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Aktueller Wert:</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"" + string3 + "\" align=right width=\"25%\">");
        stringBuffer.append(reportBean.getFormattedCurrentValue());
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Toleranz:</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append("" + reportBean.getTolerance());
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Gewichtung (1-10):</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append("" + reportBean.getWeight());
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td width=\"75%\">&nbsp;</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td width=\"25%\">&nbsp;</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Positiver Zielwert:</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append(reportBean.getHoherZielwert());
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Reportkoordinaten :</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append("(" + reportBean.getRowData() + "/" + reportBean.getColData() + ")");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td width=\"75%\">&nbsp;</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td width=\"25%\">&nbsp;</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<tr>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctexttitle\" width=\"75%\">Varianz(+/-):</td>");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpidesctext\" align=right width=\"25%\">");
        stringBuffer.append("0%");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("</table>");
        stringBuffer.append("\n");
        stringBuffer.append("<table width=\"99%\">");
        stringBuffer.append("\n");
        stringBuffer.append("<tr class=\"kpidesctext\">");
        stringBuffer.append("\n");
        stringBuffer.append("<td class=\"kpilongdesc\">");
        stringBuffer.append("\n");
        stringBuffer.append(reportBean.getName());
        stringBuffer.append("\n");
        stringBuffer.append("</td>");
        stringBuffer.append("\n");
        stringBuffer.append("</tr>");
        stringBuffer.append("\n");
        stringBuffer.append("</table>");
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        if (n < n3) {
            bl = ((ReportBean)vector.get(n)).getActive().equals("J");
        }
        if (n == 1) {
            string5 = string4;
            if (bl) {
                string6 = "kpidesc" + string + "-" + (n + 1) + ".htm";
            }
        } else if (n > 1) {
            string5 = "kpidesc" + string + "-" + (n - 1) + ".htm";
            string6 = bl ? "kpidesc" + string + "-" + (n + 1) + ".htm" : string4;
        }
        stringBuffer.append("<div align=center>");
        stringBuffer.append("\n");
        stringBuffer.append("<a href=\"" + string5 + "\">");
        stringBuffer.append("\n");
        stringBuffer.append("<img src=\"" + depth + "Images/left.gif\" border=\"0\">");
        stringBuffer.append("</a>");
        if (string6.length() > 0) {
            stringBuffer.append("\n");
            stringBuffer.append("<a href=\"" + string6 + "\">");
            stringBuffer.append("\n");
            stringBuffer.append("<img src=\"" + depth + "Images/right.gif\" border=\"0\">");
            stringBuffer.append("</a>");
        }
    }

    private static boolean checkParameter(String string, String string2) {
        File file = new File(string);
        boolean bl = string2.equals("ALL") || string2.equals("EMAIL") || string2.equals("IMAGE") || string2.equals("WEBAPPL") || string2.equals("PPX");
        return file.exists() && bl;
    }

    public static void generate(String string) {
        if (Utility.getConfigBean().getGeneral().getGenerateAlert().equals("J")) {
            Generate.generateEmailAlert();
        }
        if (Utility.getConfigBean().getGeneral().getGenerateImage().equals("J")) {
            Generate.generateImages();
        }
        if (Utility.getConfigBean().getGeneral().getGeneratePPX().equals("J")) {
            Generate.generatePPX();
        }
        if (Utility.getConfigBean().getGeneral().getGenerateWeb().equals("J")) {
            Utility.initReports();
            Generate.generateWebAppl();
        }
    }

    private static void generateEmail(ReportBean reportBean, String string, int n) {
        GeneralBean generalBean = Utility.getConfigBean().getGeneral();
        String string2 = Utility.getConfigBean().getGeneral().getSenderMail();
        String string3 = reportBean.getEmail();
        String string4 = "\u00dcberschrittener Zielwert " + reportBean.getName();
        String string5 = "N\u00e4here informationen unter ";
        String string6 = "http://" + generalBean.getWebServerName() + "/" + Utility.getConfigBean().getName() + "/config.asp?" + string + "&" + n;
        string6 = Utility.URLMailEncode(string6);
        string5 = string5 + string6;
        if (!Generate.checkValidVersion()) {
            return;
        }
        try {
            Generate.sendEmail(string2, string3, string4, string5, null, null);
        }
        catch (Exception exception) {
            System.out.println("Error while trying to send an email !!");
            exception.printStackTrace();
        }
    }

    private static HashMap filterPerDirectory() {
        Vector vector;
        Object object;
        HashMap hashMap = new HashMap();
        Vector vector2 = Utility.getConfigBean().getScorecards();
        Vector vector3 = Utility.getConfigBean().getPublishes();
        String string = "";
        String string2 = "";
        int n = 0;
        while (n < vector2.size()) {
            ScorecardBean scorecardBean = (ScorecardBean)vector2.get(n);
            string = scorecardBean.getDirectory();
            if (string == null || string.length() == 0) {
                string = "NULL";
            }
            if ((string2 = Utility.LPAD(scorecardBean.getID(), '0', 5) + scorecardBean.getName()) == null || string2.length() == 0) {
                string2 = "NULL";
            }
            if (hashMap.get(string) == null) {
                hashMap.put(string, new HashMap());
            }
            if (((HashMap)(object = (HashMap)hashMap.get(string))).get(string2) == null) {
                ((HashMap)object).put(string2, new Vector());
            }
            if ((vector = (Vector)((HashMap)object).get(string2)).size() == 0) {
                vector.add(new Vector());
                vector.add(new Vector());
            }
            Vector vector4 = (Vector)vector.get(0);
            vector4.add(scorecardBean);
            ++n;
        }
        int n2 = 0;
        while (n2 < vector3.size()) {
            object = (PublishBean)vector3.get(n2);
            vector = ((PublishBean)object).getImages();
            int n3 = 0;
            while (n3 < vector.size()) {
                ImageBean imageBean = (ImageBean)vector.get(n3);
                if (imageBean.getActive() != null && imageBean.getActive().equals("J")) {
                    Vector vector5;
                    HashMap hashMap2;
                    string = imageBean.getDirectory();
                    if (string == null || string.length() == 0) {
                        string = "NULL";
                    }
                    if ((string2 = Utility.LPAD(((PublishBean)object).getId(), '0', 5) + ((PublishBean)object).getName()) == null || string2.length() == 0) {
                        string2 = "NULL";
                    }
                    if (hashMap.get(string) == null) {
                        hashMap.put(string, new HashMap());
                    }
                    if ((hashMap2 = (HashMap)hashMap.get(string)).get(string2) == null) {
                        hashMap2.put(string2, new Vector());
                    }
                    if ((vector5 = (Vector)hashMap2.get(string2)).size() == 0) {
                        vector5.add(new Vector());
                        vector5.add(new Vector());
                    }
                    Vector vector6 = (Vector)vector5.get(1);
                    vector6.add(imageBean);
                }
                ++n3;
            }
            ++n2;
        }
        return hashMap;
    }

    private static void generateWebAppl() {
        HashMap hashMap = null;
        if (!Generate.checkValidVersion()) {
            return;
        }
        hashMap = Generate.filterPerDirectory();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = Utility.getConfigBean().getGeneral().getPublishImagePath();
            string2 = string.equals("NULL") ? string2 + "data.xml" : string2 + string + "data.xml";
            XMLWebApplWriter xMLWebApplWriter = new XMLWebApplWriter((HashMap)hashMap.get(string), string2);
        }
    }

    private static boolean checkValidVersion() {
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = stringArray.length;
        String string = null;
        String string2 = null;
        if (n < 2) {
            System.out.println("Invalid parameters. Syntax : de.globalcube.Generate <xmlConfigurationFile> [mode]");
            System.out.println("[mode] : ALL (data.xml & Image)");
            System.out.println("[mode] : WEBAPPL (Data.xml Only)");
            System.out.println("[mode] : EMAIL (Email Alert & <scorecardID>.GIF)");
            System.out.println("[mode] : IMAGE (Image Only)");
            System.out.println("[mode] : PPX (PPX Files)");
            System.exit(0);
        }
        if (!Generate.checkParameter(string2 = stringArray[0], string = stringArray[1].toUpperCase())) {
            System.out.println("Please make sure the XML configuration files is in current directory !");
            System.exit(0);
        }
        XMLConfigReader xMLConfigReader = new XMLConfigReader();
        xMLConfigReader.parseXML(string2);
        if (Utility.getConfigBean() == null) {
            System.out.println("Invalid configuration file. Please check the format");
            System.exit(0);
        }
        if (!Utility.checkGeneralConfiguration()) {
            System.out.println("Invalid configuration file. Please fill all of the mandatory values");
            System.exit(0);
        }
        if (string.equals("ALL")) {
            if (Utility.getConfigBean().getGeneral().getGenerateAlert().equals("J")) {
                Generate.generateEmailAlert();
            }
            if (Utility.getConfigBean().getGeneral().getGenerateImage().equals("J")) {
                Generate.generateImages();
            }
            if (Utility.getConfigBean().getGeneral().getGeneratePPX().equals("J")) {
                Generate.generatePPX();
            }
            if (Utility.getConfigBean().getGeneral().getGenerateWeb().equals("J")) {
                Utility.initReports();
                Generate.generateWebAppl();
            }
        } else if (string.equals("EMAIL")) {
            if (Utility.getConfigBean().getGeneral().getGenerateAlert().equals("J")) {
                Generate.generateEmailAlert();
            }
        } else if (string.equals("IMAGE")) {
            if (Utility.getConfigBean().getGeneral().getGenerateImage().equals("J")) {
                Generate.generateImages();
            }
        } else if (string.equals("PPX")) {
            if (Utility.getConfigBean().getGeneral().getGeneratePPX().equals("J")) {
                Generate.generatePPX();
            }
        } else if (string.equals("WEBAPPL") && Utility.getConfigBean().getGeneral().getGenerateWeb().equals("J")) {
            Utility.initReports();
            Generate.generateWebAppl();
        }
    }

    static /* synthetic */ String access$000() {
        return smtpUser;
    }

    static /* synthetic */ String access$100() {
        return smtpPassword;
    }
}

