/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.bean.ImageBean;
import de.globalcube.bean.PublishBean;
import de.globalcube.gui.DefaultDialog;
import de.globalcube.gui.GeneralPanel;
import de.globalcube.gui.PublishPanel;
import de.globalcube.gui.WebMISCreator;
import de.globalcube.util.Utility;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class ImageDialog
extends DefaultDialog {
    private JLabel lblName;
    private JLabel lblDescription;
    private JLabel lblReport;
    private JLabel lblImageType;
    private JLabel lblAnsicht;
    private JLabel lblEmail;
    private JTextField txtName;
    private JTextField txtEmail;
    private JTextField txtDescription;
    private JComboBox cmbReport;
    private JComboBox cmbAnsicht;
    private JComboBox cmbImageType;
    private JComboBox cmbPDFImageType;
    private JPanel pnlDetail;
    private JPanel pnlButton;
    private JScrollPane scrollPane;
    private String mode;
    private int parentIndex;
    private int index;
    private PublishPanel parentPanel;
    private JButton btnOpen;
    private JCheckBox cbGIFGenerate;
    private JCheckBox cbJPGGenerate;
    private JCheckBox cbPDFGenerate;
    private JCheckBox cbXLSGenerate;
    private JLabel lblPDFImageType;
    private JLabel lblDirectory;
    private JTextField txtDirectory;
    private JCheckBox cbActive;
    private JCheckBox cbSendEmail;
    private JLabel lblImageLayer;
    private JLabel lblPDFImageLayer;
    private JTextField txtImageLayer;
    private JTextField txtPDFImageLayer;

    public ImageDialog(PublishPanel publishPanel, String string, int n, int n2) {
        super(WebMISCreator.instance.getOwner());
        this.setTitle("Image Data");
        this.mode = string;
        this.index = n2;
        this.parentIndex = n;
        this.parentPanel = publishPanel;
        this.initComponents();
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.pnlButton, "South");
        this.pack();
        this.centerScreen();
    }

    private void initComponents() {
        this.lblName = new JLabel("Name:");
        this.lblDescription = new JLabel("Description:");
        this.lblReport = new JLabel("Report:");
        this.lblImageType = new JLabel("GIF/JPG Image Type:");
        this.lblAnsicht = new JLabel("Ansicht:");
        this.lblEmail = new JLabel("Email:");
        this.lblDirectory = new JLabel("Directory:");
        this.lblPDFImageType = new JLabel("PDF Image Type:");
        this.lblImageLayer = new JLabel("GIF/JPG Schicht Nr.:");
        this.lblPDFImageLayer = new JLabel("PDF Schicht Nr.:");
        this.txtName = new JTextField();
        this.txtDescription = new JTextField();
        this.cmbReport = new JComboBox();
        this.cmbImageType = new JComboBox<String>(new String[]{"0 - Kreuztabelle", "1 - Kreisdiagramm", "2 - 3D-Balkendiagramm", "3 - Balkendiagramm", "4 - Balkengruppendiagramm)", "5 - Stapelbalkendiagramm", "6 - Liniendiagramm", "7 - Mehrliniendiagramm", "8 - Korrelationsdiagramm", "9 - Punktdiagramm"});
        this.cmbImageType.setSelectedIndex(4);
        this.cmbAnsicht = new JComboBox<String>(new String[]{"  ", "Web", "Info-User", "Client", "Web-PDF"});
        this.txtEmail = new JTextField();
        this.txtDirectory = new JTextField();
        this.cmbPDFImageType = new JComboBox<String>(new String[]{"0 - Kreuztabelle", "1 - Kreisdiagramm", "2 - 3D-Balkendiagramm", "3 - Balkendiagramm", "4 - Balkengruppendiagramm)", "5 - Stapelbalkendiagramm", "6 - Liniendiagramm", "7 - Mehrliniendiagramm", "8 - Korrelationsdiagramm", "9 - Punktdiagramm"});
        this.cmbPDFImageType.setSelectedIndex(0);
        this.txtImageLayer = new JTextField();
        this.txtPDFImageLayer = new JTextField();
        this.cmbReport.addItem("  ");
        File file = new File(((GeneralPanel)WebMISCreator.instance.getPanel("General")).getReportPath());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                String string = fileArray[n].getName().toUpperCase();
                if (string.endsWith(".PPR")) {
                    this.cmbReport.addItem(string.substring(0, string.length() - 4));
                }
                ++n;
            }
        }
        this.cbGIFGenerate = new JCheckBox("GIF Generieren", true);
        this.cbJPGGenerate = new JCheckBox("JPG Generieren", true);
        this.cbPDFGenerate = new JCheckBox("PDF Generieren", true);
        this.cbXLSGenerate = new JCheckBox("Excel Generieren", true);
        this.cbActive = new JCheckBox("Aktiv", true);
        this.cbSendEmail = new JCheckBox("Send Email", true);
        this.pnlDetail = new JPanel(new GridLayout(16, 2));
        this.pnlDetail.add(this.lblName);
        this.pnlDetail.add(this.txtName);
        this.pnlDetail.add(this.lblDescription);
        this.pnlDetail.add(this.txtDescription);
        this.pnlDetail.add(this.lblDirectory);
        this.pnlDetail.add(this.txtDirectory);
        this.pnlDetail.add(this.lblReport);
        this.pnlDetail.add(this.cmbReport);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbGIFGenerate);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbJPGGenerate);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbPDFGenerate);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbXLSGenerate);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbActive);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbSendEmail);
        this.pnlDetail.add(this.lblImageType);
        this.pnlDetail.add(this.cmbImageType);
        this.pnlDetail.add(this.lblImageLayer);
        this.pnlDetail.add(this.txtImageLayer);
        this.pnlDetail.add(this.lblPDFImageType);
        this.pnlDetail.add(this.cmbPDFImageType);
        this.pnlDetail.add(this.lblPDFImageLayer);
        this.pnlDetail.add(this.txtPDFImageLayer);
        this.pnlDetail.add(this.lblAnsicht);
        this.pnlDetail.add(this.cmbAnsicht);
        this.pnlDetail.add(this.lblEmail);
        this.pnlDetail.add(this.txtEmail);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setView(this.pnlDetail);
        this.btnOpen = new JButton("Open Report");
        this.btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageDialog.this.openReport();
            }
        });
        this.pnlButton = new JPanel(new GridLayout(1, 2));
        this.pnlButton.add(this.btnOK);
        this.pnlButton.add(this.btnCancel);
        this.pnlButton.add(this.btnOpen);
        if (this.mode.equals("MODIFY")) {
            this.initValues();
        }
    }

    private void openReport() {
        String string;
        File file;
        String string2 = (String)this.cmbReport.getSelectedItem();
        if (string2.length() > 0 && (file = new File(Utility.checkPath(string = ((GeneralPanel)WebMISCreator.instance.getPanel("General")).getReportPath()) + string2 + ".PPR")).exists()) {
            Utility.runFile("file://" + file.getAbsolutePath());
        }
    }

    private void setBean(ImageBean imageBean) {
        imageBean.setName(this.txtName.getText());
        imageBean.setDescription(this.txtDescription.getText());
        imageBean.setReport((String)this.cmbReport.getSelectedItem());
        imageBean.setImageType(this.cmbImageType.getSelectedIndex());
        imageBean.setAnsicht((String)this.cmbAnsicht.getSelectedItem());
        imageBean.setEmail(this.txtEmail.getText());
        imageBean.setDirectory(this.txtDirectory.getText());
        imageBean.setPDFImageType(this.cmbPDFImageType.getSelectedIndex());
        imageBean.setGIFGenerate(this.cbGIFGenerate.isSelected() ? "J" : "N");
        imageBean.setJPGGenerate(this.cbJPGGenerate.isSelected() ? "J" : "N");
        imageBean.setPDFGenerate(this.cbPDFGenerate.isSelected() ? "J" : "N");
        imageBean.setXLSGenerate(this.cbXLSGenerate.isSelected() ? "J" : "N");
        imageBean.setActive(this.cbActive.isSelected() ? "J" : "N");
        imageBean.setSendEmail(this.cbSendEmail.isSelected() ? "J" : "N");
        imageBean.setImageLayer(this.txtImageLayer.getText());
        imageBean.setPDFImageLayer(this.txtPDFImageLayer.getText());
    }

    protected void saveData() {
        if (this.validateData()) {
            PublishBean publishBean = (PublishBean)Utility.getConfigBean().getPublishes().get(this.parentIndex);
            if (this.mode.equals("NEW")) {
                ImageBean imageBean = new ImageBean();
                this.setBean(imageBean);
                publishBean.getImages().addElement(imageBean);
                this.parentPanel.initValues();
            } else if (this.mode.equals("MODIFY")) {
                ImageBean imageBean = (ImageBean)publishBean.getImages().get(this.index);
                this.setBean(imageBean);
                this.parentPanel.initValues();
            }
            this.dispose();
        }
    }

    private void initValues() {
        PublishBean publishBean = (PublishBean)Utility.getConfigBean().getPublishes().get(this.parentIndex);
        ImageBean imageBean = (ImageBean)publishBean.getImages().get(this.index);
        this.txtName.setText(imageBean.getName());
        this.txtDescription.setText(imageBean.getDescription());
        this.cmbReport.setSelectedItem(imageBean.getReport());
        this.cmbImageType.setSelectedIndex(imageBean.getImageType());
        this.cmbAnsicht.setSelectedItem(imageBean.getAnsicht());
        this.txtEmail.setText(imageBean.getEmail());
        this.txtDirectory.setText(imageBean.getDirectory());
        if (imageBean.getGIFGenerate() != null) {
            this.cbGIFGenerate.setSelected(imageBean.getGIFGenerate().equals("J"));
        } else {
            this.cbGIFGenerate.setSelected(false);
        }
        if (imageBean.getJPGGenerate() != null) {
            this.cbJPGGenerate.setSelected(imageBean.getJPGGenerate().equals("J"));
        } else {
            this.cbJPGGenerate.setSelected(false);
        }
        if (imageBean.getPDFGenerate() != null) {
            this.cbPDFGenerate.setSelected(imageBean.getPDFGenerate().equals("J"));
        } else {
            this.cbPDFGenerate.setSelected(false);
        }
        if (imageBean.getXLSGenerate() != null) {
            this.cbXLSGenerate.setSelected(imageBean.getXLSGenerate().equals("J"));
        } else {
            this.cbXLSGenerate.setSelected(false);
        }
        if (imageBean.getActive() != null) {
            this.cbActive.setSelected(imageBean.getActive().equals("J"));
        } else {
            this.cbActive.setSelected(false);
        }
        if (imageBean.getSendEmail() != null) {
            this.cbSendEmail.setSelected(imageBean.getSendEmail().equals("J"));
        } else {
            this.cbSendEmail.setSelected(false);
        }
        this.cmbPDFImageType.setSelectedIndex(imageBean.getPDFImageType());
        this.txtImageLayer.setText(imageBean.getImageLayer());
        this.txtPDFImageLayer.setText(imageBean.getPDFImageLayer());
    }

    private boolean validateData() {
        String string = "";
        JComponent jComponent = null;
        if (this.txtName.getText().trim().length() == 0) {
            jComponent = this.txtName;
            string = "Name";
        } else if (((String)this.cmbReport.getSelectedItem()).trim().length() == 0) {
            jComponent = this.cmbReport;
            string = "Report";
        } else if (this.cmbImageType.getSelectedIndex() == -1) {
            jComponent = this.cmbImageType;
            string = "Image Type";
        } else if (this.txtImageLayer.getText().trim().length() == 0) {
            jComponent = this.txtImageLayer;
            string = "Image Layer";
        } else if (((String)this.cmbAnsicht.getSelectedItem()).trim().length() == 0) {
            jComponent = this.cmbAnsicht;
            string = "Ansicht";
        } else if (this.txtEmail.getText().trim().length() == 0) {
            jComponent = this.txtEmail;
            string = "Email";
        } else if (this.cmbPDFImageType.getSelectedIndex() == -1) {
            jComponent = this.cmbPDFImageType;
            string = "PDF Image Type";
        } else if (this.txtPDFImageLayer.getText().trim().length() == 0) {
            jComponent = this.txtPDFImageLayer;
            string = "PDF Image Layer";
        }
        if (!string.equals("")) {
            string = string + " muss angegeben werden";
        }
        if (string.equals("")) {
            return true;
        }
        JOptionPane.showMessageDialog(this, string, "Message", 0);
        jComponent.requestFocus();
        return false;
    }
}

