/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;

public class LookUpTable {
    private int width;
    private int height;
    private byte[] pixels;
    private int mapSize = 0;
    private ColorModel cm;
    private byte[] rLUT;
    private byte[] gLUT;
    private byte[] bLUT;

    public LookUpTable(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
            this.cm = pixelGrabber.getColorModel();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getColors(this.cm);
    }

    public LookUpTable(ColorModel colorModel) {
        this.getColors(colorModel);
    }

    void getColors(ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.mapSize = indexColorModel.getMapSize();
            this.rLUT = new byte[this.mapSize];
            this.gLUT = new byte[this.mapSize];
            this.bLUT = new byte[this.mapSize];
            indexColorModel.getReds(this.rLUT);
            indexColorModel.getGreens(this.gLUT);
            indexColorModel.getBlues(this.bLUT);
        }
    }

    public int getMapSize() {
        return this.mapSize;
    }

    public byte[] getReds() {
        return this.rLUT;
    }

    public byte[] getGreens() {
        return this.gLUT;
    }

    public byte[] getBlues() {
        return this.bLUT;
    }

    public ColorModel getColorModel() {
        return this.cm;
    }

    public boolean isGrayscale() {
        boolean bl = true;
        if (this.mapSize < 256) {
            return false;
        }
        int n = 0;
        while (n < this.mapSize) {
            if (this.rLUT[n] != this.gLUT[n] || this.gLUT[n] != this.bLUT[n]) {
                bl = false;
            }
            ++n;
        }
        return bl;
    }

    public void drawColorBar(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.mapSize == 0) {
            return;
        }
        ColorProcessor colorProcessor = new ColorProcessor(n3, n4);
        double d = 256.0 / (double)this.mapSize;
        int n5 = 0;
        while (n5 < 256) {
            int n6 = (int)((double)n5 / d);
            colorProcessor.setColor(new Color(this.rLUT[n6] & 0xFF, this.gLUT[n6] & 0xFF, this.bLUT[n6] & 0xFF));
            colorProcessor.moveTo(n5, 0);
            colorProcessor.lineTo(n5, n4);
            ++n5;
        }
        graphics.drawImage(colorProcessor.createImage(), n, n2, null);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
    }

    public void drawUnscaledColorBar(ImageProcessor imageProcessor, int n, int n2, int n3, int n4) {
        ImageProcessor imageProcessor2 = null;
        imageProcessor2 = imageProcessor instanceof ColorProcessor ? new ColorProcessor(n3, n4) : new ByteProcessor(n3, n4);
        if (this.mapSize == 0) {
            int n5 = 0;
            while (n5 < 256) {
                imageProcessor2.setColor(new Color(n5, n5, n5));
                imageProcessor2.moveTo(n5, 0);
                imageProcessor2.lineTo(n5, n4);
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < this.mapSize) {
                imageProcessor2.setColor(new Color(this.rLUT[n6] & 0xFF, this.gLUT[n6] & 0xFF, this.bLUT[n6] & 0xFF));
                imageProcessor2.moveTo(n6, 0);
                imageProcessor2.lineTo(n6, n4);
                ++n6;
            }
        }
        imageProcessor.insert(imageProcessor2, n, n2);
        imageProcessor.setColor(Color.black);
        imageProcessor.drawRect(n - 1, n2, n3 + 2, n4);
    }

    public static ColorModel createGrayscaleColorModel(boolean bl) {
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        if (bl) {
            int n = 0;
            while (n < 256) {
                byArray[255 - n] = (byte)n;
                byArray2[255 - n] = (byte)n;
                byArray3[255 - n] = (byte)n;
                ++n;
            }
        } else {
            int n = 0;
            while (n < 256) {
                byArray[n] = (byte)n;
                byArray2[n] = (byte)n;
                byArray3[n] = (byte)n;
                ++n;
            }
        }
        return new IndexColorModel(8, 256, byArray, byArray2, byArray3);
    }
}

