/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.io.FileInfo;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

class FitsDecoder {
    private String directory;
    private String fileName;
    private DataInputStream f;
    private StringBuffer info = new StringBuffer(512);
    double bscale;
    double bzero;

    public FitsDecoder(String string, String string2) {
        this.directory = string;
        this.fileName = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    FileInfo getInfo() throws IOException {
        FileInfo fileInfo = new FileInfo();
        fileInfo.fileFormat = 4;
        fileInfo.fileName = this.fileName;
        fileInfo.directory = this.directory;
        fileInfo.width = 0;
        fileInfo.height = 0;
        fileInfo.offset = 0;
        this.f = new DataInputStream(new FileInputStream(this.directory + this.fileName));
        String string = this.getString(80);
        this.info.append(string + "\n");
        if (!string.startsWith("SIMPLE")) {
            this.f.close();
            return null;
        }
        int n = 1;
        do {
            block14: {
                block15: {
                    int n2;
                    block16: {
                        ++n;
                        string = this.getString(80);
                        this.info.append(string + "\n");
                        if (!string.startsWith("BITPIX")) break block15;
                        n2 = this.getInteger(string);
                        if (n2 != 8) break block16;
                        fileInfo.fileType = 0;
                        break block14;
                    }
                    if (n2 == 16) {
                        fileInfo.fileType = 1;
                        break block14;
                    } else if (n2 == 32) {
                        fileInfo.fileType = 3;
                        break block14;
                    } else {
                        if (n2 != -32) {
                            IJ.error("BITPIX must be 8, 16, 32 or -32 (float).");
                            this.f.close();
                            return null;
                        }
                        fileInfo.fileType = 4;
                    }
                    break block14;
                }
                if (string.startsWith("NAXIS1")) {
                    fileInfo.width = this.getInteger(string);
                } else if (string.startsWith("NAXIS2")) {
                    fileInfo.height = this.getInteger(string);
                } else if (string.startsWith("BSCALE")) {
                    this.bscale = this.getFloat(string);
                } else if (string.startsWith("BZERO")) {
                    this.bzero = this.getFloat(string);
                }
            }
            if (n <= 360) continue;
            this.f.close();
            return null;
        } while (!string.startsWith("END"));
        this.f.close();
        fileInfo.offset = 2880 + 2880 * (n * 80 / 2880);
        return fileInfo;
    }

    String getString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.f.read(byArray);
        return new String(byArray);
    }

    int getInteger(String string) {
        string = string.substring(10, 30);
        string = string.trim();
        return Integer.parseInt(string);
    }

    double getFloat(String string) {
        Double d;
        string = string.substring(10, 30);
        string = string.trim();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    String getHeaderInfo() {
        return new String(this.info);
    }
}

