/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackMerge;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Slicer
implements PlugIn {
    private static final String[] starts = new String[]{"Top", "Left", "Bottom", "Right"};
    private static String startAt = starts[0];
    private double outputZSpacing = 1.0;
    private int outputSlices = 1;
    private ImageWindow win;
    private boolean noRoi;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        int n = imagePlus.getStackSize();
        if (n < 2) {
            IJ.showMessage("Reslicer", "Stack required");
            return;
        }
        if (!this.showDialog(imagePlus)) {
            return;
        }
        IJ.showStatus("Reslice... (press esc to abort)");
        this.win = imagePlus.getWindow();
        if (this.win != null) {
            this.win.running = true;
        }
        long l = System.currentTimeMillis();
        ImagePlus imagePlus2 = null;
        imagePlus2 = imagePlus.getType() == 4 ? this.resliceRGB(imagePlus) : this.reslice(imagePlus);
        if (imagePlus2 == null) {
            return;
        }
        imagePlus2.setCalibration(imagePlus.getCalibration());
        Calibration calibration = imagePlus2.getCalibration();
        calibration.pixelDepth = this.outputZSpacing * calibration.pixelWidth;
        imagePlus2.show();
        if (this.noRoi) {
            imagePlus.killRoi();
        } else {
            imagePlus.draw();
        }
        if (this.win != null) {
            this.win.running = false;
        }
        IJ.showStatus(IJ.d2s((double)(System.currentTimeMillis() - l) / 1000.0, 2) + " seconds");
    }

    public ImagePlus resliceRGB(ImagePlus imagePlus) {
        Roi roi = imagePlus.getRoi();
        RGBStackSplitter rGBStackSplitter = new RGBStackSplitter();
        rGBStackSplitter.split(imagePlus.getStack(), true);
        IJ.showStatus("Slicer: RGB split");
        ImagePlus imagePlus2 = new ImagePlus("Red", rGBStackSplitter.red);
        ImagePlus imagePlus3 = new ImagePlus("Green", rGBStackSplitter.green);
        ImagePlus imagePlus4 = new ImagePlus("Blue", rGBStackSplitter.blue);
        imagePlus2.setRoi(roi);
        imagePlus3.setRoi(roi);
        imagePlus4.setRoi(roi);
        Calibration calibration = imagePlus.getCalibration();
        imagePlus2.setCalibration(calibration);
        imagePlus3.setCalibration(calibration);
        imagePlus4.setCalibration(calibration);
        IJ.showStatus("Slicer: reslicing red");
        imagePlus2 = this.reslice(imagePlus2);
        IJ.showStatus("Slicer: reslicing green");
        imagePlus3 = this.reslice(imagePlus3);
        IJ.showStatus("Slicer: reslicing blue");
        imagePlus4 = this.reslice(imagePlus4);
        int n = imagePlus2.getWidth();
        int n2 = imagePlus2.getHeight();
        int n3 = imagePlus2.getStackSize();
        RGBStackMerge rGBStackMerge = new RGBStackMerge();
        IJ.showStatus("Slicer: RGB merge");
        ImageStack imageStack = rGBStackMerge.mergeStacks(n, n2, n3, imagePlus2.getStack(), imagePlus3.getStack(), imagePlus4.getStack(), true);
        return new ImagePlus("Reslice of  " + imagePlus.getShortTitle(), imageStack);
    }

    public ImagePlus reslice(ImagePlus imagePlus) {
        int n;
        Roi roi = imagePlus.getRoi();
        int n2 = n = roi != null ? roi.getType() : 0;
        if (roi == null || n == 0 || n == 5) {
            return this.resliceRectOrLine(imagePlus);
        }
        if (n == 6 || n == 7) {
            return this.resliceDiagonally(imagePlus);
        }
        IJ.showMessage("Reslice...", "Line or rectangular selection required");
        return null;
    }

    boolean showDialog(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        String string = calibration.getUnits();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        double d = calibration.pixelDepth;
        Roi roi = imagePlus.getRoi();
        boolean bl = roi != null && roi.getType() == 5;
        GenericDialog genericDialog = new GenericDialog("Reslice");
        genericDialog.addNumericField("Input Z Spacing (" + string + "):", calibration.pixelDepth, 3);
        genericDialog.addNumericField("Output Z Spacing (" + string + "):", d, 3);
        if (bl) {
            genericDialog.addNumericField("Slice Count:", this.outputSlices, 0);
        } else {
            genericDialog.addChoice("Start At:", starts, startAt);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        calibration.pixelDepth = genericDialog.getNextNumber();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        this.outputZSpacing = genericDialog.getNextNumber() / calibration.pixelWidth;
        if (bl) {
            this.outputSlices = (int)genericDialog.getNextNumber();
        } else {
            startAt = genericDialog.getNextChoice();
        }
        return true;
    }

    ImagePlus resliceRectOrLine(ImagePlus imagePlus) {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        this.noRoi = false;
        Roi roi = imagePlus.getRoi();
        if (roi == null) {
            this.noRoi = true;
            imagePlus.setRoi(0, 0, imagePlus.getWidth(), imagePlus.getHeight());
            roi = imagePlus.getRoi();
        }
        if (roi.getType() == 0) {
            object = roi.getBoundingRect();
            if (startAt.equals(starts[0])) {
                d = ((Rectangle)object).x;
                d2 = ((Rectangle)object).y;
                d3 = ((Rectangle)object).x + ((Rectangle)object).width;
                d4 = ((Rectangle)object).y;
                d5 = 0.0;
                d6 = this.outputZSpacing;
                this.outputSlices = (int)((double)((Rectangle)object).height / this.outputZSpacing);
            } else if (startAt.equals(starts[1])) {
                d = ((Rectangle)object).x;
                d2 = ((Rectangle)object).y;
                d3 = ((Rectangle)object).x;
                d4 = ((Rectangle)object).y + ((Rectangle)object).height;
                d5 = this.outputZSpacing;
                d6 = 0.0;
                this.outputSlices = (int)((double)((Rectangle)object).width / this.outputZSpacing);
            } else if (startAt.equals(starts[2])) {
                d = ((Rectangle)object).x;
                d2 = ((Rectangle)object).y + ((Rectangle)object).height;
                d3 = ((Rectangle)object).x + ((Rectangle)object).width;
                d4 = ((Rectangle)object).y + ((Rectangle)object).height;
                d5 = 0.0;
                d6 = -this.outputZSpacing;
                this.outputSlices = (int)((double)((Rectangle)object).height / this.outputZSpacing);
            } else if (startAt.equals(starts[3])) {
                d = ((Rectangle)object).x + ((Rectangle)object).width;
                d2 = ((Rectangle)object).y;
                d3 = ((Rectangle)object).x + ((Rectangle)object).width;
                d4 = ((Rectangle)object).y + ((Rectangle)object).height;
                d5 = -this.outputZSpacing;
                d6 = 0.0;
                this.outputSlices = (int)((double)((Rectangle)object).width / this.outputZSpacing);
            }
        } else if (roi.getType() == 5) {
            object = (Line)roi;
            d = ((Line)object).x1;
            d2 = ((Line)object).y1;
            d3 = ((Line)object).x2;
            d4 = ((Line)object).y2;
            double d7 = d3 - d;
            double d8 = d4 - d2;
            double d9 = Math.sqrt(d7 * d7 + d8 * d8) / this.outputZSpacing;
            d5 = -(d8 / d9);
            d6 = d7 / d9;
        } else {
            return null;
        }
        if (this.outputSlices == 0) {
            IJ.showMessage("Reslicer", "Output Z spacing (" + IJ.d2s(this.outputZSpacing, 0) + " pixels) is too large.");
            return null;
        }
        object = null;
        int n = 0;
        while (n < this.outputSlices) {
            ImageProcessor imageProcessor = this.getSlice(imagePlus, d, d2, d3, d4);
            this.drawLine(d, d2, d3, d4, imagePlus);
            if (object == null) {
                object = new ImageStack(imageProcessor.getWidth(), imageProcessor.getHeight());
            }
            ((ImageStack)object).addSlice(null, imageProcessor);
            d += d5;
            d3 += d5;
            d2 += d6;
            d4 += d6;
            if (this.win != null && !this.win.running) {
                IJ.beep();
                imagePlus.draw();
                return null;
            }
            ++n;
        }
        return new ImagePlus("Reslice of  " + imagePlus.getShortTitle(), (ImageStack)object);
    }

    ImagePlus resliceDiagonally(ImagePlus imagePlus) {
        ImageProcessor imageProcessor = this.getSlice(imagePlus, 0.0, 0.0, 0.0, 0.0);
        return new ImagePlus("Reslice of  " + imagePlus.getShortTitle(), imageProcessor);
    }

    ImageProcessor getSlice(ImagePlus imagePlus, double d, double d2, double d3, double d4) {
        double d5;
        Roi roi = imagePlus.getRoi();
        int n = roi != null ? roi.getType() : 0;
        ImageStack imageStack = imagePlus.getStack();
        int n2 = imageStack.getSize();
        ImageProcessor imageProcessor = null;
        double[] dArray = null;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            ImageProcessor imageProcessor2 = imageStack.getProcessor(n2 - n4);
            dArray = n == 6 || n == 7 ? this.getIrregularProfile(roi, imageProcessor2) : this.getLine(imageProcessor2, d, d2, d3, d4, dArray);
            if (n4 == 0) {
                n3 = dArray.length;
                imageProcessor = imageProcessor2.createProcessor(n3, n2);
            }
            this.putRow(imageProcessor, 0, n4, dArray, n3);
            ++n4;
        }
        Calibration calibration = imagePlus.getCalibration();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        if ((d5 = calibration.pixelDepth / calibration.pixelWidth) != 1.0) {
            imageProcessor.setInterpolate(true);
            imageProcessor = imageProcessor.resize(n3, (int)((double)n2 * d5));
        }
        return imageProcessor;
    }

    public void putRow(ImageProcessor imageProcessor, int n, int n2, double[] dArray, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            imageProcessor.putPixelValue(n++, n2, dArray[n4]);
            ++n4;
        }
    }

    double[] getIrregularProfile(Roi roi, ImageProcessor imageProcessor) {
        int n = ((PolygonRoi)roi).getNCoordinates();
        int[] nArray = ((PolygonRoi)roi).getXCoordinates();
        int[] nArray2 = ((PolygonRoi)roi).getYCoordinates();
        Rectangle rectangle = roi.getBoundingRect();
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        double d = 0.0;
        double[] dArray = new double[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        int n4 = 0;
        while (n4 < n - 1) {
            int n5 = nArray[n4 + 1] - nArray[n4];
            int n6 = nArray2[n4 + 1] - nArray2[n4];
            double d2 = Math.sqrt(n5 * n5 + n6 * n6);
            d += d2;
            dArray[n4] = d2;
            nArray3[n4] = n5;
            nArray4[n4] = n6;
            ++n4;
        }
        double[] dArray2 = new double[(int)d];
        double d3 = 1.0;
        double d4 = 0.0;
        double d5 = n2;
        double d6 = n3;
        int n7 = 0;
        while (n7 < n) {
            double d7 = dArray[n7];
            if (d7 != 0.0) {
                double d8 = (double)nArray3[n7] / d7;
                double d9 = (double)nArray4[n7] / d7;
                double d10 = 1.0 - d3;
                double d11 = (double)(n2 + nArray[n7]) + d10 * d8;
                double d12 = (double)(n3 + nArray2[n7]) + d10 * d9;
                double d13 = d7 - d10;
                int n8 = (int)d13;
                int n9 = 0;
                while (n9 <= n8) {
                    int n10 = (int)d4 + n9;
                    if (n10 < dArray2.length) {
                        dArray2[n10] = imageProcessor.getInterpolatedValue(d11, d12);
                    }
                    d11 += d8;
                    d12 += d9;
                    ++n9;
                }
                d4 += d7;
                d3 = d13 - (double)n8;
            }
            ++n7;
        }
        return dArray2;
    }

    private double[] getLine(ImageProcessor imageProcessor, double d, double d2, double d3, double d4, double[] dArray) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        int n = (int)Math.round(Math.sqrt(d5 * d5 + d6 * d6));
        if (dArray == null) {
            dArray = new double[n];
        }
        double d7 = d5 / (double)n;
        double d8 = d6 / (double)n;
        double d9 = d;
        double d10 = d2;
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = imageProcessor.getInterpolatedValue(d9, d10);
            d9 += d7;
            d10 += d8;
            ++n2;
        }
        return dArray;
    }

    void drawLine(double d, double d2, double d3, double d4, ImagePlus imagePlus) {
        ImageWindow imageWindow = imagePlus.getWindow();
        if (imageWindow == null) {
            return;
        }
        ImageCanvas imageCanvas = imageWindow.getCanvas();
        Graphics graphics = imageCanvas.getGraphics();
        graphics.setColor(Roi.getColor());
        graphics.setXORMode(Color.black);
        graphics.drawLine(imageCanvas.screenX((int)(d + 0.5)), imageCanvas.screenY((int)(d2 + 0.5)), imageCanvas.screenX((int)(d3 + 0.5)), imageCanvas.screenY((int)(d4 + 0.5)));
    }
}

