/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int kw;
    int kh;
    int slice = 1;
    boolean canceled;
    float[] kernel;
    ImageWindow win;
    boolean isLineRoi;
    static String kernelText = "-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 24 -1 -1\n-1 -1 -1 -1 -1\n-1 -1 -1 -1 -1\n";
    static boolean normalize = true;
    static /* synthetic */ Class class$ij$plugin$filter$Convolver;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$Convolver == null ? (class$ij$plugin$filter$Convolver = Convolver.class$("ij.plugin.filter.Convolver")) : class$ij$plugin$filter$Convolver);
        this.imp = imagePlus;
        this.canceled = false;
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        Roi roi = imagePlus.getRoi();
        this.isLineRoi = roi != null && roi.getType() >= 5;
        this.kernel = this.getKernel();
        if (this.kernel == null) {
            return 4096;
        }
        if ((this.kw & 1) == 0) {
            IJ.showMessage("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
            return 4096;
        }
        int n = IJ.setupDialog(imagePlus, 31);
        if ((n & 0x1000) != 0) {
            return 4096;
        }
        this.win = imagePlus.getWindow();
        this.win.running = true;
        IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
        imagePlus.startTiming();
        return n;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (!this.win.running) {
            this.canceled = true;
            return;
        }
        if (this.isLineRoi) {
            imageProcessor.resetRoi();
        }
        this.convolve(imageProcessor, this.kernel, this.kw, this.kh);
        if (this.slice > 1) {
            IJ.showStatus("Convolve: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.slice == this.imp.getStackSize()) {
            imageProcessor.resetMinAndMax();
        }
        ++this.slice;
    }

    float[] getKernel() {
        GenericDialog genericDialog = new GenericDialog("Convolver...", IJ.getInstance());
        genericDialog.addTextAreas(kernelText, null, 10, 30);
        genericDialog.addCheckbox("Normalize Kernel", normalize);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
            return null;
        }
        kernelText = genericDialog.getNextText();
        normalize = genericDialog.getNextBoolean();
        StringTokenizer stringTokenizer = new StringTokenizer(kernelText);
        int n = stringTokenizer.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)this.getNum(stringTokenizer);
            ++n2;
        }
        return fArray;
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void convolve(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        if (n3 == 3) {
            this.convolveRGB(imageProcessor, fArray, n, n2);
            return;
        }
        imageProcessor.setCalibrationTable(null);
        ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
        imageProcessor2.setRoi(imageProcessor.getRoi());
        imageProcessor2.setMask(imageProcessor.getMask());
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        switch (n3) {
            case 0: {
                imageProcessor2 = imageProcessor2.convertToByte(false);
                byte[] byArray = (byte[])imageProcessor.getPixels();
                byte[] byArray2 = (byte[])imageProcessor2.getPixels();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                break;
            }
            case 1: {
                imageProcessor2 = imageProcessor2.convertToShort(false);
                short[] sArray = (short[])imageProcessor.getPixels();
                short[] sArray2 = (short[])imageProcessor2.getPixels();
                System.arraycopy(sArray2, 0, sArray, 0, sArray.length);
                break;
            }
        }
    }

    public void convolveRGB(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        int[] nArray = imageProcessor.getMask();
        int n5 = n3 * n4;
        if (this.slice == 1) {
            IJ.showStatus("Convolve (red)");
        }
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n3, n4, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(n3, n4, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(n3, n4, byArray3, null);
        Rectangle rectangle2 = imageProcessor.getRoi();
        ImageProcessor imageProcessor2 = byteProcessor.convertToFloat();
        imageProcessor2.setRoi(rectangle);
        imageProcessor2.setMask(nArray);
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor3 = imageProcessor2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (green)");
        }
        imageProcessor2 = byteProcessor2.convertToFloat();
        imageProcessor2.setRoi(rectangle);
        imageProcessor2.setMask(nArray);
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor4 = imageProcessor2.convertToByte(false);
        imageProcessor2 = byteProcessor3.convertToFloat();
        imageProcessor2.setRoi(rectangle);
        imageProcessor2.setMask(nArray);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (blue)");
        }
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor5 = imageProcessor2.convertToByte(false);
        ((ColorProcessor)imageProcessor).setRGB((byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels(), (byte[])imageProcessor5.getPixels());
    }

    public void convolveFloat(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        boolean bl;
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        Rectangle rectangle = imageProcessor.getRoi();
        boolean bl2 = rectangle.width != n3 || rectangle.height != n4;
        boolean bl3 = bl = bl2 && imageProcessor.getMask() != null;
        if (bl) {
            imageProcessor.snapshot();
        }
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width;
        int n8 = n6 + rectangle.height;
        int n9 = n / 2;
        int n10 = n2 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getPixelsCopy();
        double d = 1.0;
        if (normalize) {
            double d2 = 0.0;
            int n11 = 0;
            while (n11 < fArray.length) {
                d2 += (double)fArray[n11];
                ++n11;
            }
            if (d2 != 0.0) {
                d = (float)(1.0 / d2);
            }
        }
        int n12 = Math.max((n8 - n6) / 25, 1);
        int n13 = n3 - n9;
        int n14 = n4 - n10;
        int n15 = n6;
        while (n15 < n8) {
            if (n15 % n12 == 0) {
                IJ.showProgress((double)n15 / (double)n4);
            }
            int n16 = n5;
            while (n16 < n7) {
                double d3 = 0.0;
                int n17 = 0;
                boolean bl4 = n15 < n10 || n15 >= n14 || n16 < n9 || n16 >= n13;
                int n18 = -n10;
                while (n18 <= n10) {
                    int n19 = n16 + (n15 + n18) * n3;
                    int n20 = -n9;
                    while (n20 <= n9) {
                        d3 = bl4 ? (d3 += (double)(this.getPixel(n16 + n20, n15 + n18, fArray3, n3, n4) * fArray[n17++])) : (d3 += (double)(fArray3[n19 + n20] * fArray[n17++]));
                        ++n20;
                    }
                    ++n18;
                }
                fArray2[n16 + n15 * n3] = (float)(d3 * d);
                ++n16;
            }
            ++n15;
        }
        if (bl) {
            imageProcessor.reset(imageProcessor.getMask());
        }
        IJ.showProgress(1.0);
    }

    private float getPixel(int n, int n2, float[] fArray, int n3, int n4) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= n4) {
            n2 = n4 - 1;
        }
        return fArray[n + n2 * n3];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

