/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.gui.DefaultDialog;
import de.globalcube.gui.GeneralPanel;
import de.globalcube.gui.ScorecardPanel;
import de.globalcube.gui.WebMISCreator;
import de.globalcube.util.Utility;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class ReportDialog
extends DefaultDialog {
    private JLabel lblName;
    private JLabel lblDescription;
    private JLabel lblReport;
    private JLabel lblRow;
    private JLabel lblColumn;
    private JLabel lblHoher;
    private JLabel lblLowValue;
    private JLabel lblHighValue;
    private JLabel lblTolerance;
    private JLabel lblFormat;
    private JLabel lblWeight;
    private JLabel lblMonthly;
    private JLabel lblEmail;
    private JLabel lblInfoURL;
    private JTextField txtName;
    private JTextField txtDescription;
    private JTextField txtRow;
    private JTextField txtColumn;
    private JTextField txtTolerance;
    private JTextField txtEmail;
    private JTextField txtInfoURL;
    private JTextField txtHighValue;
    private JTextField txtLowValue;
    private JCheckBox cbActive;
    private JComboBox cmbReport;
    private JComboBox cmbHoher;
    private JComboBox cmbFormat;
    private JComboBox cmbWeight;
    private JComboBox cmbMonthly;
    private JPanel pnlDetail;
    private JPanel pnlButton;
    private JScrollPane scrollPane;
    private String mode;
    private int parentIndex;
    private int index;
    private ScorecardPanel parentPanel;
    private JButton btnOpen;

    public ReportDialog(ScorecardPanel scorecardPanel, String string, int n, int n2) {
        super(WebMISCreator.instance.getOwner());
        this.setTitle("Report Data");
        this.mode = string;
        this.index = n2;
        this.parentIndex = n;
        this.parentPanel = scorecardPanel;
        this.initComponents();
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.pnlButton, "South");
        this.pack();
        this.centerScreen();
    }

    private void initComponents() {
        this.lblName = new JLabel("Name:");
        this.lblDescription = new JLabel("Beschreibung:");
        this.lblReport = new JLabel("Report:");
        this.lblRow = new JLabel("Zeite:");
        this.lblColumn = new JLabel("Spalte:");
        this.lblHoher = new JLabel("Hoher Zielwert:");
        this.lblLowValue = new JLabel("Unterer Zielwert:");
        this.lblHighValue = new JLabel("Oberer Zielwert:");
        this.lblTolerance = new JLabel("Toleranz (%):");
        this.lblFormat = new JLabel("Format:");
        this.lblWeight = new JLabel("Gewichtung:");
        this.lblMonthly = new JLabel("Monatliche Kumulierung:");
        this.lblEmail = new JLabel("Email:");
        this.lblInfoURL = new JLabel("Info URL:");
        this.txtName = new JTextField();
        this.txtDescription = new JTextField();
        this.txtRow = new JTextField();
        this.txtColumn = new JTextField();
        this.txtLowValue = new JTextField();
        this.txtHighValue = new JTextField();
        this.txtTolerance = new JTextField();
        this.txtEmail = new JTextField();
        this.txtInfoURL = new JTextField();
        this.cbActive = new JCheckBox("Aktiv");
        this.cmbReport = new JComboBox();
        this.cmbHoher = new JComboBox<String>(new String[]{"J", "N"});
        this.cmbFormat = new JComboBox<String>(new String[]{"Ganzzahlig", "Zahl mit Trennz", "Zahl ohne Trennz", "W\u00e4hrung", "Prozent"});
        this.cmbWeight = new JComboBox<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        this.cmbMonthly = new JComboBox<String>(new String[]{"J", "N"});
        this.cmbMonthly.setSelectedIndex(1);
        this.cmbReport.addItem("  ");
        File file = new File(((GeneralPanel)WebMISCreator.instance.getPanel("General")).getReportPath());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                String string = fileArray[n].getName().toUpperCase();
                if (string.endsWith(".PPR")) {
                    this.cmbReport.addItem(string.substring(0, string.length() - 4));
                }
                ++n;
            }
        }
        this.pnlDetail = new JPanel(new GridLayout(15, 2));
        this.pnlDetail.add(this.lblName);
        this.pnlDetail.add(this.txtName);
        this.pnlDetail.add(this.lblDescription);
        this.pnlDetail.add(this.txtDescription);
        this.pnlDetail.add(new JLabel());
        this.pnlDetail.add(this.cbActive);
        this.pnlDetail.add(this.lblReport);
        this.pnlDetail.add(this.cmbReport);
        this.pnlDetail.add(this.lblRow);
        this.pnlDetail.add(this.txtRow);
        this.pnlDetail.add(this.lblColumn);
        this.pnlDetail.add(this.txtColumn);
        this.pnlDetail.add(this.lblHoher);
        this.pnlDetail.add(this.cmbHoher);
        this.pnlDetail.add(this.lblLowValue);
        this.pnlDetail.add(this.txtLowValue);
        this.pnlDetail.add(this.lblHighValue);
        this.pnlDetail.add(this.txtHighValue);
        this.pnlDetail.add(this.lblTolerance);
        this.pnlDetail.add(this.txtTolerance);
        this.pnlDetail.add(this.lblFormat);
        this.pnlDetail.add(this.cmbFormat);
        this.pnlDetail.add(this.lblWeight);
        this.pnlDetail.add(this.cmbWeight);
        this.pnlDetail.add(this.lblMonthly);
        this.pnlDetail.add(this.cmbMonthly);
        this.pnlDetail.add(this.lblEmail);
        this.pnlDetail.add(this.txtEmail);
        this.pnlDetail.add(this.lblInfoURL);
        this.pnlDetail.add(this.txtInfoURL);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setView(this.pnlDetail);
        this.btnOpen = new JButton("Open Report");
        this.btnOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReportDialog.this.openReport();
            }
        });
        this.pnlButton = new JPanel(new GridLayout(1, 2));
        this.pnlButton.add(this.btnOK);
        this.pnlButton.add(this.btnCancel);
        this.pnlButton.add(this.btnOpen);
        if (this.mode.equals("MODIFY")) {
            this.initValues();
        }
    }

    private void openReport() {
        String string;
        File file;
        String string2 = (String)this.cmbReport.getSelectedItem();
        if (string2.length() > 0 && (file = new File(Utility.checkPath(string = ((GeneralPanel)WebMISCreator.instance.getPanel("General")).getReportPath()) + string2 + ".PPR")).exists()) {
            Utility.runFile("file://" + file.getAbsolutePath());
        }
    }

    private void setBean(ReportBean reportBean) {
        reportBean.setName(this.txtName.getText());
        reportBean.setDescription(this.txtDescription.getText());
        reportBean.setActive(this.cbActive.isSelected() ? "J" : "N");
        reportBean.setReportFile((String)this.cmbReport.getSelectedItem());
        reportBean.setRowData(Utility.convertToInt(this.txtRow.getText().trim()));
        reportBean.setColData(Utility.convertToInt(this.txtColumn.getText().trim()));
        reportBean.setHoherZielwert((String)this.cmbHoher.getSelectedItem());
        reportBean.setLowValue(Utility.convertToDouble(this.txtLowValue.getText().trim()));
        reportBean.setHighValue(Utility.convertToDouble(this.txtHighValue.getText().trim()));
        reportBean.setTolerance(Utility.convertToInt(this.txtTolerance.getText().trim()));
        reportBean.setFormat((String)this.cmbFormat.getSelectedItem());
        reportBean.setWeight((String)this.cmbWeight.getSelectedItem());
        reportBean.setMonthlyAccumulate((String)this.cmbMonthly.getSelectedItem());
        reportBean.setEmail(this.txtEmail.getText());
        reportBean.setInfoURL(this.txtInfoURL.getText());
    }

    protected void saveData() {
        if (this.validateData()) {
            ScorecardBean scorecardBean = (ScorecardBean)Utility.getConfigBean().getScorecards().get(this.parentIndex);
            if (this.mode.equals("NEW")) {
                ReportBean reportBean = new ReportBean();
                this.setBean(reportBean);
                scorecardBean.getReports().addElement(reportBean);
                this.parentPanel.initValues();
            } else if (this.mode.equals("MODIFY")) {
                ReportBean reportBean = (ReportBean)scorecardBean.getReports().get(this.index);
                this.setBean(reportBean);
                this.parentPanel.initValues();
            }
            this.dispose();
        }
    }

    private void initValues() {
        ScorecardBean scorecardBean = (ScorecardBean)Utility.getConfigBean().getScorecards().get(this.parentIndex);
        ReportBean reportBean = (ReportBean)scorecardBean.getReports().get(this.index);
        this.txtName.setText(reportBean.getName());
        this.txtDescription.setText(reportBean.getDescription());
        if (reportBean.getActive() != null) {
            this.cbActive.setSelected(reportBean.getActive().equals("J"));
        }
        this.cmbReport.setSelectedItem(reportBean.getReportFile());
        this.txtRow.setText("" + reportBean.getRowData());
        this.txtColumn.setText("" + reportBean.getColData());
        this.cmbHoher.setSelectedItem(reportBean.getHoherZielwert());
        this.txtLowValue.setText("" + reportBean.getLowValue());
        this.txtHighValue.setText("" + reportBean.getHighValue());
        this.txtTolerance.setText("" + reportBean.getTolerance());
        this.cmbFormat.setSelectedItem(reportBean.getFormat());
        this.cmbWeight.setSelectedItem(reportBean.getWeight());
        this.cmbMonthly.setSelectedItem(reportBean.getMonthlyAccumulate());
        this.txtEmail.setText(reportBean.getEmail());
        this.txtInfoURL.setText(reportBean.getInfoURL());
    }

    private boolean validateData() {
        String string = "";
        JComponent jComponent = null;
        if (this.txtName.getText().trim().length() == 0) {
            jComponent = this.txtName;
            string = "Name";
        } else if (((String)this.cmbReport.getSelectedItem()).trim().length() == 0) {
            jComponent = this.cmbReport;
            string = "Report";
        } else if (this.txtRow.getText().trim().length() == 0) {
            jComponent = this.txtRow;
            string = "Zeite";
        } else if (this.txtColumn.getText().trim().length() == 0) {
            jComponent = this.txtColumn;
            string = "Spalte";
        } else if (this.txtLowValue.getText().trim().length() == 0) {
            jComponent = this.txtLowValue;
            string = "Unterer Zielwert";
        } else if (this.txtHighValue.getText().trim().length() == 0) {
            jComponent = this.txtHighValue;
            string = "Oberer Zielwert";
        } else if (this.txtEmail.getText().trim().length() == 0) {
            jComponent = this.txtEmail;
            string = "Email";
        }
        if (string.equals("")) {
            if (!Utility.isNumeric(this.txtRow.getText().trim())) {
                string = "Zeite muss ein numerischer";
                jComponent = this.txtRow;
            }
            if (!Utility.isNumeric(this.txtColumn.getText().trim())) {
                string = "Spalte muss ein numerischer";
                jComponent = this.txtColumn;
            }
            if (!Utility.isDouble(this.txtLowValue.getText().trim())) {
                string = "Unterer Zielwert muss ein numerischer";
                jComponent = this.txtLowValue;
            }
            if (!Utility.isDouble(this.txtHighValue.getText().trim())) {
                string = "Oberer Zielwert muss ein numerischer";
                jComponent = this.txtHighValue;
            }
            if (this.txtTolerance.getText().trim().length() > 0 && !Utility.isNumeric(this.txtTolerance.getText().trim())) {
                string = "Tolerance muss ein numerischer";
                jComponent = this.txtTolerance;
            } else {
                double d;
                double d2 = Utility.convertToDouble(this.txtLowValue.getText().trim());
                if (d2 > (d = Utility.convertToDouble(this.txtHighValue.getText().trim()))) {
                    string = "Unterer Zielwert muss (<) Oberer Zielwert";
                    jComponent = this.txtLowValue;
                }
            }
        } else {
            string = string + " muss angegeben werden";
        }
        if (string.equals("")) {
            return true;
        }
        JOptionPane.showMessageDialog(this, string, "Message", 0);
        jComponent.requestFocus();
        return false;
    }
}

