/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.gui;

import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.gui.CopyReportDialog;
import de.globalcube.gui.ReportDialog;
import de.globalcube.gui.TablePanel;
import de.globalcube.util.Utility;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ScorecardPanel
extends TablePanel {
    private static Vector columns = new Vector();
    private ScorecardBean scorecard;

    public ScorecardPanel(ScorecardBean scorecardBean) {
        super(columns, "Scorecard");
        this.scorecard = scorecardBean;
        this.createPopupMenu();
        this.setActivatePopup(true);
        this.initValues();
    }

    public void initValues() {
        Vector<String> vector = null;
        Vector vector2 = null;
        vector2 = new Vector();
        Vector vector3 = this.scorecard.getReports();
        if (vector3 != null) {
            int n = 0;
            while (n < vector3.size()) {
                ReportBean reportBean = (ReportBean)vector3.elementAt(n);
                vector = new Vector<String>();
                vector.add(reportBean.getName());
                vector.add(reportBean.getInfoURL());
                vector.add(reportBean.getActive());
                vector.add(reportBean.getEmail());
                vector2.add(vector);
                ++n;
            }
        }
        this.model.setDataVector(vector2, columns);
        this.table.setProperties();
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Copy Report...");
        JMenuItem jMenuItem2 = new JMenuItem("New Report...");
        JMenuItem jMenuItem3 = new JMenuItem("Modify Report...");
        JMenuItem jMenuItem4 = new JMenuItem("Delete Report...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScorecardPanel.this.copyData();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScorecardPanel.this.newRowData();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScorecardPanel.this.modifyRowData(false);
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScorecardPanel.this.removeRowData();
            }
        });
        this.popupMenu.add(jMenuItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(jMenuItem2);
        this.popupMenu.add(jMenuItem3);
        this.popupMenu.add(jMenuItem4);
        this.popupMenu.setInvoker(this.table);
    }

    private void copyData() {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            new CopyReportDialog(this, Utility.getConfigBean().getScorecards().indexOf(this.scorecard), n);
            this.table.setRowSelectionInterval(n, n);
        }
    }

    public void newRowData() {
        ReportDialog reportDialog = new ReportDialog(this, "NEW", Utility.getConfigBean().getScorecards().indexOf(this.scorecard), -1);
    }

    protected void modifyRowData(boolean bl) {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            ReportDialog reportDialog = new ReportDialog(this, "MODIFY", Utility.getConfigBean().getScorecards().indexOf(this.scorecard), n);
            if (n > 0 && bl) {
                --n;
            }
            this.table.setRowSelectionInterval(n, n);
        }
    }

    static {
        columns.add("Name");
        columns.add("URL");
        columns.add("Aktiv");
        columns.add("Email");
    }
}

