/*
 * Decompiled with CFR 0.152.
 */
package de.globalcube.xml;

import de.globalcube.bean.ConfigBean;
import de.globalcube.bean.ImageBean;
import de.globalcube.bean.PublishBean;
import de.globalcube.bean.ReportBean;
import de.globalcube.bean.ScorecardBean;
import de.globalcube.util.Utility;
import de.globalcube.xml.XMLConfigReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLConfigWriter {
    private ConfigBean configBean;
    private String directoryName;

    public XMLConfigWriter(ConfigBean configBean, String string) {
        this.configBean = configBean;
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("Configuration");
        Attr attr = documentImpl.createAttribute("Name");
        attr.setValue(this.configBean.getName());
        element.setAttributeNode(attr);
        this.writeConfigurationXML(element, (Document)documentImpl);
        documentImpl.appendChild(element);
        this.writeXMLtoFile((Document)documentImpl, string);
    }

    private void writeXMLtoFile(Document document, String string) {
        try {
            Utility.createDir(new File(string).getParent());
            OutputFormat outputFormat = new OutputFormat(document);
            outputFormat.setIndenting(true);
            outputFormat.setEncoding("iso-8859-1");
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.asDOMSerializer();
            xMLSerializer.serialize(document.getDocumentElement());
            byte[] byArray = stringWriter.toString().getBytes();
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
            fileOutputStream.write(byArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeConfigurationXML(Element element, Document document) {
        Element element2 = document.createElement("General");
        this.writeGeneralXML(element2, document);
        element.appendChild(element2);
        element2 = document.createElement("Scorecards");
        this.writeScorecardsXML(element2, document);
        element.appendChild(element2);
        element2 = document.createElement("Publishes");
        this.writePublishesXML(element2, document);
        element.appendChild(element2);
        element2 = document.createElement("LogonInfo");
        this.writeLogonXML(element2, document);
        element.appendChild(element2);
    }

    private void writeGeneralXML(Element element, Document document) {
        Element element2 = null;
        element2 = document.createElement("CubePath");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getCubePath()));
        element.appendChild(element2);
        element2 = document.createElement("ReportPath");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getReportPath()));
        element.appendChild(element2);
        element2 = document.createElement("WebReportPath");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getWebReportPath()));
        element.appendChild(element2);
        element2 = document.createElement("PublishPath");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getPublishPath()));
        element.appendChild(element2);
        element2 = document.createElement("PublishImagePath");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getPublishImagePath()));
        element.appendChild(element2);
        element2 = document.createElement("PublishAlarmPath");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getPublishAlarmPath()));
        element.appendChild(element2);
        element2 = document.createElement("WebServerName");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getWebServerName()));
        element.appendChild(element2);
        element2 = document.createElement("PortalStartPage");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getPortalStartPage()));
        element.appendChild(element2);
        element2 = document.createElement("PDFURL");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getPdfURL()));
        element.appendChild(element2);
        element2 = document.createElement("ReportURL");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getReportURL()));
        element.appendChild(element2);
        element2 = document.createElement("CubeURL");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getCubeURL()));
        element.appendChild(element2);
        element2 = document.createElement("GatewayURL");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getGatewayURL()));
        element.appendChild(element2);
        element2 = document.createElement("SecURL");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getSecURL()));
        element.appendChild(element2);
        element2 = document.createElement("SMTPHost");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getSmtpHost()));
        element.appendChild(element2);
        element2 = document.createElement("SMTPUser");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getSmtpUser()));
        element.appendChild(element2);
        element2 = document.createElement("SMTPPassword");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getSmtpPassword()));
        element.appendChild(element2);
        element2 = document.createElement("SenderMail");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getSenderMail()));
        element.appendChild(element2);
        element2 = document.createElement("GenerateImage");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getGenerateImage()));
        element.appendChild(element2);
        element2 = document.createElement("GeneratePPX");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getGeneratePPX()));
        element.appendChild(element2);
        element2 = document.createElement("GenerateAlert");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getGenerateAlert()));
        element.appendChild(element2);
        element2 = document.createElement("GenerateWeb");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getGenerateWeb()));
        element.appendChild(element2);
        Element element3 = document.createElement("AlarmConfig");
        element2 = document.createElement("EmailCreation");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getAlarmConfig().getEmailCreation()));
        element3.appendChild(element2);
        element2 = document.createElement("GIFCreation");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getAlarmConfig().getGIFCreation()));
        element3.appendChild(element2);
        element2 = document.createElement("JPGCreation");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getAlarmConfig().getJPGCreation()));
        element3.appendChild(element2);
        element.appendChild(element3);
        Element element4 = document.createElement("ImageConfig");
        element2 = document.createElement("GIFCreation");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getImageConfig().getGIFCreation()));
        element4.appendChild(element2);
        element2 = document.createElement("JPGCreation");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getImageConfig().getJPGCreation()));
        element4.appendChild(element2);
        element.appendChild(element4);
        Element element5 = document.createElement("BatchConfig");
        Element element6 = document.createElement("Batch1");
        element2 = document.createElement("Active");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getActive()[0]));
        element6.appendChild(element2);
        element2 = document.createElement("Description");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getBatch()[0]));
        element6.appendChild(element2);
        element5.appendChild(element6);
        Element element7 = document.createElement("Batch2");
        element2 = document.createElement("Active");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getActive()[1]));
        element7.appendChild(element2);
        element2 = document.createElement("Description");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getBatch()[1]));
        element7.appendChild(element2);
        element5.appendChild(element7);
        Element element8 = document.createElement("Batch3");
        element2 = document.createElement("Active");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getActive()[2]));
        element8.appendChild(element2);
        element2 = document.createElement("Description");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getBatch()[2]));
        element8.appendChild(element2);
        element5.appendChild(element8);
        element2 = document.createElement("Date");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getDate()));
        element5.appendChild(element2);
        element2 = document.createElement("Time");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getTime()));
        element5.appendChild(element2);
        element2 = document.createElement("Daily");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getBatchConfig().getDaily()));
        element5.appendChild(element2);
        element.appendChild(element5);
        Element element9 = document.createElement("ImageColor");
        element2 = document.createElement("RedLight");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getImageColor().getRedLight()));
        element9.appendChild(element2);
        element2 = document.createElement("YellowLight");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getImageColor().getYellowLight()));
        element9.appendChild(element2);
        element2 = document.createElement("GreenLight");
        element2.appendChild(document.createTextNode(this.configBean.getGeneral().getImageColor().getGreenLight()));
        element9.appendChild(element2);
        element.appendChild(element9);
    }

    private void writeScorecardsXML(Element element, Document document) {
        Vector vector = this.configBean.getScorecards();
        Element element2 = null;
        Attr attr = null;
        int n = 0;
        while (n < vector.size()) {
            ScorecardBean scorecardBean = (ScorecardBean)vector.elementAt(n);
            element2 = document.createElement("Scorecard");
            attr = document.createAttribute("ID");
            attr.setValue(scorecardBean.getID());
            element2.setAttributeNode(attr);
            attr = document.createAttribute("Name");
            attr.setValue(scorecardBean.getName());
            element2.setAttributeNode(attr);
            attr = document.createAttribute("Directory");
            attr.setValue(scorecardBean.getDirectory());
            element2.setAttributeNode(attr);
            this.writeReportsXML(scorecardBean.getReports(), element2, document);
            element.appendChild(element2);
            ++n;
        }
    }

    private void writeReportsXML(Vector vector, Element element, Document document) {
        if (vector != null) {
            Element element2 = document.createElement("Reports");
            Element element3 = null;
            int n = 0;
            while (n < vector.size()) {
                ReportBean reportBean = (ReportBean)vector.elementAt(n);
                Element element4 = document.createElement("Report");
                element3 = document.createElement("Name");
                element3.appendChild(document.createTextNode(reportBean.getName()));
                element4.appendChild(element3);
                element3 = document.createElement("Description");
                element3.appendChild(document.createTextNode(reportBean.getDescription()));
                element4.appendChild(element3);
                element3 = document.createElement("Active");
                element3.appendChild(document.createTextNode(reportBean.getActive()));
                element4.appendChild(element3);
                element3 = document.createElement("ReportFile");
                element3.appendChild(document.createTextNode(reportBean.getReportFile()));
                element4.appendChild(element3);
                element3 = document.createElement("RowData");
                element3.appendChild(document.createTextNode("" + reportBean.getRowData()));
                element4.appendChild(element3);
                element3 = document.createElement("ColData");
                element3.appendChild(document.createTextNode("" + reportBean.getColData()));
                element4.appendChild(element3);
                element3 = document.createElement("HoherZielwert");
                element3.appendChild(document.createTextNode(reportBean.getHoherZielwert()));
                element4.appendChild(element3);
                element3 = document.createElement("LowValue");
                element3.appendChild(document.createTextNode("" + reportBean.getLowValue()));
                element4.appendChild(element3);
                element3 = document.createElement("HighValue");
                element3.appendChild(document.createTextNode("" + reportBean.getHighValue()));
                element4.appendChild(element3);
                element3 = document.createElement("Tolerance");
                element3.appendChild(document.createTextNode("" + reportBean.getTolerance()));
                element4.appendChild(element3);
                element3 = document.createElement("Format");
                element3.appendChild(document.createTextNode(reportBean.getFormat()));
                element4.appendChild(element3);
                element3 = document.createElement("Weight");
                element3.appendChild(document.createTextNode(reportBean.getWeight()));
                element4.appendChild(element3);
                element3 = document.createElement("MonthlyAccumulate");
                element3.appendChild(document.createTextNode(reportBean.getMonthlyAccumulate()));
                element4.appendChild(element3);
                element3 = document.createElement("Email");
                element3.appendChild(document.createTextNode(reportBean.getEmail()));
                element4.appendChild(element3);
                element3 = document.createElement("InfoURL");
                element3.appendChild(document.createTextNode(reportBean.getInfoURL()));
                element4.appendChild(element3);
                element2.appendChild(element4);
                ++n;
            }
            element.appendChild(element2);
        }
    }

    private void writePublishesXML(Element element, Document document) {
        Vector vector = this.configBean.getPublishes();
        Element element2 = null;
        Attr attr = null;
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                PublishBean publishBean = (PublishBean)vector.elementAt(n);
                element2 = document.createElement("Publish");
                attr = document.createAttribute("Name");
                attr.setValue(publishBean.getName());
                element2.setAttributeNode(attr);
                attr = document.createAttribute("ID");
                attr.setValue(publishBean.getId());
                element2.setAttributeNode(attr);
                this.writeImagesXML(publishBean.getImages(), element2, document);
                element.appendChild(element2);
                ++n;
            }
        }
    }

    private void writeImagesXML(Vector vector, Element element, Document document) {
        if (vector != null) {
            Element element2 = document.createElement("Images");
            Element element3 = null;
            int n = 0;
            while (n < vector.size()) {
                ImageBean imageBean = (ImageBean)vector.elementAt(n);
                Element element4 = document.createElement("Image");
                element3 = document.createElement("Name");
                element3.appendChild(document.createTextNode(imageBean.getName()));
                element4.appendChild(element3);
                element3 = document.createElement("Description");
                element3.appendChild(document.createTextNode(imageBean.getDescription()));
                element4.appendChild(element3);
                element3 = document.createElement("Directory");
                element3.appendChild(document.createTextNode(imageBean.getDirectory()));
                element4.appendChild(element3);
                element3 = document.createElement("Report");
                element3.appendChild(document.createTextNode(imageBean.getReport()));
                element4.appendChild(element3);
                element3 = document.createElement("GIFGenerate");
                element3.appendChild(document.createTextNode(imageBean.getGIFGenerate()));
                element4.appendChild(element3);
                element3 = document.createElement("JPGGenerate");
                element3.appendChild(document.createTextNode(imageBean.getJPGGenerate()));
                element4.appendChild(element3);
                element3 = document.createElement("PDFGenerate");
                element3.appendChild(document.createTextNode(imageBean.getPDFGenerate()));
                element4.appendChild(element3);
                element3 = document.createElement("XLSGenerate");
                element3.appendChild(document.createTextNode(imageBean.getXLSGenerate()));
                element4.appendChild(element3);
                element3 = document.createElement("Active");
                element3.appendChild(document.createTextNode(imageBean.getActive() == null || imageBean.getActive().length() == 0 ? "N" : imageBean.getActive()));
                element4.appendChild(element3);
                element3 = document.createElement("SendEmail");
                element3.appendChild(document.createTextNode(imageBean.getSendEmail() == null || imageBean.getSendEmail().length() == 0 ? "N" : imageBean.getSendEmail()));
                element4.appendChild(element3);
                element3 = document.createElement("ImageType");
                element3.appendChild(document.createTextNode("" + imageBean.getImageType()));
                element4.appendChild(element3);
                element3 = document.createElement("ImageLayer");
                element3.appendChild(document.createTextNode(imageBean.getImageLayer()));
                element4.appendChild(element3);
                element3 = document.createElement("PDFImageType");
                element3.appendChild(document.createTextNode("" + imageBean.getPDFImageType()));
                element4.appendChild(element3);
                element3 = document.createElement("PDFImageLayer");
                element3.appendChild(document.createTextNode(imageBean.getPDFImageLayer()));
                element4.appendChild(element3);
                element3 = document.createElement("Ansicht");
                element3.appendChild(document.createTextNode(imageBean.getAnsicht()));
                element4.appendChild(element3);
                element3 = document.createElement("Email");
                element3.appendChild(document.createTextNode(imageBean.getEmail()));
                element4.appendChild(element3);
                element2.appendChild(element4);
                ++n;
            }
            element.appendChild(element2);
        }
    }

    private void writeLogonXML(Element element, Document document) {
        Element element2 = document.createElement("Customer");
        element2.appendChild(document.createTextNode(this.configBean.getLogon().getCustomer()));
        element.appendChild(element2);
        element2 = document.createElement("SerialNumber");
        element2.appendChild(document.createTextNode(this.configBean.getLogon().getSerialNumber()));
        element.appendChild(element2);
        element2 = document.createElement("Administrator");
        element2.appendChild(document.createTextNode(this.configBean.getLogon().getAdministrator()));
        element.appendChild(element2);
        element2 = document.createElement("Password");
        element2.appendChild(document.createTextNode(this.configBean.getLogon().getPassword()));
        element.appendChild(element2);
    }

    public static void main(String[] stringArray) {
        XMLConfigReader xMLConfigReader = new XMLConfigReader();
        File file = new File("default.xml");
        File file2 = new File("Default2.xml");
        xMLConfigReader.parseXML(file.getAbsolutePath());
        XMLConfigWriter xMLConfigWriter = new XMLConfigWriter(Utility.getConfigBean(), file2.getAbsolutePath());
    }
}

