/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.macro.Interpreter;
import ij.macro.MacroConstants;
import ij.macro.Program;
import ij.macro.Symbol;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Random;

public class Functions
implements MacroConstants {
    Interpreter interp;
    Program pgm;
    boolean updateNeeded;
    boolean autoUpdate = true;
    ImagePlus imp;
    ImageProcessor ip;
    int imageType;
    Random ran;

    Functions(Interpreter interpreter, Program program) {
        this.interp = interpreter;
        this.pgm = program;
    }

    void doFunction(int n) {
        switch (n) {
            case 300: {
                this.doRun();
                break;
            }
            case 302: {
                IJ.selectWindow(this.getStringArg());
                this.resetImage();
                break;
            }
            case 303: {
                IJ.wait((int)this.getArg());
                break;
            }
            case 304: {
                this.interp.getParens();
                IJ.beep();
                break;
            }
            case 305: {
                this.interp.getParens();
                IJ.resetMinAndMax();
                this.resetImage();
                break;
            }
            case 306: {
                this.interp.getParens();
                IJ.resetThreshold();
                this.resetImage();
                break;
            }
            case 307: {
                IJ.log(this.getStringArg());
                break;
            }
            case 308: {
                IJ.write(this.getStringArg());
                break;
            }
            case 309: {
                IJ.doWand((int)this.getFirstArg(), (int)this.getLastArg());
                this.resetImage();
                break;
            }
            case 310: {
                IJ.setMinAndMax(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 311: {
                IJ.setThreshold(this.getFirstArg(), this.getLastArg());
                this.resetImage();
                break;
            }
            case 312: {
                IJ.setTool((int)this.getArg());
                break;
            }
            case 313: {
                this.setForegroundColor();
                break;
            }
            case 314: {
                this.setBackgroundColor();
                break;
            }
            case 336: {
                this.setColor();
                break;
            }
            case 315: {
                this.makeLine();
                break;
            }
            case 316: {
                this.makeOval();
                break;
            }
            case 317: {
                this.makeRectangle();
                break;
            }
            case 318: {
                this.interp.dump();
                break;
            }
            case 320: {
                this.lineTo();
                break;
            }
            case 319: {
                this.moveTo();
                break;
            }
            case 321: {
                this.drawLine();
                break;
            }
            case 322: {
                this.requires();
                break;
            }
            case 323: {
                this.autoUpdate = this.getBooleanArg();
                break;
            }
            case 324: {
                this.interp.getParens();
                this.updateDisplay();
                break;
            }
            case 325: {
                this.drawString();
                break;
            }
            case 326: {
                IJ.setPasteMode(this.getStringArg());
                break;
            }
            case 327: {
                IJ.doCommand(this.getStringArg());
                break;
            }
            case 328: {
                IJ.showStatus(this.getStringArg());
                this.interp.statusUpdated = true;
                break;
            }
            case 329: {
                IJ.showProgress(this.getArg());
                this.interp.showingProgress = true;
                break;
            }
            case 330: {
                this.showMessage(false);
                break;
            }
            case 331: 
            case 332: {
                this.setPixel();
                break;
            }
            case 333: 
            case 334: 
            case 335: {
                this.doIPMethod(n);
                break;
            }
            case 337: {
                this.getProcessor().setLineWidth((int)this.getArg());
                break;
            }
            case 338: {
                this.changeValues();
                break;
            }
            case 339: {
                this.setImage();
            }
        }
    }

    final double getFunctionValue(int n) {
        double d = 0.0;
        switch (n) {
            case 1000: {
                d = this.getPixel();
                break;
            }
            case 1001: 
            case 1002: 
            case 1003: 
            case 1004: 
            case 1005: 
            case 1009: 
            case 1010: 
            case 1011: 
            case 1012: {
                d = this.math(n);
                break;
            }
            case 1006: 
            case 1007: 
            case 1008: {
                d = this.math2(n);
                break;
            }
            case 1013: {
                this.interp.getParens();
                d = System.currentTimeMillis();
                break;
            }
            case 1014: {
                this.interp.getParens();
                d = this.getImage().getWidth();
                break;
            }
            case 1015: {
                this.interp.getParens();
                d = this.getImage().getHeight();
                break;
            }
            case 1016: {
                d = this.random();
                break;
            }
            case 1018: 
            case 1027: {
                d = this.getResultsCount();
                break;
            }
            case 1017: {
                d = this.getResult();
                break;
            }
            case 1019: {
                d = this.getNumber();
                break;
            }
            case 1020: {
                d = this.getImageCount();
                break;
            }
            case 1021: {
                d = this.getStackSize();
                break;
            }
            case 1022: {
                d = this.showMessage(true);
                break;
            }
            case 1023: {
                d = this.lengthOf();
                break;
            }
            case 1024: {
                d = this.getCoordinateCount();
                break;
            }
            case 1025: 
            case 1026: {
                d = this.getCoordinate(n);
                break;
            }
            case 1028: {
                this.interp.getParens();
                d = this.getImage().getID();
                break;
            }
            default: {
                this.interp.error("Numeric function expected");
            }
        }
        return d;
    }

    String getStringFunction(int n) {
        String string;
        switch (n) {
            case 2000: {
                string = this.d2s();
                break;
            }
            case 2001: {
                string = this.toString(16);
                break;
            }
            case 2002: {
                string = this.toString(2);
                break;
            }
            case 2003: {
                this.interp.getParens();
                string = this.getImage().getTitle();
                break;
            }
            case 2004: {
                string = this.getStringDialog();
                break;
            }
            default: {
                string = "";
                this.interp.error("String function expected");
            }
        }
        return string;
    }

    final double math(int n) {
        double d = this.getArg();
        switch (n) {
            case 1001: {
                return Math.abs(d);
            }
            case 1002: {
                return Math.cos(d);
            }
            case 1003: {
                return Math.exp(d);
            }
            case 1004: {
                return Math.floor(d);
            }
            case 1005: {
                return Math.log(d);
            }
            case 1009: {
                return Math.round(d);
            }
            case 1010: {
                return Math.sin(d);
            }
            case 1011: {
                return Math.sqrt(d);
            }
            case 1012: {
                return Math.tan(d);
            }
        }
        return 0.0;
    }

    final double math2(int n) {
        double d = this.getFirstArg();
        double d2 = this.getLastArg();
        switch (n) {
            case 1007: {
                return Math.min(d, d2);
            }
            case 1006: {
                return Math.max(d, d2);
            }
            case 1008: {
                return Math.pow(d, d2);
            }
        }
        return 0.0;
    }

    final String getString() {
        String string = this.interp.getStringTerm();
        while (true) {
            this.interp.getToken();
            if (this.interp.token != 43) break;
            string = string + this.interp.getStringTerm();
        }
        this.interp.putTokenBack();
        return string;
    }

    final boolean isStringFunction() {
        Symbol symbol = this.pgm.table[this.interp.tokenAddress];
        return symbol.type == 2000;
    }

    final double getArg() {
        this.interp.getLeftParen();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        return d;
    }

    final double getFirstArg() {
        this.interp.getLeftParen();
        return this.interp.getExpression();
    }

    final double getNextArg() {
        this.interp.getComma();
        return this.interp.getExpression();
    }

    final double getLastArg() {
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        return d;
    }

    String getStringArg() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getRightParen();
        return string;
    }

    boolean getBooleanArg() {
        this.interp.getLeftParen();
        double d = this.interp.getBooleanExpression();
        this.interp.checkBoolean(d);
        this.interp.getRightParen();
        return d != 0.0;
    }

    int getIndex() {
        this.interp.getToken();
        if (this.interp.token != 91) {
            this.interp.error("'['expected");
        }
        int n = (int)this.interp.getExpression();
        this.interp.getToken();
        if (this.interp.token != 93) {
            this.interp.error("']' expected");
        }
        return n;
    }

    void checkIndex(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            this.interp.error("Index (" + n + ") is outside of the " + n2 + "-" + n3 + " range");
        }
    }

    void doRun() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getToken();
        if (this.interp.token != 41 && this.interp.token != 44) {
            this.interp.error("',' or ')'  expected");
        }
        String string2 = null;
        if (this.interp.token == 44) {
            string2 = this.getString();
            this.interp.getRightParen();
        }
        if (string2 != null) {
            IJ.run(string, string2);
        } else {
            IJ.run(string);
        }
        this.resetImage();
    }

    void setForegroundColor() {
        IJ.setForegroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setBackgroundColor() {
        IJ.setBackgroundColor((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void setColor() {
        int n = (int)this.getFirstArg();
        int n2 = (int)this.getNextArg();
        int n3 = (int)this.getLastArg();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        Color color = new Color(n, n2, n3);
        this.getProcessor().setColor(color);
    }

    void makeLine() {
        IJ.makeLine((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeOval() {
        IJ.makeOval((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    void makeRectangle() {
        IJ.makeRectangle((int)this.getFirstArg(), (int)this.getNextArg(), (int)this.getNextArg(), (int)this.getLastArg());
        this.resetImage();
    }

    ImagePlus getImage() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        if (this.imp.getWindow() == null) {
            throw new RuntimeException("Macro canceled");
        }
        return this.imp;
    }

    void resetImage() {
        this.imp = null;
        this.ip = null;
    }

    ImageProcessor getProcessor() {
        if (this.ip == null) {
            this.ip = this.getImage().getProcessor();
        }
        return this.ip;
    }

    int getType() {
        if (this.imp == null) {
            this.imp = IJ.getImage();
        }
        this.imageType = this.imp.getType();
        return this.imageType;
    }

    double getPixel() {
        this.interp.getLeftParen();
        int n = (int)this.interp.getExpression();
        this.interp.getComma();
        int n2 = (int)this.interp.getExpression();
        this.interp.getRightParen();
        double d = 0.0;
        ImageProcessor imageProcessor = this.getProcessor();
        d = this.getType() == 2 ? (double)imageProcessor.getPixelValue(n, n2) : (double)imageProcessor.getPixel(n, n2);
        return d;
    }

    void setPixel() {
        this.interp.getLeftParen();
        int n = (int)this.interp.getExpression();
        this.interp.getComma();
        int n2 = (int)this.interp.getExpression();
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        if (this.getType() == 2) {
            this.getProcessor().putPixelValue(n, n2, d);
        } else {
            this.getProcessor().putPixel(n, n2, (int)d);
        }
        this.updateNeeded = true;
    }

    void moveTo() {
        this.interp.getLeftParen();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().moveTo(n, n2);
    }

    void lineTo() {
        this.interp.getLeftParen();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().lineTo(n, n2);
        this.updateAndDraw(this.imp);
    }

    void drawLine() {
        this.interp.getLeftParen();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n3 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n4 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().drawLine(n, n2, n3, n4);
        this.updateAndDraw(this.imp);
    }

    void doIPMethod(int n) {
        this.interp.getParens();
        ImageProcessor imageProcessor = this.getProcessor();
        switch (n) {
            case 333: {
                imageProcessor.snapshot();
                break;
            }
            case 334: {
                imageProcessor.reset();
                break;
            }
            case 335: {
                ImagePlus imagePlus = this.getImage();
                Roi roi = imagePlus.getRoi();
                if (roi == null) {
                    imageProcessor.resetRoi();
                    imageProcessor.fill();
                } else {
                    imageProcessor.setRoi(roi.getBoundingRect());
                    imageProcessor.fill(imagePlus.getMask());
                }
                this.updateAndDraw(imagePlus);
            }
        }
    }

    void updateAndDraw(ImagePlus imagePlus) {
        if (this.autoUpdate) {
            imagePlus.updateAndDraw();
        } else {
            this.updateNeeded = true;
        }
    }

    void updateDisplay() {
        if (this.updateNeeded) {
            ImagePlus imagePlus = this.getImage();
            imagePlus.updateAndDraw();
            this.updateNeeded = false;
        }
    }

    void drawString() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        int n = (int)(this.interp.getExpression() + 0.5);
        this.interp.getComma();
        int n2 = (int)(this.interp.getExpression() + 0.5);
        this.interp.getRightParen();
        this.getProcessor().drawString(string, n, n2);
        this.updateAndDraw(this.imp);
    }

    void changeValues() {
        double d = this.getFirstArg();
        double d2 = this.getNextArg();
        double d3 = this.getLastArg();
        ImagePlus imagePlus = this.getImage();
        ImageProcessor imageProcessor = this.getProcessor();
        Roi roi = imagePlus.getRoi();
        int[] nArray = null;
        if (roi == null || roi.getType() > 4) {
            imageProcessor.resetRoi();
            roi = null;
        } else {
            imageProcessor.setRoi(roi.getBoundingRect());
            nArray = imagePlus.getMask();
            imageProcessor.setMask(nArray);
            if (nArray != null) {
                imageProcessor.snapshot();
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        if (roi != null) {
            Rectangle rectangle = roi.getBoundingRect();
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.x + rectangle.width;
            n4 = rectangle.y + rectangle.height;
        }
        boolean bl = this.getType() == 2;
        int n5 = n2;
        while (n5 < n4) {
            int n6 = n;
            while (n6 < n3) {
                double d4;
                double d5 = d4 = bl ? (double)imageProcessor.getPixelValue(n6, n5) : (double)(imageProcessor.getPixel(n6, n5) & 0xFFFFFF);
                if (d4 >= d && d4 <= d2) {
                    if (bl) {
                        imageProcessor.putPixelValue(n6, n5, d3);
                    } else {
                        imageProcessor.putPixel(n6, n5, (int)d3);
                    }
                }
                ++n6;
            }
            ++n5;
        }
        if (nArray != null) {
            imageProcessor.reset(nArray);
        }
        if (imagePlus.getType() == 1 || imagePlus.getType() == 2) {
            imageProcessor.resetMinAndMax();
        }
        imagePlus.updateAndDraw();
        this.updateNeeded = false;
    }

    void setImage() {
    }

    void requires() {
        if (IJ.versionLessThan(this.getStringArg())) {
            this.interp.done = true;
        }
    }

    double random() {
        this.interp.getParens();
        if (this.ran == null) {
            this.ran = new Random();
        }
        return this.ran.nextDouble();
    }

    double getResult() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        int n = (int)this.interp.getExpression();
        this.interp.getRightParen();
        ResultsTable resultsTable = Analyzer.getResultsTable();
        int n2 = resultsTable.getColumnIndex(string);
        if (n2 == -1) {
            this.interp.error("'" + string + "' not found");
        }
        if (n < 0 || n >= resultsTable.getCounter()) {
            this.interp.error("Row (" + n + ") out of range");
        }
        return resultsTable.getValue(n2, n);
    }

    double getNumber() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        double d = this.interp.getExpression();
        this.interp.getRightParen();
        double d2 = IJ.getNumber(string, d);
        if (d2 == -2.147483648E9) {
            this.interp.done = true;
            d2 = d;
        }
        return d2;
    }

    String getStringDialog() {
        this.interp.getLeftParen();
        String string = this.getString();
        this.interp.getComma();
        String string2 = this.getString();
        this.interp.getRightParen();
        String string3 = IJ.getString(string, string2);
        if (string3.equals("")) {
            this.interp.done = true;
            string3 = string2;
        }
        return string3;
    }

    String d2s() {
        return IJ.d2s(this.getFirstArg(), (int)this.getLastArg());
    }

    String toString(int n) {
        int n2 = (int)this.getArg();
        if (n == 2) {
            return Integer.toBinaryString(n2);
        }
        return Integer.toHexString(n2);
    }

    double getStackSize() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return this.getImage().getStackSize();
    }

    double getImageCount() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return WindowManager.getWindowCount();
    }

    double getCoordinateCount() {
        ImagePlus imagePlus;
        Roi roi;
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        if ((roi = (imagePlus = this.getImage()).getRoi()) == null) {
            return 0.0;
        }
        if (roi instanceof PolygonRoi) {
            return ((PolygonRoi)roi).getNCoordinates();
        }
        return 0.0;
    }

    double getResultsCount() {
        if (this.interp.nextToken() == 40) {
            this.interp.getParens();
        }
        return Analyzer.getResultsTable().getCounter();
    }

    double getCoordinate(int n) {
        int n2 = this.getIndex();
        ImagePlus imagePlus = this.getImage();
        Roi roi = imagePlus.getRoi();
        if (roi != null && roi instanceof PolygonRoi) {
            int n3 = ((PolygonRoi)roi).getNCoordinates();
            this.checkIndex(n2, 0, n3 - 1);
            Rectangle rectangle = roi.getBoundingRect();
            if (n == 1025) {
                int[] nArray = ((PolygonRoi)roi).getXCoordinates();
                return rectangle.x + nArray[n2];
            }
            int[] nArray = ((PolygonRoi)roi).getYCoordinates();
            return rectangle.y + nArray[n2];
        }
        this.interp.error("Polygonal ROI required");
        return 0.0;
    }

    double showMessage(boolean bl) {
        String string;
        this.interp.getLeftParen();
        String string2 = this.getString();
        if (this.interp.nextToken() == 44) {
            this.interp.getComma();
            string = this.getString();
        } else {
            string = string2;
            string2 = "";
        }
        this.interp.getRightParen();
        if (bl) {
            return IJ.showMessageWithCancel(string2, string) ? 1.0 : 0.0;
        }
        IJ.showMessage(string2, string);
        return 0.0;
    }

    double lengthOf() {
        String string = this.getStringArg();
        return string.length();
    }
}

