/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class ZProjector
implements PlugIn {
    public static final int AVG_METHOD = 0;
    public static final int MAX_METHOD = 1;
    public static final int MIN_METHOD = 2;
    public static final int SUM_METHOD = 3;
    public static final int SD_METHOD = 4;
    public static final String[] METHODS = new String[]{"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation"};
    private static int method = 0;
    private static final int BYTE_TYPE = 0;
    private static final int SHORT_TYPE = 1;
    private static final int FLOAT_TYPE = 2;
    public static final String lutMessage = "Stacks with inverter LUTs may not project correctly.\nTo create a standard LUT, invert the stack (Edit/Invert)\nand invert the LUT (Image/Lookup Tables/Invert LUT).";
    private ImagePlus projImage = null;
    private ImagePlus imp = null;
    private int startSlice = 1;
    private int stopSlice = 1;
    static /* synthetic */ Class class$ij$plugin$ZProjector;

    public ZProjector() {
    }

    public ZProjector(ImagePlus imagePlus) {
        this.setImage(imagePlus);
    }

    public void setImage(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.startSlice = 1;
        this.stopSlice = imagePlus.getStackSize();
    }

    public void setStartSlice(int n) {
        if (this.imp == null || n < 1 || n > this.imp.getStackSize()) {
            return;
        }
        this.startSlice = n;
    }

    public void setStopSlice(int n) {
        if (this.imp == null || n < 1 || n > this.imp.getStackSize()) {
            return;
        }
        this.stopSlice = n;
    }

    public ImagePlus getProjection() {
        return this.projImage;
    }

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() == 1) {
            IJ.showMessage("ZProjection", "Stack required");
            return;
        }
        if (this.imp.getType() == 4) {
            IJ.showMessage("ZProjection", "RGB stacks are not supported.");
            return;
        }
        if (this.imp.getProcessor().isInvertedLut() && !IJ.showMessageWithCancel("ZProjection", lutMessage)) {
            return;
        }
        this.startSlice = 1;
        this.stopSlice = this.imp.getStackSize();
        GenericDialog genericDialog = this.buildControlDialog(this.startSlice, this.stopSlice);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        if (!this.imp.lock()) {
            return;
        }
        long l = System.currentTimeMillis();
        this.doProjection(genericDialog);
        if (string.equals("")) {
            long l2 = System.currentTimeMillis();
            this.projImage.show("ZProjector: " + IJ.d2s((double)(l2 - l) / 1000.0, 2) + " seconds");
        }
        this.imp.unlock();
        IJ.register(class$ij$plugin$ZProjector == null ? (class$ij$plugin$ZProjector = ZProjector.class$("ij.plugin.ZProjector")) : class$ij$plugin$ZProjector);
    }

    private void doProjection(GenericDialog genericDialog) {
        this.setStartSlice((int)genericDialog.getNextNumber());
        this.setStopSlice((int)genericDialog.getNextNumber());
        method = genericDialog.getNextChoiceIndex();
        this.computeProjection(method);
    }

    protected GenericDialog buildControlDialog(int n, int n2) {
        GenericDialog genericDialog = new GenericDialog("ZProjection", IJ.getInstance());
        genericDialog.addNumericField("Start slice:", this.startSlice, 0);
        genericDialog.addNumericField("Stop slice:", this.stopSlice, 0);
        genericDialog.addChoice("Projection Type", METHODS, METHODS[method]);
        return genericDialog;
    }

    public void computeProjection(int n) {
        int n2;
        if (this.imp == null) {
            return;
        }
        FloatProcessor floatProcessor = new FloatProcessor(this.imp.getWidth(), this.imp.getHeight());
        ImageStack imageStack = this.imp.getStack();
        RayFunction rayFunction = this.getRayFunction(n, floatProcessor);
        if (IJ.debugMode) {
            IJ.log("\nProjecting stack from: " + this.startSlice + " to: " + this.stopSlice);
        }
        if (imageStack.getProcessor(1) instanceof ByteProcessor) {
            n2 = 0;
        } else if (imageStack.getProcessor(1) instanceof ShortProcessor) {
            n2 = 1;
        } else if (imageStack.getProcessor(1) instanceof FloatProcessor) {
            n2 = 2;
        } else {
            IJ.error("ZProjection_: Unknown processor type.");
            return;
        }
        Object[] objectArray = imageStack.getImageArray();
        int n3 = this.startSlice;
        while (n3 <= this.stopSlice) {
            IJ.showStatus("ZProjection - projecting slice: " + n3);
            this.projectSlice(objectArray[n3 - 1], rayFunction, n2);
            ++n3;
        }
        if (n == 3) {
            floatProcessor.resetMinAndMax();
            this.projImage = new ImagePlus("Sum", floatProcessor);
        } else if (n == 4) {
            rayFunction.postProcess();
            floatProcessor.resetMinAndMax();
            this.projImage = new ImagePlus("Standard Deviation", floatProcessor);
        } else {
            rayFunction.postProcess();
            this.projImage = this.makeOutputImage(this.imp, floatProcessor, n2);
        }
        if (this.projImage == null) {
            IJ.error("ZProjection - error computing projection.");
        }
    }

    private RayFunction getRayFunction(int n, FloatProcessor floatProcessor) {
        if (n == 0 || n == 3) {
            return new AverageIntensity(floatProcessor, this.stopSlice - this.startSlice + 1);
        }
        if (n == 1) {
            return new MaxIntensity(floatProcessor);
        }
        if (n == 2) {
            return new MinIntensity(floatProcessor);
        }
        if (n == 4) {
            return new StandardDeviation(floatProcessor, this.stopSlice - this.startSlice + 1);
        }
        IJ.error("ZProjection - unknown method.");
        return null;
    }

    private ImagePlus makeOutputImage(ImagePlus imagePlus, FloatProcessor floatProcessor, int n) {
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        float[] fArray = (float[])floatProcessor.getPixels();
        ImageProcessor imageProcessor = null;
        int n4 = fArray.length;
        switch (n) {
            case 0: {
                imageProcessor = imagePlus.getProcessor().createProcessor(n2, n3);
                byte[] byArray = (byte[])imageProcessor.getPixels();
                int n5 = 0;
                while (n5 < n4) {
                    byArray[n5] = (byte)fArray[n5];
                    ++n5;
                }
                break;
            }
            case 1: {
                imageProcessor = imagePlus.getProcessor().createProcessor(n2, n3);
                short[] sArray = (short[])imageProcessor.getPixels();
                int n6 = 0;
                while (n6 < n4) {
                    sArray[n6] = (short)fArray[n6];
                    ++n6;
                }
                break;
            }
            case 2: {
                imageProcessor = new FloatProcessor(n2, n3, fArray, null);
            }
        }
        imageProcessor.resetMinAndMax();
        return new ImagePlus("ZProjection of " + imagePlus.getShortTitle(), imageProcessor);
    }

    private void projectSlice(Object object, RayFunction rayFunction, int n) {
        switch (n) {
            case 0: {
                rayFunction.projectSlice((byte[])object);
                break;
            }
            case 1: {
                rayFunction.projectSlice((short[])object);
                break;
            }
            case 2: {
                rayFunction.projectSlice((float[])object);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class StandardDeviation
    extends RayFunction {
        FloatProcessor fp;
        private float[] sum;
        private float[] sum2;
        private int num;
        private int len;

        public StandardDeviation(FloatProcessor floatProcessor, int n) {
            this.sum = (float[])floatProcessor.getPixels();
            this.len = this.sum.length;
            this.sum2 = new float[this.len];
            this.num = n;
        }

        public void projectSlice(byte[] byArray) {
            int n = 0;
            while (n < this.len) {
                int n2 = byArray[n] & 0xFF;
                int n3 = n;
                this.sum[n3] = this.sum[n3] + (float)n2;
                int n4 = n++;
                this.sum2[n4] = this.sum2[n4] + (float)(n2 * n2);
            }
        }

        public void projectSlice(short[] sArray) {
            int n = 0;
            while (n < this.len) {
                int n2 = sArray[n] & 0xFFFF;
                int n3 = n;
                this.sum[n3] = this.sum[n3] + (float)n2;
                int n4 = n++;
                this.sum2[n4] = this.sum2[n4] + (float)(n2 * n2);
            }
        }

        public void projectSlice(float[] fArray) {
            int n = 0;
            while (n < this.len) {
                float f = fArray[n];
                int n2 = n;
                this.sum[n2] = this.sum[n2] + f;
                int n3 = n++;
                this.sum2[n3] = this.sum2[n3] + f * f;
            }
        }

        public void postProcess() {
            double d = this.num;
            int n = 0;
            while (n < this.len) {
                double d2;
                this.sum[n] = this.num > 1 ? ((d2 = (d * (double)this.sum2[n] - (double)(this.sum[n] * this.sum[n])) / d) > 0.0 ? (float)Math.sqrt(d2 / (d - 1.0)) : 0.0f) : 0.0f;
                ++n;
            }
        }
    }

    class MinIntensity
    extends RayFunction {
        private FloatProcessor fp;
        private float[] fpixels;
        private int len;

        public MinIntensity(FloatProcessor floatProcessor) {
            this.fpixels = (float[])floatProcessor.getPixels();
            this.len = this.fpixels.length;
            int n = 0;
            while (n < this.len) {
                this.fpixels[n] = Float.MAX_VALUE;
                ++n;
            }
        }

        public void projectSlice(byte[] byArray) {
            int n = 0;
            while (n < this.len) {
                if ((float)(byArray[n] & 0xFF) < this.fpixels[n]) {
                    this.fpixels[n] = byArray[n] & 0xFF;
                }
                ++n;
            }
        }

        public void projectSlice(short[] sArray) {
            int n = 0;
            while (n < this.len) {
                if ((float)(sArray[n] & 0xFFFF) < this.fpixels[n]) {
                    this.fpixels[n] = sArray[n] & 0xFFFF;
                }
                ++n;
            }
        }

        public void projectSlice(float[] fArray) {
            int n = 0;
            while (n < this.len) {
                if (fArray[n] < this.fpixels[n]) {
                    this.fpixels[n] = fArray[n];
                }
                ++n;
            }
        }
    }

    class MaxIntensity
    extends RayFunction {
        private FloatProcessor fp;
        private float[] fpixels;
        private int len;

        public MaxIntensity(FloatProcessor floatProcessor) {
            this.fpixels = (float[])floatProcessor.getPixels();
            this.len = this.fpixels.length;
            int n = 0;
            while (n < this.len) {
                this.fpixels[n] = -3.4028235E38f;
                ++n;
            }
        }

        public void projectSlice(byte[] byArray) {
            int n = 0;
            while (n < this.len) {
                if ((float)(byArray[n] & 0xFF) > this.fpixels[n]) {
                    this.fpixels[n] = byArray[n] & 0xFF;
                }
                ++n;
            }
        }

        public void projectSlice(short[] sArray) {
            int n = 0;
            while (n < this.len) {
                if ((float)(sArray[n] & 0xFFFF) > this.fpixels[n]) {
                    this.fpixels[n] = sArray[n] & 0xFFFF;
                }
                ++n;
            }
        }

        public void projectSlice(float[] fArray) {
            int n = 0;
            while (n < this.len) {
                if (fArray[n] > this.fpixels[n]) {
                    this.fpixels[n] = fArray[n];
                }
                ++n;
            }
        }
    }

    class AverageIntensity
    extends RayFunction {
        private float[] fpixels;
        private int num;
        private int len;

        public AverageIntensity(FloatProcessor floatProcessor, int n) {
            this.fpixels = (float[])floatProcessor.getPixels();
            this.len = this.fpixels.length;
            this.num = n;
        }

        public void projectSlice(byte[] byArray) {
            int n = 0;
            while (n < this.len) {
                int n2 = n;
                this.fpixels[n2] = this.fpixels[n2] + (float)(byArray[n] & 0xFF);
                ++n;
            }
        }

        public void projectSlice(short[] sArray) {
            int n = 0;
            while (n < this.len) {
                int n2 = n;
                this.fpixels[n2] = this.fpixels[n2] + (float)(sArray[n] & 0xFFFF);
                ++n;
            }
        }

        public void projectSlice(float[] fArray) {
            int n = 0;
            while (n < this.len) {
                int n2 = n;
                this.fpixels[n2] = this.fpixels[n2] + fArray[n];
                ++n;
            }
        }

        public void postProcess() {
            float f = this.num;
            int n = 0;
            while (n < this.len) {
                int n2 = n++;
                this.fpixels[n2] = this.fpixels[n2] / f;
            }
        }
    }

    abstract class RayFunction {
        RayFunction() {
        }

        public abstract void projectSlice(byte[] var1);

        public abstract void projectSlice(short[] var1);

        public abstract void projectSlice(float[] var1);

        public void postProcess() {
        }
    }
}

