/*
 * Decompiled with CFR 0.152.
 */
package ij.text;

import ij.text.TextPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

class TextCanvas
extends Canvas {
    TextPanel tp;
    Font fFont;
    FontMetrics fMetrics;
    Graphics gImage;
    Image iImage;

    TextCanvas(TextPanel textPanel) {
        this.tp = textPanel;
        this.addMouseListener(textPanel);
        this.addMouseMotionListener(textPanel);
        this.addKeyListener(textPanel);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.tp.adjustVScroll();
        this.tp.adjustHScroll();
        this.iImage = null;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        if (this.tp == null || graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        graphics.setColor(Color.lightGray);
        if (this.iImage == null) {
            this.makeImage(n2, n3);
        }
        if (this.tp.iRowHeight == 0 || this.tp.iColWidth[0] == 0 && this.tp.iRowCount > 0) {
            this.tp.iRowHeight = this.fMetrics.getHeight() + 2;
            n = 0;
            while (n < this.tp.iColCount) {
                this.calcAutoWidth(n);
                ++n;
            }
            this.tp.adjustHScroll();
            this.tp.adjustVScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, n2, n3);
        if (this.tp.headings) {
            this.drawColumnLabels(n2);
        }
        n = this.tp.iRowHeight + 1 - this.tp.iY;
        int n4 = 0;
        while (n < this.tp.iRowHeight + 1) {
            ++n4;
            n += this.tp.iRowHeight;
        }
        this.tp.iFirstRow = n4;
        n = this.tp.iRowHeight + 1;
        while (n < n3 && n4 < this.tp.iRowCount) {
            int n5 = -this.tp.iX;
            int n6 = 0;
            while (n6 < this.tp.iColCount) {
                int n7 = this.tp.iColWidth[n6];
                Color color = Color.white;
                Color color2 = Color.black;
                if (n4 >= this.tp.selStart && n4 <= this.tp.selEnd) {
                    color = Color.black;
                    color2 = Color.white;
                    this.gImage.setColor(color);
                    this.gImage.fillRect(n5, n, n7 - 1, this.tp.iRowHeight);
                }
                this.gImage.setColor(color2);
                char[] cArray = this.getChars(n6, n4);
                if (cArray != null) {
                    this.gImage.drawChars(cArray, 0, cArray.length, n5 + 2, n + this.tp.iRowHeight - 5);
                }
                n5 += n7;
                ++n6;
            }
            ++n4;
            n += this.tp.iRowHeight;
        }
        if (this.iImage != null) {
            graphics.drawImage(this.iImage, 0, 0, null);
        }
    }

    void makeImage(int n, int n2) {
        this.iImage = this.createImage(n, n2);
        if (this.gImage != null) {
            this.gImage.dispose();
        }
        this.gImage = this.iImage.getGraphics();
        if (this.fFont == null) {
            this.fFont = new Font("Dialog", 0, 12);
        }
        this.gImage.setFont(this.fFont);
        if (this.fMetrics == null) {
            this.fMetrics = this.gImage.getFontMetrics();
        }
    }

    void drawColumnLabels(int n) {
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.tp.iRowHeight, n, this.tp.iRowHeight);
        int n2 = -this.tp.iX;
        int n3 = 0;
        while (n3 < this.tp.iColCount) {
            int n4 = this.tp.iColWidth[n3];
            this.gImage.setColor(Color.lightGray);
            this.gImage.fillRect(n2 + 1, 0, n4, this.tp.iRowHeight);
            this.gImage.setColor(Color.black);
            if (this.tp.sColHead[n3] != null) {
                this.gImage.drawString(this.tp.sColHead[n3], n2 + 2, this.tp.iRowHeight - 5);
            }
            if (this.tp.iColCount > 1) {
                this.gImage.setColor(Color.darkGray);
                this.gImage.drawLine(n2 + n4 - 1, 0, n2 + n4 - 1, this.tp.iRowHeight - 1);
                this.gImage.setColor(Color.white);
                this.gImage.drawLine(n2 + n4, 0, n2 + n4, this.tp.iRowHeight - 1);
            }
            n2 += n4;
            ++n3;
        }
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, 1, this.tp.iRowHeight);
        this.gImage.fillRect(n2 + 1, 0, n - n2, this.tp.iRowHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, 0, n, 0);
    }

    char[] getChars(int n, int n2) {
        if (n2 >= this.tp.vData.size()) {
            return null;
        }
        char[] cArray = (char[])this.tp.vData.elementAt(n2);
        if (cArray.length == 0) {
            return null;
        }
        if (this.tp.iColCount == 1) {
            int n3 = 0;
            while (n3 < cArray.length) {
                if (cArray[n3] < ' ') {
                    cArray[n3] = 32;
                }
                ++n3;
            }
            return cArray;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = cArray.length;
        while (n > n5) {
            if (cArray[n4] == '\t') {
                ++n5;
            }
            if (++n4 < n6) continue;
            return null;
        }
        if (n4 < 0 || n4 >= cArray.length) {
            System.out.println("start=" + n4 + ", chars.length=" + cArray.length);
            return null;
        }
        if (cArray[n4] == '\t') {
            return null;
        }
        int n7 = n4;
        while (cArray[n7] != '\t' && n7 < n6 - 1) {
            ++n7;
        }
        if (cArray[n7] == '\t') {
            --n7;
        }
        char[] cArray2 = new char[n7 - n4 + 1];
        int n8 = 0;
        int n9 = n4;
        while (n8 < cArray2.length) {
            cArray2[n8] = cArray[n9];
            ++n8;
            ++n9;
        }
        return cArray2;
    }

    void calcAutoWidth(int n) {
        int n2;
        if (this.tp.sColHead == null || n >= this.tp.iColWidth.length) {
            return;
        }
        if (this.fMetrics == null) {
            this.fMetrics = this.gImage.getFontMetrics();
        }
        int n3 = 15;
        if (this.tp.iColCount == 1) {
            n2 = 100;
        } else {
            n2 = 20;
            if (n == 0 && this.tp.sColHead[0].equals(" ")) {
                n3 += 5;
            } else {
                char[] cArray = this.tp.sColHead[n].toCharArray();
                n3 = Math.max(n3, this.fMetrics.charsWidth(cArray, 0, cArray.length));
            }
        }
        int n4 = Math.min(this.tp.iRowCount, n2);
        int n5 = 0;
        while (n5 < n4) {
            char[] cArray = this.getChars(n, n5);
            if (cArray != null) {
                n3 = Math.max(n3, this.fMetrics.charsWidth(cArray, 0, cArray.length));
            }
            ++n5;
        }
        this.tp.iColWidth[n] = n3 + 15;
    }
}

