/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSLong
extends XSPatternBase {
    Long maxInclusive = null;
    Long maxExclusive = null;
    Long minInclusive = null;
    Long minExclusive = null;
    private static JType jType = JType.Long;
    private boolean _asWrapper = false;

    public XSLong() {
        this(false);
    }

    public XSLong(boolean asWrapper) {
        super((short)35);
        this._asWrapper = asWrapper;
        jType = this._asWrapper ? new JClass("java.lang.Long") : JType.Long;
    }

    public JType getJType() {
        return jType;
    }

    public Long getMaxExclusive() {
        return this.maxExclusive;
    }

    public Long getMaxInclusive() {
        return this.maxInclusive;
    }

    public Long getMinExclusive() {
        return this.minExclusive;
    }

    public Long getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(long max) {
        this.maxExclusive = new Long(max);
        this.maxInclusive = null;
    }

    public void setMaxExclusive(Long max) {
        this.maxExclusive = max;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(long max) {
        this.maxInclusive = new Long(max);
        this.maxExclusive = null;
    }

    public void setMaxInclusive(Long max) {
        this.maxInclusive = max;
        this.maxExclusive = null;
    }

    public void setMinExclusive(long min) {
        this.minExclusive = new Long(min);
        this.minInclusive = null;
    }

    public void setMinExclusive(Long min) {
        this.minExclusive = min;
        this.minInclusive = null;
    }

    public void setMinInclusive(long min) {
        this.minInclusive = new Long(min);
        this.minExclusive = null;
    }

    public void setMinInclusive(Long min) {
        this.minInclusive = min;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration theEnum = XSLong.getFacets(simpleType);
        while (theEnum.hasMoreElements()) {
            Facet facet = (Facet)theEnum.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(facet.toLong());
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(facet.toLong());
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(facet.toLong());
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(facet.toLong());
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return super.createToJavaObjectCode(variableName);
        }
        StringBuffer sb = new StringBuffer("new java.lang.Long(");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.lang.Long)");
        sb.append(variableName);
        sb.append(")");
        if (!this._asWrapper) {
            sb.append(".longValue()");
        }
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("LongValidator typeValidator = new LongValidator();");
        if (this.hasMinimum()) {
            Long min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator .setMinExclusive(");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator .setMinInclusive(");
            }
            jsc.append(min.toString());
            jsc.append("L);");
        }
        if (this.hasMaximum()) {
            Long max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator .setMaxExclusive(");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator .setMaxInclusive(");
            }
            jsc.append(max.toString());
            jsc.append("L);");
        }
        if (fixedValue != null) {
            Long.parseLong(fixedValue);
            jsc.add("typeValidator .setFixed(");
            jsc.append(fixedValue);
            jsc.append(");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator .setPattern(\"");
            jsc.append(XSLong.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }
}

