/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import org.exolab.castor.dsml.Consumer;
import org.exolab.castor.dsml.ImportDescriptor;
import org.exolab.castor.dsml.ImportExportException;
import org.exolab.castor.dsml.Importer;
import org.exolab.castor.dsml.mozilla.MozillaConsumer;

public class MozillaImporter
extends Importer {
    private LDAPConnection _conn;

    public MozillaImporter(LDAPConnection conn) {
        this._conn = conn;
    }

    protected Consumer createConsumer() {
        return new MozillaConsumer();
    }

    public void importEntry(LDAPEntry entry, int policy) throws LDAPException {
        if (entry.getAttributeSet() == null || entry.getAttributeSet().size() == 0) {
            if ((policy & 1) != 0) {
                try {
                    this._conn.read(entry.getDN());
                    this._conn.delete(entry.getDN());
                    this.notify(entry.getDN(), 3);
                }
                catch (LDAPException except) {
                    if (except.getLDAPResultCode() != 32) {
                        throw except;
                    }
                    this.notify(entry.getDN(), 0);
                }
            } else {
                this.notify(entry.getDN(), 0);
            }
        } else {
            try {
                LDAPAttribute attr;
                LDAPEntry existing = this._conn.read(entry.getDN());
                LDAPModificationSet modifs = new LDAPModificationSet();
                LDAPAttributeSet attrSet = entry.getAttributeSet();
                for (int i = 0; i < attrSet.size(); ++i) {
                    attr = attrSet.elementAt(i);
                    if (existing.getAttributeSet().getAttribute(attr.getName()) != null) {
                        if ((policy & 8) != 0) continue;
                        if (attr.size() > 0) {
                            modifs.add(2, attr);
                            continue;
                        }
                        modifs.add(1, attr);
                        continue;
                    }
                    if ((policy & 0x10) != 0 || attr.size() <= 0) continue;
                    modifs.add(0, attr);
                }
                if ((policy & 2) != 0) {
                    Enumeration theEnum = existing.getAttributeSet().getAttributes();
                    while (theEnum.hasMoreElements()) {
                        attr = (LDAPAttribute)theEnum.nextElement();
                        if (entry.getAttribute(attr.getName()) != null) continue;
                        modifs.add(1, attr);
                    }
                }
                if (modifs.size() > 0) {
                    this._conn.modify(entry.getDN(), modifs);
                    this.notify(entry.getDN(), 2);
                } else {
                    this.notify(entry.getDN(), 0);
                }
            }
            catch (LDAPException except) {
                if (except.getLDAPResultCode() != 32) {
                    throw except;
                }
                if ((policy & 4) == 0) {
                    this._conn.add(entry);
                    this.notify(entry.getDN(), 1);
                }
                this.notify(entry.getDN(), 0);
            }
        }
    }

    public void importEntries(Enumeration entries) throws ImportExportException {
        if (this.getImportDescriptor() == null) {
            this.setImportDescriptor(new ImportDescriptor());
        }
        try {
            while (entries.hasMoreElements()) {
                LDAPEntry entry = (LDAPEntry)entries.nextElement();
                this.importEntry(entry, this.getImportDescriptor().getPolicy(entry.getDN()));
            }
        }
        catch (LDAPException except) {
            throw new ImportExportException((Exception)((Object)except));
        }
    }
}

