/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class OracleQueryExpression
extends JDBCQueryExpression {
    public OracleQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        if (this._distinct) {
            sql.append(" DISTINCT ");
        }
        sql.append(this.getColumnList());
        sql.append(" FROM ");
        Enumeration theEnum = this._tables.keys();
        while (theEnum.hasMoreElements()) {
            String tableName;
            String tableAlias = (String)theEnum.nextElement();
            if (tableAlias.equals(tableName = (String)this._tables.get(tableAlias))) {
                sql.append(this._factory.quoteName(tableName));
            } else {
                sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
            }
            if (!theEnum.hasMoreElements()) continue;
            sql.append(",");
        }
        boolean first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            if (first) {
                sql.append(" WHERE ");
                first = false;
            } else {
                sql.append(" AND ");
            }
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            for (int j = 0; j < join.leftColumns.length; ++j) {
                if (j > 0) {
                    sql.append(" AND ");
                }
                sql.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[j]));
                sql.append("=");
                sql.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[j]));
                if (!join.outer) continue;
                sql.append("(+)");
            }
        }
        first = this.addWhereClause(sql, first);
        if (this._order != null) {
            sql.append(" ORDER BY ").append(this._order);
        }
        if (lock) {
            sql.append(" FOR UPDATE");
        }
        return sql.toString();
    }
}

