/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.util.Messages;

final class TransactionContextImpl
extends TransactionContext {
    private Hashtable _conns = new Hashtable();
    private boolean _globalTx;

    public TransactionContextImpl(Database db, boolean globalTx) {
        super(db);
        this._globalTx = globalTx;
    }

    protected void commitConnections() throws TransactionAbortedException {
        if (this._globalTx) {
            Enumeration theEnum = this._conns.elements();
            while (theEnum.hasMoreElements()) {
                try {
                    ((Connection)theEnum.nextElement()).close();
                }
                catch (SQLException except) {}
            }
            this._conns.clear();
        } else {
            try {
                Enumeration theEnum = this._conns.elements();
                while (theEnum.hasMoreElements()) {
                    Connection conn = (Connection)theEnum.nextElement();
                    conn.commit();
                }
            }
            catch (SQLException except) {
                throw new TransactionAbortedException(Messages.format("persist.nested", except), except);
            }
            finally {
                Enumeration theEnum = this._conns.elements();
                while (theEnum.hasMoreElements()) {
                    try {
                        ((Connection)theEnum.nextElement()).close();
                    }
                    catch (SQLException except) {}
                }
                this._conns.clear();
            }
        }
    }

    protected void closeConnections() throws TransactionAbortedException {
        SQLException error = null;
        if (!this._globalTx) {
            return;
        }
        Enumeration theEnum = this._conns.elements();
        while (theEnum.hasMoreElements()) {
            Connection conn = (Connection)theEnum.nextElement();
            try {
                conn.close();
            }
            catch (SQLException except) {
                error = except;
            }
        }
        this._conns.clear();
        if (error != null) {
            throw new TransactionAbortedException(Messages.format("persist.nested", error), error);
        }
    }

    protected void rollbackConnections() {
        Enumeration theEnum = this._conns.elements();
        while (theEnum.hasMoreElements()) {
            Connection conn = (Connection)theEnum.nextElement();
            try {
                if (!this._globalTx) {
                    conn.rollback();
                }
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this._conns.clear();
    }

    public Object getConnection(LockEngine engine) throws PersistenceException {
        Connection conn = (Connection)this._conns.get(engine);
        if (conn == null) {
            try {
                conn = DatabaseRegistry.createConnection(engine);
                if (!this._globalTx) {
                    conn.setAutoCommit(false);
                }
                this._conns.put(engine, conn);
            }
            catch (SQLException except) {
                throw new PersistenceException(Messages.format("persist.nested", except), except);
            }
        }
        return conn;
    }
}

