/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.AbstractBaseCache;
import org.exolab.castor.persist.cache.Cache;

public class CountLimited
extends AbstractBaseCache
implements Cache {
    private static final int LRU_OLD = 0;
    private static final int LRU_NEW = 1;
    private Hashtable mapKeyPos;
    private Object[] keys;
    private Object[] values;
    private int[] status;
    private int cur;
    private int size;
    public static int DEFAULT_SIZE = 30;
    private static Log _log = LogFactory.getFactory().getInstance(CountLimited.class);

    public CountLimited() {
        this.init(DEFAULT_SIZE);
    }

    public CountLimited(int size) {
        this.init(size);
    }

    protected void init(int size) {
        this.keys = new Object[size];
        this.values = new Object[size];
        this.status = new int[size];
        this.mapKeyPos = new Hashtable(size);
        this.size = size;
        if (_log.isDebugEnabled()) {
            _log.trace((Object)"Successfully initialzed count-limited cache instance");
        }
    }

    public synchronized Object put(Object key, Object value) {
        Object oldPos;
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Putting entry into cache for key " + key + " to " + value));
        }
        if ((oldPos = this.mapKeyPos.get(key)) != null) {
            int pos = (Integer)oldPos;
            Object oldObject = this.values[pos];
            this.values[pos] = value;
            this.status[pos] = 1;
            this.dispose(oldObject);
            return oldObject;
        }
        while (this.walkStatus() != 0) {
        }
        Integer intvalue = this.keys[this.cur] != null ? this.mapKeyPos.remove(this.keys[this.cur]) : new Integer(this.cur);
        Object oldObject = this.values[this.cur];
        this.keys[this.cur] = key;
        this.values[this.cur] = value;
        this.status[this.cur] = 1;
        this.mapKeyPos.put(key, intvalue);
        ++this.cur;
        if (this.cur >= this.size) {
            this.cur = 0;
        }
        if (oldObject != null) {
            this.dispose(oldObject);
        }
        return oldObject;
    }

    public synchronized Object get(Object key) {
        Object intvalue = this.mapKeyPos.get(key);
        Object cachedObject = null;
        if (intvalue != null) {
            int pos = (Integer)intvalue;
            this.status[pos] = 1;
            cachedObject = this.values[pos];
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Returning cache entry for key " + key + ": " + cachedObject));
        }
        return cachedObject;
    }

    public synchronized Object remove(Object key) {
        Object intvalue = this.mapKeyPos.remove(key);
        Object removedObject = null;
        if (intvalue != null) {
            int pos = (Integer)intvalue;
            removedObject = this.values[pos];
            this.keys[pos] = null;
            this.values[pos] = null;
            this.status[pos] = 0;
        }
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Removing cache entry for key " + key + ": " + removedObject));
        }
        return removedObject;
    }

    public Enumeration elements() {
        return new ValuesEnumeration(this.values);
    }

    public void expire(Object key) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Expiring cache entry for key " + key));
        }
        if (this.remove(key) == null) {
            // empty if block
        }
        this.dispose(key);
    }

    protected void dispose(Object o) {
        if (_log.isDebugEnabled()) {
            _log.trace((Object)("Disposing object " + o));
        }
    }

    private int walkStatus() {
        int s = this.status[this.cur];
        if (s == 1) {
            this.status[this.cur] = 0;
            ++this.cur;
            if (this.cur >= this.size) {
                this.cur = 0;
            }
            return 1;
        }
        return 0;
    }

    public boolean contains(Object key) {
        return this.get(key) != null;
    }

    public void setCapacity(int capacity) {
        super.setCapacity(capacity);
        this.size = capacity;
    }

    private class ValuesEnumeration
    implements Enumeration {
        private int cur;
        private Object[] values;

        private ValuesEnumeration(Object[] v) {
            Vector<Object> t = new Vector<Object>(v.length);
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == null) continue;
                t.add(v[i]);
            }
            this.values = t.toArray();
        }

        public boolean hasMoreElements() {
            return this.values != null && this.values.length > this.cur;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.values == null || this.values.length <= this.cur) {
                throw new NoSuchElementException();
            }
            return this.values[this.cur++];
        }
    }
}

