/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.builder.util.ConsoleDialog;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.BindXml;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.types.BindXmlNodeType;
import org.exolab.castor.mapping.xml.types.CollectionType;
import org.exolab.castor.util.CommandLineOptions;
import org.exolab.castor.xml.Introspector;
import org.exolab.castor.xml.JavaNaming;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;

public class MappingTool {
    private static final String UNDERSCORE = "_";
    private Hashtable _mappings = new Hashtable();
    private ClassDescriptorResolverImpl _resolver = new ClassDescriptorResolverImpl();
    private Introspector _introspector = null;
    private InternalLoader _mappingLoader = new InternalLoader();
    private boolean _forceIntrospection = false;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] args) {
        boolean force;
        CommandLineOptions allOptions = new CommandLineOptions();
        allOptions.addFlag("i", "classname", "Sets the input class");
        String desc = "Sets the output mapping filename";
        allOptions.addFlag("o", "filename", desc, true);
        desc = "Force overwriting of files.";
        allOptions.addFlag("f", "", desc, true);
        desc = "Displays this help screen.";
        allOptions.addFlag("h", "", desc, true);
        Properties options = allOptions.getOptions(args);
        if (options.getProperty("h") != null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            allOptions.printHelp(pw);
            pw.flush();
            return;
        }
        String classname = options.getProperty("i");
        String mappingName = options.getProperty("o");
        boolean bl = force = options.getProperty("f") != null;
        if (classname == null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            allOptions.printUsage(pw);
            pw.flush();
            return;
        }
        try {
            MappingTool tool = new MappingTool();
            tool.addClass(classname);
            Writer writer = null;
            if (mappingName == null || mappingName.length() == 0) {
                writer = new PrintWriter(System.out, true);
            } else {
                String message;
                ConsoleDialog dialog;
                File file = new File(mappingName);
                if (file.exists() && !force && !(dialog = new ConsoleDialog()).confirm(message = "The file already exists. Do you wish to overwrite '" + mappingName + "'?")) {
                    return;
                }
                writer = new FileWriter(file);
            }
            tool.write(writer);
        }
        catch (Exception except) {
            System.out.println(except);
            except.printStackTrace();
        }
    }

    public void addClass(String name) throws MappingException {
        this.addClass(name, true);
    }

    public void addClass(String name, boolean deep) throws MappingException {
        if (name == null) {
            throw new MappingException("Cannot introspect a null class.");
        }
        try {
            this.addClass(Class.forName(name), deep);
        }
        catch (ClassNotFoundException except) {
            throw new MappingException(except);
        }
    }

    public void addClass(Class cls) throws MappingException {
        this.addClass(cls, true);
    }

    public void addClass(Class cls, boolean deep) throws MappingException {
        XMLClassDescriptor xmlClass;
        if (cls == null) {
            throw new MappingException("Cannot introspect a null class.");
        }
        if (this._mappings.get(cls) != null) {
            return;
        }
        if (cls.isArray()) {
            Class<?> cType = cls.getComponentType();
            if (this._mappings.get(cType) != null) {
                return;
            }
            if (Types.isSimpleType(cType)) {
                return;
            }
            this.addClass(cType);
        }
        if (this._forceIntrospection && !Types.isConstructable(cls)) {
            throw new MappingException("mapping.classNotConstructable", cls.getName());
        }
        boolean introspected = false;
        try {
            if (this._forceIntrospection) {
                xmlClass = this._introspector.generateClassDescriptor(cls);
                introspected = true;
            } else {
                xmlClass = this._resolver.resolve(cls);
                introspected = Introspector.introspected(xmlClass);
            }
        }
        catch (MarshalException except) {
            throw new MappingException(except);
        }
        ClassMapping classMap = new ClassMapping();
        classMap.setName(cls.getName());
        classMap.setDescription("Default mapping for class " + cls.getName());
        classMap.setAccess(null);
        MapTo mapTo = new MapTo();
        mapTo.setXml(xmlClass.getXMLName());
        mapTo.setNsUri(xmlClass.getNameSpaceURI());
        mapTo.setNsPrefix(xmlClass.getNameSpacePrefix());
        classMap.setMapTo(mapTo);
        this._mappings.put(cls, classMap);
        FieldDescriptor[] fields = xmlClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fdesc = fields[i];
            String fieldName = fdesc.getFieldName();
            boolean isContainer = false;
            if (introspected && fieldName.startsWith("##container")) {
                fdesc = fdesc.getClassDescriptor().getFields()[0];
                fieldName = fdesc.getFieldName();
                isContainer = true;
            }
            Class fieldType = fdesc.getFieldType();
            if (!introspected && fieldName.startsWith(UNDERSCORE)) {
                int len;
                String tmpName;
                if (!this._mappingLoader.canFindAccessors(cls, fieldName, fieldType)) {
                    fieldName = fieldName.substring(1);
                }
                if (!this._mappingLoader.canFindAccessors(cls, fieldName, fieldType) && fieldName.endsWith("List") && this._mappingLoader.canFindAccessors(cls, tmpName = fieldName.substring(0, len = fieldName.length() - 4), fieldType)) {
                    fieldName = tmpName;
                }
            }
            FieldMapping fieldMap = new FieldMapping();
            fieldMap.setName(fieldName);
            boolean isArray = fieldType.isArray();
            while (fieldType.isArray()) {
                fieldType = fieldType.getComponentType();
            }
            if (fdesc.isRequired()) {
                fieldMap.setRequired(true);
            }
            if (fdesc.isTransient()) {
                fieldMap.setTransient(true);
            }
            if (fdesc.isMultivalued()) {
                if (isContainer) {
                    fieldMap.setContainer(false);
                }
                if (isArray) {
                    fieldMap.setCollection(CollectionType.ARRAY);
                } else {
                    String colName = CollectionHandlers.getCollectionName(fieldType);
                    if (colName != null) {
                        fieldMap.setCollection(CollectionType.valueOf(colName));
                        fieldType = class$java$lang$Object == null ? MappingTool.class$("java.lang.Object") : class$java$lang$Object;
                    } else if (this._mappingLoader.returnsArray(cls, fieldName, fieldType)) {
                        fieldMap.setCollection(CollectionType.ARRAY);
                    } else {
                        fieldMap.setCollection(CollectionType.ENUMERATE);
                    }
                }
            }
            fieldMap.setType(fieldType.getName());
            fieldMap.setBindXml(new BindXml());
            fieldMap.getBindXml().setName(((XMLFieldDescriptor)fdesc).getXMLName());
            fieldMap.getBindXml().setNode(BindXmlNodeType.valueOf(((XMLFieldDescriptor)fields[i]).getNodeType().toString()));
            classMap.addFieldMapping(fieldMap);
            if (!deep || this._mappings.get(fieldType) != null || Types.isSimpleType(fieldType)) continue;
            this.addClass(fieldType);
        }
    }

    public void setForceIntrospection(boolean force) {
        this._forceIntrospection = force;
        if (force && this._introspector == null) {
            this._introspector = new Introspector();
        }
    }

    public void write(Writer writer) throws MappingException {
        try {
            MappingRoot mapping = new MappingRoot();
            mapping.setDescription("Castor generated mapping file");
            Enumeration theEnum = this._mappings.elements();
            while (theEnum.hasMoreElements()) {
                mapping.addClassMapping((ClassMapping)theEnum.nextElement());
            }
            Marshaller marshal = new Marshaller(writer);
            marshal.setNamespaceMapping(null, "http://castor.exolab.org/");
            marshal.setNamespaceMapping("cst", "http://castor.exolab.org/");
            marshal.marshal(mapping);
        }
        catch (Exception except) {
            throw new MappingException(except);
        }
    }

    class InternalLoader
    extends MappingLoader {
        private static final String GET = "get";
        private static final String SET = "set";
        private static final String ADD = "add";

        InternalLoader() {
            super(null, null);
        }

        boolean returnsArray(Class claz, String fieldName, Class type) {
            try {
                Class<?> array = null;
                array = type.isArray() ? type : Array.newInstance(type, 0).getClass();
                String prefix = JavaNaming.toJavaClassName(fieldName);
                String method = GET + prefix;
                boolean isGet = true;
                if (InternalLoader.findAccessor(claz, method, array, isGet) != null) {
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }

        boolean canFindAccessors(Class claz, String fieldName, Class type) {
            try {
                String prefix = JavaNaming.toJavaClassName(fieldName);
                String method = GET + prefix;
                boolean isGet = true;
                if (InternalLoader.findAccessor(claz, method, type, isGet) != null) {
                    return true;
                }
                isGet = false;
                method = SET + prefix;
                if (InternalLoader.findAccessor(claz, method, type, isGet) != null) {
                    return true;
                }
                method = ADD + prefix;
                if (InternalLoader.findAccessor(claz, method, type, isGet) != null) {
                    return true;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return false;
        }
    }
}

