/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import com.ibm.cognos.xml.serializer.Serializer;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import org.exolab.castor.types.OperationNotSupportedException;
import org.exolab.castor.util.List;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.util.AnyNode2SAX;
import org.xml.sax.SAXException;

public final class AnyNode
implements Serializable {
    private static final String XMLNS_PREFIX = "xmlns";
    public static final short ELEMENT = 1;
    public static final short ATTRIBUTE = 2;
    public static final short NAMESPACE = 3;
    public static final short PI = 4;
    public static final short COMMENT = 5;
    public static final short TEXT = 6;
    private short _nodeType = 1;
    private AnyNode _nextSiblingNode = null;
    private AnyNode _firstChildNode = null;
    private String _localName;
    private String _uri;
    private String _prefix;
    private static Stack _elements;
    private String _value;

    public AnyNode() {
        this(1, null, null, null, null);
    }

    public AnyNode(short type, String localName, String prefix, String uri, String value) {
        if (type > 6 && type < 1) {
            throw new IllegalArgumentException("Illegal node type");
        }
        this._nodeType = type;
        if (type > 4 && localName != null) {
            String err = "This node can not have a local name";
            throw new IllegalArgumentException(err);
        }
        this._localName = localName;
        if (type > 3 && (uri != null || prefix != null)) {
            String err = "This node can not handle namespace";
            throw new IllegalArgumentException(err);
        }
        this._uri = uri;
        this._prefix = prefix;
        if (type == 2 && localName.startsWith(XMLNS_PREFIX)) {
            String err = "Namespaces can't be used as attributes.";
            throw new IllegalArgumentException(err);
        }
        if (type == 1 && value != null) {
            String err = "You can't set a value for this node type";
            throw new IllegalArgumentException(err);
        }
        this._value = value;
    }

    public void addAnyNode(AnyNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument in addAnyNode");
        }
        switch (node.getNodeType()) {
            case 2: {
                this.addAttribute(node);
                break;
            }
            case 3: {
                this.addNamespace(node);
                break;
            }
            default: {
                this.addChild(node);
            }
        }
    }

    public void addChild(AnyNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument in appendChild");
        }
        if (node.getNodeType() == 2 || node.getNodeType() == 3) {
            throw new IllegalArgumentException("An Attribute or an Namespace can't be added as a child");
        }
        if (this.getNodeType() == 6) {
            throw new IllegalArgumentException("a TEXT node can't have children.");
        }
        if (this._firstChildNode == null) {
            this._firstChildNode = node;
        } else if (this._firstChildNode.getNodeType() == 2 || this._firstChildNode.getNodeType() == 3) {
            this._firstChildNode.addChild(node);
        } else {
            this._firstChildNode.appendSibling(node);
        }
    }

    public void addAttribute(AnyNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument in addAttribute");
        }
        if (node.getNodeType() != 2) {
            throw new IllegalArgumentException("Only attribute can be added as an attribute");
        }
        if (this._firstChildNode == null) {
            this._firstChildNode = node;
        } else if (this._firstChildNode.getNodeType() == 2) {
            this._firstChildNode.appendSibling(node);
        } else if (this._firstChildNode.getNodeType() == 3) {
            this._firstChildNode.addAttribute(node);
        } else {
            node.addChild(this._firstChildNode);
            this._firstChildNode = node;
        }
    }

    public void addNamespace(AnyNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null argument in addNamespace");
        }
        if (node.getNodeType() != 3) {
            throw new IllegalArgumentException("Only namespace can be added as an namespace");
        }
        if (this._firstChildNode == null) {
            this._firstChildNode = node;
        } else if (this._firstChildNode.getNodeType() == 3) {
            this._firstChildNode.appendSibling(node);
        } else if (this._firstChildNode.getNodeType() == 2) {
            this._firstChildNode.addNamespace(node);
        } else {
            node.addChild(this._firstChildNode);
            this._firstChildNode = node;
        }
    }

    public AnyNode getFirstAttribute() {
        if (this.getNodeType() != 1) {
            String err = "This node type can not contain attributes";
            throw new OperationNotSupportedException(err);
        }
        boolean found = false;
        AnyNode tempNode = this.getFirstChildNode();
        while (tempNode != null && !found) {
            short type = tempNode.getNodeType();
            if (type == 1 || type == 5 || type == 6 || type == 4) {
                tempNode = null;
                continue;
            }
            if (type == 3) {
                tempNode = tempNode.getFirstChildNode();
                continue;
            }
            found = true;
        }
        return tempNode;
    }

    public AnyNode getFirstNamespace() {
        if (this.getNodeType() != 1) {
            String err = "This node type can not contain namespaces";
            throw new OperationNotSupportedException(err);
        }
        AnyNode tempNode = this.getFirstChildNode();
        boolean found = false;
        while (tempNode != null && !found) {
            short type = tempNode.getNodeType();
            if (type == 1 || type == 5 || type == 6 || type == 4) {
                tempNode = null;
                continue;
            }
            if (type == 2) {
                tempNode = tempNode.getFirstChildNode();
                continue;
            }
            found = true;
        }
        return tempNode;
    }

    public AnyNode getFirstChild() {
        if (this.getNodeType() == 2 || this.getNodeType() == 3) {
            return null;
        }
        AnyNode tempNode = this.getFirstChildNode();
        boolean found = false;
        while (tempNode != null && !found) {
            short type = tempNode.getNodeType();
            if (type == 1 || type == 5 || type == 6 || type == 4) {
                found = true;
                continue;
            }
            if (type != 2 && type != 3) continue;
            tempNode = tempNode.getFirstChildNode();
        }
        return tempNode;
    }

    public AnyNode getNextSibling() {
        return this._nextSiblingNode;
    }

    public short getNodeType() {
        return this._nodeType;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespaceURI() {
        return this._uri;
    }

    public String getStringValue() {
        switch (this._nodeType) {
            case 2: 
            case 6: {
                return this._value;
            }
            case 3: {
                return this._uri;
            }
            case 4: {
                return "";
            }
            case 5: {
                return this._value;
            }
            case 1: {
                AnyNode tempNode;
                StringBuffer result = new StringBuffer(4096);
                for (tempNode = this.getNextSibling(); tempNode != null && tempNode.getNodeType() == 6; tempNode = tempNode.getNextSibling()) {
                    result.append(tempNode.getStringValue());
                }
                for (tempNode = this.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                    result.append(tempNode.getStringValue());
                }
                tempNode = null;
                return result.toString();
            }
        }
        return null;
    }

    public String getNamespacePrefix() {
        return this._prefix;
    }

    public String toString() {
        Serializer serializer = LocalConfiguration.getInstance().getSerializer();
        if (serializer == null) {
            throw new RuntimeException("Unable to obtain serializer");
        }
        StringWriter writer = new StringWriter();
        serializer.setOutputCharStream(writer);
        try {
            AnyNode2SAX.fireEvents(this, serializer.asDocumentHandler());
        }
        catch (IOException ioe) {
            return this.privateToString();
        }
        catch (SAXException saxe) {
            throw new RuntimeException(saxe.getMessage());
        }
        return writer.toString();
    }

    private String privateToString() {
        StringBuffer sb = new StringBuffer(4096);
        if (_elements == null) {
            _elements = new Stack();
        }
        if (_elements.search(this) == -1) {
            _elements.push(this);
            if (this.getNodeType() == 1) {
                AnyNode tempNode;
                AnyNode siblingNode = this.getNextSibling();
                sb.append("<");
                String prefix = this.getNamespacePrefix();
                if (prefix != null) {
                    sb.append(prefix + ":");
                }
                prefix = null;
                sb.append(this.getLocalName());
                for (tempNode = this.getFirstAttribute(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                    sb.append(" ");
                    sb.append(tempNode.getLocalName());
                    sb.append("='" + tempNode.getStringValue() + "'");
                }
                for (tempNode = this.getFirstNamespace(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                    sb.append(" ");
                    sb.append(XMLNS_PREFIX);
                    prefix = tempNode.getNamespacePrefix();
                    if (prefix != null && prefix.length() != 0) {
                        sb.append(":" + prefix);
                    }
                    sb.append("='" + tempNode.getNamespaceURI() + "'");
                }
                tempNode = this.getFirstChild();
                if (tempNode != null) {
                    sb.append(">");
                    while (tempNode != null) {
                        sb.append(tempNode.privateToString());
                        tempNode = tempNode.getNextSibling();
                    }
                    sb.append("</" + this.getLocalName() + ">");
                } else {
                    sb.append("/>");
                }
            } else {
                sb.append(this.getStringValue());
            }
            return sb.toString();
        }
        return sb.toString();
    }

    protected void appendSibling(AnyNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if ((node.getNodeType() == 2 || node.getNodeType() == 3) && this.getNodeType() != node.getNodeType()) {
            String err = "a NAMESPACE or an ATTRIBUTE can only be add as a sibling to a node of the same type";
            throw new OperationNotSupportedException(err);
        }
        if (this._nextSiblingNode == null) {
            if (node.getNodeType() == 6 && this.getNodeType() == 6) {
                this.mergeTextNode(this, node);
            } else {
                this._nextSiblingNode = node;
            }
        } else {
            this._nextSiblingNode.appendSibling(node);
        }
    }

    protected AnyNode getFirstChildNode() {
        return this._firstChildNode;
    }

    private void mergeTextNode(AnyNode node1, AnyNode node2) {
        if (node1.getNodeType() != node2.getNodeType()) {
            return;
        }
        if (node1.getNodeType() != 6) {
            return;
        }
        StringBuffer temp = new StringBuffer(node1.getStringValue());
        temp.append(node2.getStringValue());
        node1._value = temp.toString();
        node2 = null;
    }

    public boolean equals(Object obj) {
        if (!this.equalsNorecursion(obj)) {
            return false;
        }
        AnyNode temp = (AnyNode)obj;
        if (this._firstChildNode != null) {
            AnyNode tempNode2;
            AnyNode tempNode1;
            if (temp._firstChildNode == null) {
                return false;
            }
            SortedList list1 = new SortedList();
            for (tempNode1 = this.getFirstAttribute(); tempNode1 != null; tempNode1 = tempNode1.getNextSibling()) {
                ((List)list1).add(tempNode1);
            }
            SortedList list2 = new SortedList();
            for (tempNode2 = temp.getFirstAttribute(); tempNode2 != null; tempNode2 = tempNode2.getNextSibling()) {
                ((List)list2).add(tempNode2);
            }
            if (!((List)list1).equals(list2)) {
                return false;
            }
            tempNode1 = this.getFirstChild();
            tempNode2 = temp.getFirstChild();
            if (tempNode1 != null) {
                if (tempNode2 == null) {
                    return false;
                }
                if (!tempNode1.equals(tempNode2)) {
                    return false;
                }
            } else if (tempNode2 != null) {
                return false;
            }
        } else if (temp._firstChildNode != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int _hashCode = this.hashCodeNorecursion();
        if (this._firstChildNode != null) {
            AnyNode tempNode;
            SortedList list = new SortedList();
            for (tempNode = this.getFirstAttribute(); tempNode != null; tempNode = tempNode.getNextSibling()) {
                ((List)list).add(tempNode);
            }
            _hashCode = 37 * _hashCode + ((List)list).hashCode();
            tempNode = this.getFirstChild();
            if (tempNode != null) {
                _hashCode = 37 * _hashCode + tempNode.hashCode();
            }
        }
        return _hashCode;
    }

    private boolean equalsNorecursion(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnyNode)) {
            return false;
        }
        AnyNode temp = (AnyNode)obj;
        if (this._nodeType != temp._nodeType) {
            return false;
        }
        if (this._localName != null) {
            if (temp._localName == null) {
                return false;
            }
            if (!this._localName.equals(temp._localName)) {
                return false;
            }
        } else if (temp._localName != null) {
            return false;
        }
        if (this._uri != null && this._uri.length() > 0) {
            if (temp._uri == null) {
                return false;
            }
            if (!this._uri.equals(temp._uri)) {
                return false;
            }
        } else if (temp._uri != null && temp._uri.length() > 0) {
            return false;
        }
        if (this._value != null) {
            if (temp._value == null) {
                return false;
            }
            if (!this._value.equals(temp._value)) {
                return false;
            }
        } else if (temp._value != null) {
            return false;
        }
        return true;
    }

    private int hashCodeNorecursion() {
        int _hashCode = 17;
        _hashCode = 37 * _hashCode + this._nodeType;
        if (this._localName != null) {
            _hashCode = 37 * _hashCode + this._localName.hashCode();
        }
        if (this._uri != null && this._uri.length() > 0) {
            _hashCode = 37 * _hashCode + this._uri.hashCode();
        }
        if (this._value != null) {
            _hashCode = 37 * _hashCode + this._value.hashCode();
        }
        return _hashCode;
    }

    private class SortedList
    extends List {
        private SortedList() {
        }

        public boolean add(Object obj) {
            AnyNode newNode = (AnyNode)obj;
            for (int i = 0; i < this.size(); ++i) {
                AnyNode tempNode = (AnyNode)this.get(i);
                if (tempNode._nodeType < newNode._nodeType || tempNode._nodeType <= newNode._nodeType && tempNode._localName.compareTo(newNode._localName) <= 0) continue;
                return super.add(i, obj);
            }
            return super.add(obj);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            List list = (List)obj;
            if (list.size() != this.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                AnyNode e1 = (AnyNode)this.get(i);
                AnyNode e2 = (AnyNode)list.get(i);
                if (e1 != null ? e1.equalsNorecursion(e2) : e2 == null) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int _hashCode = 1;
            for (int i = 0; i < this.size(); ++i) {
                AnyNode obj = (AnyNode)this.get(i);
                _hashCode = 37 * _hashCode + (obj == null ? 0 : obj.hashCodeNorecursion());
            }
            return _hashCode;
        }
    }
}

