/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.io;

import java.io.IOException;
import java.io.Writer;

public class XMLEncodeCharacterWriter
extends Writer {
    private Writer m_writer = null;

    private XMLEncodeCharacterWriter() {
    }

    public XMLEncodeCharacterWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("Null writer provided to XMLEncodeCharacterWriter constructor.");
        }
        this.m_writer = writer;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        XMLEncodeCharacterWriter.xmlencode(new String(cbuf, off, len), this.m_writer);
    }

    @Override
    public void flush() throws IOException {
        this.m_writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.m_writer.close();
    }

    public static void xmlencode(String value, Writer out) throws IOException {
        block7: for (int i = 0; i < value.length(); ++i) {
            char x = value.charAt(i);
            switch (x) {
                case '\'': {
                    out.write("&apos;");
                    continue block7;
                }
                case '<': {
                    out.write("&lt;");
                    continue block7;
                }
                case '>': {
                    out.write("&gt;");
                    continue block7;
                }
                case '&': {
                    out.write("&amp;");
                    continue block7;
                }
                case '\"': {
                    out.write("&quot;");
                    continue block7;
                }
                default: {
                    out.write(x);
                }
            }
        }
    }
}

