/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.sax;

import com.cognos.cps.common.utils.EncodingUtils;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class BufferXMLContentHandler
extends DefaultHandler {
    private Map m_prefixNSMappingMap = new HashMap();
    private StringBuffer m_currentElemBuf = new StringBuffer();

    public String getXML() {
        return this.m_currentElemBuf.toString();
    }

    public String toString() {
        return this.getXML();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.m_currentElemBuf.append('<');
        this.m_currentElemBuf.append(qName);
        for (Map.Entry prefixUriMapping : this.m_prefixNSMappingMap.entrySet()) {
            this.m_currentElemBuf.append(" xmlns");
            if (((String)prefixUriMapping.getKey()).length() > 0) {
                this.m_currentElemBuf.append(':');
                this.m_currentElemBuf.append(prefixUriMapping.getKey());
            }
            this.m_currentElemBuf.append("=\"");
            this.m_currentElemBuf.append(prefixUriMapping.getValue());
            this.m_currentElemBuf.append('\"');
        }
        this.m_prefixNSMappingMap.clear();
        for (int i = 0; i < atts.getLength(); ++i) {
            this.m_currentElemBuf.append(' ');
            this.m_currentElemBuf.append(atts.getQName(i));
            this.m_currentElemBuf.append("=\"");
            EncodingUtils.xmlEncode(atts.getValue(i), this.m_currentElemBuf);
            this.m_currentElemBuf.append('\"');
        }
        this.m_currentElemBuf.append('>');
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.m_currentElemBuf.append("</");
        this.m_currentElemBuf.append(qName);
        this.m_currentElemBuf.append('>');
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.m_currentElemBuf.append(ch, start, length);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        EncodingUtils.xmlEncode(new String(ch, start, length), this.m_currentElemBuf);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.m_prefixNSMappingMap.put(prefix, uri);
    }
}

