/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.sax;

import com.cognos.cps.common.utils.EncodingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class EnhancedBufferXMLContentHandler
extends DefaultHandler {
    protected boolean b_record;
    private Map m_elements = new HashMap();
    private List m_currentTargets = new ArrayList();

    public EnhancedBufferXMLContentHandler() {
    }

    public EnhancedBufferXMLContentHandler(QName tag) {
        this();
        this.addElementName(tag);
    }

    public void addElementName(QName tag) {
        this.m_elements.put(tag, new ElementBuffer());
    }

    public String getElementAsString(QName tag) {
        if (this.m_elements.containsKey(tag)) {
            return this.m_elements.get(tag).toString();
        }
        return null;
    }

    private void increaseLevel() {
        for (int i = 0; i < this.m_currentTargets.size(); ++i) {
            ElementBuffer element = (ElementBuffer)this.m_elements.get(this.m_currentTargets.get(i));
            ++element.level;
        }
    }

    private void decreaseLevel() {
        if (this.m_currentTargets.size() > 0) {
            int i;
            ArrayList tobeRemoved = null;
            for (i = 0; i < this.m_currentTargets.size(); ++i) {
                ElementBuffer element = (ElementBuffer)this.m_elements.get(this.m_currentTargets.get(i));
                --element.level;
                if (element.level != 0) continue;
                if (tobeRemoved == null) {
                    tobeRemoved = new ArrayList();
                }
                tobeRemoved.add(this.m_currentTargets.get(i));
            }
            if (tobeRemoved != null) {
                for (i = 0; i < tobeRemoved.size(); ++i) {
                    this.m_currentTargets.remove(tobeRemoved.get(i));
                }
            }
        }
    }

    protected void appendAll(Object o) {
        for (int i = 0; i < this.m_currentTargets.size(); ++i) {
            ElementBuffer element = (ElementBuffer)this.m_elements.get(this.m_currentTargets.get(i));
            element.buffer.append(o);
        }
    }

    private void writePrefixMappings() {
        for (int i = 0; i < this.m_currentTargets.size(); ++i) {
            ElementBuffer element = (ElementBuffer)this.m_elements.get(this.m_currentTargets.get(i));
            if (element.namespaces.isEmpty()) continue;
            for (Map.Entry entry : element.namespaces.entrySet()) {
                element.buffer.append(" xmlns");
                if (entry.getKey().toString().length() > 0) {
                    element.buffer.append(':');
                    element.buffer.append(entry.getKey().toString());
                }
                element.buffer.append("=\"");
                element.buffer.append(entry.getValue().toString());
                element.buffer.append('\"');
            }
            element.namespaces.clear();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        String tag = "".equals(uri) ? qName : localName;
        QName qname = new QName(uri, tag);
        if (this.m_elements.containsKey(qname) && !this.m_currentTargets.contains(qname)) {
            this.m_currentTargets.add(qname);
            if (!this.b_record) {
                this.b_record = true;
            }
        }
        if (this.b_record) {
            this.increaseLevel();
            this.appendAll("<" + qName);
            this.writePrefixMappings();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < atts.getLength(); ++i) {
                buffer.append(' ');
                buffer.append(atts.getQName(i));
                buffer.append("=\"");
                buffer.append(atts.getValue(i));
                buffer.append('\"');
            }
            buffer.append('>');
            this.appendAll(buffer.toString());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (this.b_record) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("</");
            buffer.append(qName);
            buffer.append('>');
            this.appendAll(buffer.toString());
            this.decreaseLevel();
            if (this.m_currentTargets.isEmpty()) {
                this.b_record = false;
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.b_record) {
            this.appendAll(new String(ch, start, length));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.b_record) {
            StringBuffer encoded = new StringBuffer();
            EncodingUtils.xmlEncode(new String(ch, start, length), encoded);
            this.appendAll(encoded.toString());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        Collection values = this.m_elements.values();
        for (ElementBuffer element : values) {
            element.namespaces.put(prefix, uri);
        }
    }

    private class ElementBuffer {
        StringBuffer buffer = new StringBuffer();
        Map namespaces = new HashMap();
        int level = 0;

        private ElementBuffer() {
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

