/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.sax;

import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class SAXUtils {
    private static SAXParserFactory parserFactory;

    public static void fireEvents(ContentHandler contentHandler, List saxEvents) throws SAXException {
        Object[] event2 = null;
        for (Object[] event2 : saxEvents) {
            if (event2[0].equals("characters")) {
                contentHandler.characters(((String)event2[1]).toCharArray(), 0, ((String)event2[1]).length());
                continue;
            }
            if (event2[0].equals("endDocument")) {
                contentHandler.endDocument();
                continue;
            }
            if (event2[0].equals("endElement")) {
                contentHandler.endElement((String)event2[1], (String)event2[2], (String)event2[3]);
                continue;
            }
            if (event2[0].equals("endPrefixMapping")) {
                contentHandler.endPrefixMapping((String)event2[1]);
                continue;
            }
            if (event2[0].equals("ignorableWhitespace")) {
                contentHandler.ignorableWhitespace(((String)event2[1]).toCharArray(), 0, ((String)event2[1]).length());
                continue;
            }
            if (event2[0].equals("processingInstruction")) {
                contentHandler.processingInstruction((String)event2[1], (String)event2[2]);
                continue;
            }
            if (event2[0].equals("skippedEntity")) {
                contentHandler.skippedEntity((String)event2[1]);
                continue;
            }
            if (event2[0].equals("startDocument")) {
                contentHandler.startDocument();
                continue;
            }
            if (event2[0].equals("startElement")) {
                contentHandler.startElement((String)event2[1], (String)event2[2], (String)event2[3], (Attributes)event2[4]);
                continue;
            }
            if (event2[0].equals("startPrefixMapping")) {
                contentHandler.startPrefixMapping((String)event2[1], (String)event2[2]);
                continue;
            }
            throw new SAXException("The event '" + event2[0] + "' is not a valid SAX event.");
        }
    }

    public static synchronized SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        if (parserFactory == null) {
            parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
        }
        return parserFactory.newSAXParser();
    }
}

