/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import java.io.ByteArrayOutputStream;

public class Base64 {
    public static final int BASE64 = 0;
    private static final String encTable = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static final char padchar = '=';
    private static final byte[] decodeTable = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};

    public static String encode(byte[] buf) {
        int c = 0;
        int size = buf.length;
        int rsize = (size / 3 + 1) * 4;
        StringBuffer ret = new StringBuffer(rsize);
        for (int i = 0; i < size; ++i) {
            c = buf[i] >> 2 & 0x3F;
            ret.append(encTable.charAt(c));
            c = buf[i] << 4 & 0x30;
            if (++i < size) {
                c |= buf[i] >> 4 & 0xF;
            }
            ret.append(encTable.charAt(c));
            if (i < size) {
                c = buf[i] << 2 & 0x3C;
                if (++i < size) {
                    c |= buf[i] >> 6 & 3;
                }
                ret.append(encTable.charAt(c));
            } else {
                ++i;
                ret.append('=');
            }
            if (i < size) {
                c = buf[i] & 0x3F;
                ret.append(encTable.charAt(c));
                continue;
            }
            ret.append('=');
        }
        return ret.toString();
    }

    public static byte[] decode(String str) {
        int len = str.length();
        if (len % 4 != 0) {
            return str.getBytes();
        }
        int rsize = (len / 4 + 1) * 3;
        ByteArrayOutputStream ret = new ByteArrayOutputStream(rsize);
        try {
            for (int i = 0; i < len; ++i) {
                int c = decodeTable[(byte)str.charAt(i++)];
                int c1 = decodeTable[(byte)str.charAt(i++)];
                c = c << 2 & 0xFC | c1 >> 4 & 3;
                ret.write((byte)c);
                if (str.charAt(i) == '=') break;
                c = decodeTable[(byte)str.charAt(i++)];
                c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                ret.write((byte)c1);
                if (str.charAt(i) == '=') break;
                c1 = decodeTable[(byte)str.charAt(i)];
                c = c << 6 & 0xC0 | c1 & 0x3F;
                ret.write((byte)c);
            }
            return ret.toByteArray();
        }
        catch (Exception e) {
            return str.getBytes();
        }
    }
}

