/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import java.net.HttpURLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;

public class CookieUtils {
    private static final DateFormat[] myExpiryFormats = new DateFormat[4];

    public static Cookie[] addCookie(Cookie[] cookies, Cookie cookie) {
        if (cookies == null) {
            cookies = new Cookie[1];
        } else {
            Cookie[] tempCookies = new Cookie[cookies.length + 1];
            System.arraycopy(cookies, 0, tempCookies, 0, cookies.length);
            cookies = tempCookies;
        }
        cookies[cookies.length - 1] = cookie;
        return cookies;
    }

    public static Cookie[] addCookies(Cookie[] cookies1, Cookie[] cookies2) {
        if (cookies1 == null) {
            return cookies2;
        }
        if (cookies2 == null) {
            return cookies1;
        }
        Cookie[] tempCookies = new Cookie[cookies1.length + cookies2.length];
        System.arraycopy(cookies1, 0, tempCookies, 0, cookies1.length);
        System.arraycopy(cookies2, 0, tempCookies, cookies1.length, cookies2.length);
        return tempCookies;
    }

    public static void addCookies(HttpURLConnection connection, Cookie[] cookies) {
        if (cookies != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < cookies.length; ++i) {
                if (i > 0) {
                    buf.append("; ");
                }
                if (cookies[i].getVersion() == 1) {
                    buf.append(cookies[i].getName() + "=" + "\"" + cookies[i].getValue() + "\"");
                    continue;
                }
                buf.append(cookies[i].getName() + "=" + cookies[i].getValue());
            }
            String currentCookies = connection.getRequestProperty("Cookie");
            if (currentCookies != null) {
                buf.append(";");
                buf.append(currentCookies);
            }
            connection.setRequestProperty("Cookie", buf.toString());
        }
    }

    public static Cookie[] getSetCookies(HttpURLConnection connection) {
        Cookie[] cookies = null;
        int i = 1;
        while (connection.getHeaderFieldKey(i) != null) {
            String value;
            String key = connection.getHeaderFieldKey(i);
            if (key.equalsIgnoreCase("Set-Cookie") && (value = connection.getHeaderField(i)) != null) {
                Header header = new Header(key, CookieUtils.fixExpiresParameter(value));
                HeaderElement[] headerElements = null;
                try {
                    headerElements = header.getValues();
                }
                catch (HttpException e) {
                    e.printStackTrace(System.err);
                    headerElements = new HeaderElement[]{};
                }
                for (int j = 0; j < headerElements.length; ++j) {
                    String cookieValue = headerElements[j].getValue();
                    if (cookieValue == null) {
                        cookieValue = "";
                    }
                    Cookie cookie = new Cookie(headerElements[j].getName(), cookieValue);
                    NameValuePair[] params = headerElements[j].getParameters();
                    if (params != null) {
                        block6: for (int k = 0; k < params.length; ++k) {
                            if (params[k].getName().equalsIgnoreCase("Comment")) {
                                cookie.setComment(params[k].getValue());
                                continue;
                            }
                            if (params[k].getName().equalsIgnoreCase("Domain")) {
                                cookie.setDomain(params[k].getValue());
                                continue;
                            }
                            if (params[k].getName().equalsIgnoreCase("Max-Age")) {
                                cookie.setMaxAge(Integer.parseInt(params[k].getValue()));
                                continue;
                            }
                            if (params[k].getName().equalsIgnoreCase("Path")) {
                                cookie.setPath(params[k].getValue());
                                continue;
                            }
                            if (params[k].getName().equalsIgnoreCase("Secure")) {
                                cookie.setSecure(true);
                                continue;
                            }
                            if (params[k].getName().equalsIgnoreCase("Version")) {
                                cookie.setVersion(Integer.parseInt(params[k].getValue()));
                                continue;
                            }
                            if (!params[k].getName().equalsIgnoreCase("expires")) continue;
                            String expiryDate = params[k].getValue();
                            for (int l = 0; l < myExpiryFormats.length; ++l) {
                                try {
                                    Date date = myExpiryFormats[l].parse(expiryDate);
                                    int expiry = (int)((date.getTime() - System.currentTimeMillis()) / 1000L);
                                    cookie.setMaxAge(expiry);
                                    continue block6;
                                }
                                catch (ParseException parseException) {
                                    continue;
                                }
                            }
                        }
                    }
                    cookies = CookieUtils.addCookie(cookies, cookie);
                }
            }
            ++i;
        }
        return cookies;
    }

    public static String fixExpiresParameter(String value) {
        String setCookieValue = value;
        int pos1 = value.indexOf("expires=");
        if (pos1 != -1) {
            String s1 = value.substring(0, pos1 + 8);
            String date = value.substring(pos1 + 8);
            String s2 = "";
            int pos3 = date.indexOf(";");
            if (pos3 != -1) {
                s2 = date.substring(pos3);
                date = date.substring(0, pos3);
            }
            StringBuffer buf = new StringBuffer();
            buf.append(s1).append("\"").append(date).append("\"").append(s2);
            setCookieValue = buf.toString();
        }
        return setCookieValue;
    }

    static {
        CookieUtils.myExpiryFormats[0] = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss z", Locale.US);
        CookieUtils.myExpiryFormats[1] = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
        CookieUtils.myExpiryFormats[2] = new SimpleDateFormat("EEE dd-MMM-yy HH:mm:ss z", Locale.US);
        CookieUtils.myExpiryFormats[3] = new SimpleDateFormat("EEE dd-MMM-yyyy HH:mm:ss z", Locale.US);
    }
}

