/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import com.cognos.cps.common.utils.SmallMap;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class GetVersion {
    private static Map packageToClassMap = new SmallMap();

    public static String getVersion(String[] packages, boolean bExactMatch) {
        StringBuffer response = new StringBuffer("<versions>");
        if (packages != null) {
            response.append(GetVersion.getComponentsXML(packages, bExactMatch));
        }
        response.append("</versions>");
        return response.toString();
    }

    private static String getComponentsXML(String[] packages, boolean bExactMatch) {
        StringBuffer response = new StringBuffer();
        for (int i = 0; i < packages.length; ++i) {
            response.append(GetVersion.getComponentXML(packages[i], bExactMatch));
        }
        return response.toString();
    }

    private static String getComponentXML(String curPackage, boolean bExactMatch) {
        StringBuffer response = new StringBuffer();
        response.append("<component name=\"").append(curPackage).append("\">");
        Package packageObj = GetVersion.getPackage(curPackage, bExactMatch);
        if (packageObj != null) {
            response.append(GetVersion.getPackageXML(packageObj));
        } else {
            Manifest mf = GetVersion.getManifest(curPackage, bExactMatch);
            if (mf != null) {
                response.append(GetVersion.getManifestXML(mf));
            }
        }
        response.append("</component>");
        return response.toString();
    }

    private static Package getPackage(String curPackage, boolean bExactMatch) {
        Package[] packs;
        Package packageObj = Package.getPackage(curPackage);
        if (packageObj == null && !bExactMatch && (packs = Package.getPackages()) != null) {
            for (int i = 0; i < packs.length; ++i) {
                if (!packs[i].getName().startsWith(curPackage)) continue;
                packageObj = packs[i];
                break;
            }
        }
        return packageObj;
    }

    private static String getPackageXML(Package packageObj) {
        StringBuffer response = new StringBuffer();
        if (packageObj.getSpecificationVersion() != null) {
            response.append("<specification><title>").append(packageObj.getSpecificationTitle()).append("</title><vendor>").append(packageObj.getSpecificationVendor()).append("</vendor><version>").append(packageObj.getSpecificationVersion()).append("</version></specification>");
        }
        if (packageObj.getImplementationVersion() != null) {
            response.append("<implementation><title>").append(packageObj.getImplementationTitle()).append("</title><vendor>").append(packageObj.getImplementationVendor()).append("</vendor><version>").append(packageObj.getImplementationVersion()).append("</version></implementation>");
        }
        return response.toString();
    }

    private static Manifest getManifest(String curPackage, boolean bExactMatch) {
        String className = (String)packageToClassMap.get(curPackage);
        if (className == null && !bExactMatch) {
            for (String packageName : packageToClassMap.keySet()) {
                if (!packageName.startsWith(curPackage)) continue;
                className = (String)packageToClassMap.get(packageName);
                break;
            }
        }
        Manifest manifestObj = null;
        if (className != null) {
            try {
                Class<?> cl = Class.forName(className);
                String newClassName = cl.getName().replace('.', '/');
                String jarName = cl.getResource("/" + newClassName + ".class").toString();
                if (jarName.startsWith("jar:")) {
                    URL manifURL = new URL(jarName.substring(0, jarName.indexOf("!") + 1) + "/META-INF/MANIFEST.MF");
                    manifestObj = new Manifest(manifURL.openStream());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return manifestObj;
    }

    private static String getManifestXML(Manifest mf) {
        StringBuffer response = new StringBuffer();
        Attributes attr = mf.getMainAttributes();
        if (attr != null) {
            String specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            String specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            String specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            String implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            String implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            if (specVersion != null) {
                response.append("<specification><title>").append(specTitle == null ? "" : specTitle).append("</title><vendor>").append(specVendor == null ? "" : specVendor).append("</vendor><version>").append(specVersion).append("</version></specification>");
            }
            if (implVersion != null) {
                response.append("<implementation><title>").append(implTitle == null ? "" : specTitle).append("</title><vendor>").append(implVendor == null ? "" : specVendor).append("</vendor><version>").append(implVersion).append("</version></implementation>");
            }
        }
        return response.toString();
    }

    static {
        packageToClassMap.put("com.cognos.cps", "com.cognos.cps.common.utils.GetVersion");
        packageToClassMap.put("com.cognos.cps.common", "com.cognos.cps.common.utils.GetVersion");
        packageToClassMap.put("com.cognos.cps.consumer.common", "com.cognos.cps.consumer.common.wsrp.Constants");
        packageToClassMap.put("com.cognos.cps.wsrp.consumer.impls.sap", "com.cognos.cps.wsrp.consumer.impls.sap.Common");
        packageToClassMap.put("com.cognos.cps.wsrp.consumer.impls.websphere", "com.cognos.cps.wsrp.consumer.impls.websphere.Consumer");
        packageToClassMap.put("com.cognos.cps.producer", "com.cognos.cps.producer.request.UCPSUtils");
        packageToClassMap.put("com.cognos.xts", "com.cognos.xts.XTSEnvironment");
        packageToClassMap.put("java.lang", "java.lang.String");
        packageToClassMap.put("org.apache.xalan", "org.apache.xalan.Version");
        packageToClassMap.put("javax.servlet", "javax.servlet.http.HttpServlet");
        packageToClassMap.put("javax.xml.parsers", "javax.xml.parsers.SAXParser");
        packageToClassMap.put("javax.xml.transform", "javax.xml.transform.Transformer");
    }
}

