/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.common.utils;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SmallMap
implements Map {
    SmallEntry[] entries;
    int size;
    volatile transient int modCount;
    private volatile transient Set keySet = null;
    private volatile transient Collection values = null;
    private transient Set entrySet = null;

    public SmallMap() {
        this(10);
    }

    public SmallMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.entries = new SmallEntry[initialCapacity];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.entries[i] = null;
        }
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!(this.entries[i].getKey() != null ? this.entries[i].getKey().equals(key) : key == null)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.size; ++i) {
            if (!(this.entries[i].getValue() != null ? this.entries[i].getValue().equals(value) : value == null)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!(this.entries[i].getKey() != null ? this.entries[i].getKey().equals(key) : key == null)) continue;
            return this.entries[i].getValue();
        }
        return null;
    }

    public Object remove(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if ((this.entries[i].getKey() == null || !this.entries[i].getKey().equals(key)) && (this.entries[i].getKey() != null || key != null)) continue;
            ++this.modCount;
            Object oldValue = this.entries[i].value;
            int numMoved = this.size - i - 1;
            if (numMoved > 0) {
                System.arraycopy(this.entries, i + 1, this.entries, i, numMoved);
            }
            this.entries[--this.size] = null;
            return oldValue;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        for (int i = 0; i < this.size; ++i) {
            if ((this.entries[i].getKey() == null || !this.entries[i].getKey().equals(key)) && (this.entries[i].getKey() != null || key != null)) continue;
            Object oldValue = this.entries[i].value;
            this.entries[i].setValue(value);
            return oldValue;
        }
        ++this.modCount;
        this.ensureCapacity(this.size + 1);
        this.entries[this.size++] = new SmallEntry(key, value);
        return null;
    }

    public void putAll(Map t) {
        for (Map.Entry element : t.entrySet()) {
            this.put(element.getKey(), element.getValue());
        }
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        int index = -1;
                        int expectedModCount;
                        {
                            this.expectedModCount = SmallMap.this.modCount;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index + 1 < SmallMap.this.size;
                        }

                        public Object next() {
                            if (SmallMap.this.modCount != this.expectedModCount) {
                                throw new ConcurrentModificationException();
                            }
                            return SmallMap.this.entries[++this.index];
                        }

                        @Override
                        public void remove() {
                            if (this.index < 0 || this.index >= SmallMap.this.size) {
                                throw new IllegalStateException();
                            }
                            if (SmallMap.this.modCount != this.expectedModCount) {
                                throw new ConcurrentModificationException();
                            }
                            SmallMap.this.remove(SmallMap.this.entries[this.index].getKey());
                            this.expectedModCount = SmallMap.this.modCount;
                        }
                    };
                }

                @Override
                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Map.Entry candidate = (Map.Entry)SmallMap.this.get(e.getKey());
                    return candidate != null && candidate.equals(e);
                }

                @Override
                public boolean remove(Object o) {
                    return SmallMap.this.remove(o) != null;
                }

                @Override
                public int size() {
                    return SmallMap.this.size;
                }

                @Override
                public void clear() {
                    SmallMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = SmallMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return SmallMap.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return SmallMap.this.containsKey(k);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        private Iterator i;
                        {
                            this.i = SmallMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        public Object next() {
                            return ((Map.Entry)this.i.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return SmallMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return SmallMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry e : this.entrySet()) {
                Object key = e.getKey();
                Object value = e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry e = (Map.Entry)i.next();
            Object key = e.getKey();
            Object value = e.getValue();
            buf.append((key == this ? "(this Map)" : key) + "=" + (value == this ? "(this Map)" : value));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.entries.length;
        if (minCapacity > oldCapacity) {
            SmallEntry[] oldData = this.entries;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.entries = new SmallEntry[newCapacity];
            System.arraycopy(oldData, 0, this.entries, 0, this.size);
        }
    }

    class SmallEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SmallEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

