/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.helpers;

import com.cognos.cps.services.IService;
import com.cognos.cps.services.ServiceException;
import java.io.InputStream;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.xml.sax.InputSource;

public abstract class ServiceImpl
implements IService {
    private static final String JAVAX_WSDL_IMPORTDOCUMENTS = "javax.wsdl.importDocuments";
    private String m_wsdlDocumentLocation = null;
    private QName m_serviceName = null;
    private Service m_service = null;

    public ServiceImpl(WSDLLocator locator, QName serviceName) throws ServiceException {
        this.m_wsdlDocumentLocation = locator.getBaseURI();
        this.m_serviceName = serviceName;
        Definition definition = null;
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature(JAVAX_WSDL_IMPORTDOCUMENTS, false);
            definition = wsdlReader.readWSDL(locator);
            this.m_service = definition.getService(this.m_serviceName);
            if (this.m_service == null) {
                throw new ServiceException("cps.services.undefinedservice", new String[]{this.m_wsdlDocumentLocation, this.m_serviceName.getLocalPart(), this.m_serviceName.getNamespaceURI()});
            }
        }
        catch (Exception e) {
            throw new ServiceException("cps.services.failedtoreadwsdl", new String[]{this.m_wsdlDocumentLocation}, e);
        }
    }

    public ServiceImpl(String wsdlDocumentLocation, QName serviceName) throws ServiceException {
        this.m_wsdlDocumentLocation = wsdlDocumentLocation;
        this.m_serviceName = serviceName;
        Definition definition = null;
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature(JAVAX_WSDL_IMPORTDOCUMENTS, false);
            definition = wsdlReader.readWSDL(this.m_wsdlDocumentLocation);
            this.m_service = definition.getService(this.m_serviceName);
            if (this.m_service == null) {
                throw new ServiceException("cps.services.undefinedservice", new String[]{this.m_wsdlDocumentLocation, this.m_serviceName.getLocalPart(), this.m_serviceName.getNamespaceURI()});
            }
        }
        catch (WSDLException e) {
            throw new ServiceException("cps.services.failedtoreadwsdl", new String[]{this.m_wsdlDocumentLocation}, e);
        }
    }

    public ServiceImpl(InputStream wsdlStream, QName serviceName) throws ServiceException {
        this.m_serviceName = serviceName;
        Definition definition = null;
        try {
            WSDLReader wsdlReader = WSDLFactory.newInstance().newWSDLReader();
            wsdlReader.setFeature(JAVAX_WSDL_IMPORTDOCUMENTS, false);
            definition = wsdlReader.readWSDL(null, new InputSource(wsdlStream));
            this.m_service = definition.getService(this.m_serviceName);
            if (this.m_service == null) {
                throw new ServiceException("cps.services.undefinedservice", new String[]{wsdlStream.toString(), this.m_serviceName.getLocalPart(), this.m_serviceName.getNamespaceURI()});
            }
        }
        catch (WSDLException e) {
            throw new ServiceException("cps.services.failedtoreadwsdl", new String[]{wsdlStream.toString()}, e);
        }
    }

    @Override
    public String getWSDLDocumentLocation() {
        return this.m_wsdlDocumentLocation;
    }

    @Override
    public QName getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public String getPortAddress(QName portName) {
        Port port = this.m_service.getPort(portName.getLocalPart());
        if (port == null) {
            return null;
        }
        List extensibilityElements = port.getExtensibilityElements();
        for (ExtensibilityElement extensibilityElement : extensibilityElements) {
            if (!(extensibilityElement instanceof SOAPAddress)) continue;
            return ((SOAPAddress)extensibilityElement).getLocationURI();
        }
        return null;
    }
}

