/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.helpers;

import com.cognos.cps.common.logging.ServiceLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.wsdl.xml.WSDLLocator;
import org.xml.sax.InputSource;

public class WSDLLocatorImpl
implements WSDLLocator {
    private HttpURLConnection m_connection;
    private ServiceLogger m_logger;

    private WSDLLocatorImpl() {
    }

    public WSDLLocatorImpl(HttpURLConnection connection, ServiceLogger logger) {
        this.m_connection = connection;
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource getBaseInputSource() {
        ByteArrayOutputStream bio = null;
        try {
            this.m_connection.setRequestMethod("GET");
            this.m_connection.setDoInput(true);
            this.m_connection.setInstanceFollowRedirects(true);
            this.m_connection.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            InputStream wsdlin = this.m_connection.getInputStream();
            bio = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            int bytesRead = wsdlin.read(buf, 0, 4096);
            while (bytesRead != -1) {
                bio.write(buf, 0, bytesRead);
                bytesRead = wsdlin.read(buf, 0, 4096);
            }
            InputSource inputSource = new InputSource(new ByteArrayInputStream(bio.toByteArray()));
            return inputSource;
        }
        catch (EOFException e) {
            Object url;
            if (this.m_logger != null && this.m_logger.isErrorEnabled()) {
                url = this.m_connection.getURL();
                String urlString = "";
                if (url != null) {
                    urlString = ((URL)url).toExternalForm();
                }
                this.m_logger.error("An EOFException occured while retreiving the WSDL document '" + urlString + "'", e);
            }
            if (bio != null) {
                url = new InputSource(new ByteArrayInputStream(bio.toByteArray()));
                return url;
            }
            url = null;
            return url;
        }
        catch (IOException e) {
            if (this.m_logger != null && this.m_logger.isErrorEnabled()) {
                URL url = this.m_connection.getURL();
                String urlString = "";
                if (url != null) {
                    urlString = url.toExternalForm();
                }
                this.m_logger.error("An error occured while retreiving the WSDL document '" + urlString + "'", e);
            }
            InputSource inputSource = null;
            return inputSource;
        }
        finally {
            if (this.m_connection != null) {
                this.m_connection.disconnect();
            }
        }
    }

    public InputSource getImportInputSource(String arg0, String arg1) {
        throw new RuntimeException("The method getImportInputSource() is not currently supported.");
    }

    public String getBaseURI() {
        return this.m_connection.getURL().toExternalForm();
    }

    public String getLatestImportURI() {
        throw new RuntimeException("The method getLatestImportURI() is not currently supported.");
    }
}

