/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.pagelet.processor.v1;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.cps.services.pagelet.processor.v1.ProcessorFaultBindings;
import com.cognos.cps.services.pagelet.processor.v1.intf.IProcessor;
import com.cognos.cps.services.pagelet.processor.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.processor.v1.types.Render;
import com.cognos.cps.services.pagelet.processor.v1.types.RenderResponse;
import com.cognos.cps.services.pagelet.processor.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPConnection;
import com.cognos.cps.soap.SOAPConnectionFactory;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPMessage;
import com.cognos.cps.soap.helpers.QNameFactory;
import java.io.IOException;
import org.xml.sax.SAXException;

class ProcessorImpl
extends ContextImpl
implements IProcessor {
    private String m_url;
    private ServiceLogger m_logger;

    private ProcessorImpl() {
    }

    public ProcessorImpl(String url, ServiceLogger logger) {
        this.m_url = url;
        this.m_logger = logger;
    }

    @Override
    public RenderResponse render(Render render, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(render);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/processor/1/", "render", "aps"));
        SOAPMessage response = this.sendRequest(request);
        return (RenderResponse)response.getBody();
    }

    protected SOAPMessage sendRequest(SOAPMessage request) throws OperationFailedFault {
        SOAPConnection soapConnection = (SOAPConnection)this.getProperty("SOAPConnection");
        if (soapConnection == null) {
            soapConnection = SOAPConnectionFactory.newInstance().createConnection(TypeFactory.newInstance(), this.m_logger);
        }
        try {
            SOAPMessage sOAPMessage = soapConnection.call(request, this.m_url);
            return sOAPMessage;
        }
        catch (SOAPFault e) {
            Fault fault = ProcessorFaultBindings.convert(e);
            if (fault instanceof OperationFailedFault) {
                throw (OperationFailedFault)fault;
            }
            throw new OperationFailedFault("cps.services.nonwebservicefault", new String[]{this.m_url, e.getFaultString()}, e);
        }
        catch (IOException e) {
            throw new OperationFailedFault("cps.services.soaprequestfailed", new String[]{this.m_url}, e);
        }
        catch (SAXException e) {
            throw new OperationFailedFault("cps.services.soaprequestfailed", new String[]{this.m_url}, e);
        }
        finally {
            soapConnection.disconnect();
        }
    }
}

