/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.pagelet.storage.v1;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.IContext;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.services.pagelet.objects.v1.types.Fault;
import com.cognos.cps.services.pagelet.storage.v1.StorageFaultBindings;
import com.cognos.cps.services.pagelet.storage.v1.intf.IStorage;
import com.cognos.cps.services.pagelet.storage.v1.types.OperationFailedFault;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPagelet;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPageletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.QueryPortletProducerResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBinding;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveBindingResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContext;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveContextResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortlet;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducer;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletProducerResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SavePortletResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistration;
import com.cognos.cps.services.pagelet.storage.v1.types.SaveRegistrationResponse;
import com.cognos.cps.services.pagelet.storage.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPConnection;
import com.cognos.cps.soap.SOAPConnectionFactory;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPMessage;
import com.cognos.cps.soap.helpers.QNameFactory;
import java.io.IOException;
import org.xml.sax.SAXException;

class StorageImpl
extends ContextImpl
implements IStorage {
    private String m_url;
    private ServiceLogger m_logger;

    private StorageImpl() {
    }

    public StorageImpl(String url, ServiceLogger logger) {
        this.m_url = url;
        this.m_logger = logger;
    }

    @Override
    public QueryPageletResponse queryPagelet(QueryPagelet queryPagelet, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(queryPagelet);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "queryPagelet", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (QueryPageletResponse)response.getBody();
    }

    @Override
    public QueryPortletProducerResponse queryPortletProducer(QueryPortletProducer queryPortletProducer, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(queryPortletProducer);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "queryPortletProducer", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (QueryPortletProducerResponse)response.getBody();
    }

    @Override
    public SavePortletProducerResponse savePortletProducer(SavePortletProducer savePortletProducer, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(savePortletProducer);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "savePortletProducer", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (SavePortletProducerResponse)response.getBody();
    }

    @Override
    public SavePortletResponse savePortlet(SavePortlet savePortlet, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(savePortlet);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "savePortlet", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (SavePortletResponse)response.getBody();
    }

    @Override
    public SaveRegistrationResponse saveRegistration(SaveRegistration saveRegistration, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(saveRegistration);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "saveRegistration", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (SaveRegistrationResponse)response.getBody();
    }

    @Override
    public SaveBindingResponse saveBinding(SaveBinding saveBinding, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(saveBinding);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "saveBinding", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (SaveBindingResponse)response.getBody();
    }

    @Override
    public SaveContextResponse saveContext(SaveContext saveContext, IContext context) throws OperationFailedFault {
        SOAPMessage request = new SOAPMessage();
        request.setBody(saveContext);
        request.setBodyRootElemName(QNameFactory.createQName("http://developer.cognos.com/schemas/cps/asm/storage/1/", "saveContext", "ast"));
        SOAPMessage response = this.sendRequest(request);
        return (SaveContextResponse)response.getBody();
    }

    protected SOAPMessage sendRequest(SOAPMessage request) throws OperationFailedFault {
        SOAPConnection soapConnection = (SOAPConnection)this.getProperty("SOAPConnection");
        if (soapConnection == null) {
            soapConnection = SOAPConnectionFactory.newInstance().createConnection(TypeFactory.newInstance(), this.m_logger);
        }
        try {
            SOAPMessage sOAPMessage = soapConnection.call(request, this.m_url);
            return sOAPMessage;
        }
        catch (SOAPFault e) {
            Fault fault = StorageFaultBindings.convert(e);
            if (fault instanceof OperationFailedFault) {
                throw (OperationFailedFault)fault;
            }
            throw new OperationFailedFault("cps.services.nonwebservicefault", new String[]{this.m_url, e.getFaultString()}, e);
        }
        catch (IOException e) {
            throw new OperationFailedFault("cps.services.soaprequestfailed", new String[]{this.m_url}, e);
        }
        catch (SAXException e) {
            throw new OperationFailedFault("cps.services.soaprequestfailed", new String[]{this.m_url}, e);
        }
        finally {
            soapConnection.disconnect();
        }
    }
}

