/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.soap.envelope;

import com.cognos.cps.common.io.EnhancedIOException;
import com.cognos.cps.services.soap.envelope.ClassDescriptorResolverImpl;
import com.cognos.cps.services.soap.envelope.Detail;
import com.cognos.cps.services.soap.envelope.SOAPBody;
import com.cognos.cps.services.soap.envelope.SOAPEnvelope;
import com.cognos.cps.services.soap.envelope.SOAPFault;
import com.cognos.cps.services.soap.envelope.SOAPHeader;
import com.cognos.cps.soap.SOAPObjectHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.ContentHandler;

public class TypeFactory
implements SOAPObjectHandler {
    public static final String TYPES_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String TYPES_PREFIX = "tns";
    private static TypeFactory m_factory = null;
    private Map m_unmarshallerCache = new HashMap();
    private ClassDescriptorResolver m_resolver = new ClassDescriptorResolverImpl();

    private TypeFactory() {
        this.m_unmarshallerCache.put("Envelope", new Unmarshaller(SOAPEnvelope.class));
        this.m_unmarshallerCache.put("Header", new Unmarshaller(SOAPHeader.class));
        this.m_unmarshallerCache.put("Body", new Unmarshaller(SOAPBody.class));
        this.m_unmarshallerCache.put("Fault", new Unmarshaller(SOAPFault.class));
        this.m_unmarshallerCache.put("detail", new Unmarshaller(Detail.class));
    }

    public static TypeFactory newInstance() {
        return m_factory;
    }

    @Override
    public ContentHandler getContentHandler(String namespaceURI, String localName) {
        if (!namespaceURI.equals(TYPES_NAMESPACE)) {
            return null;
        }
        Unmarshaller unmarshaller = (Unmarshaller)this.m_unmarshallerCache.get(localName);
        if (unmarshaller == null) {
            return null;
        }
        unmarshaller.setValidation(false);
        unmarshaller.setDebug(false);
        unmarshaller.setResolver(this.m_resolver);
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller.createHandler();
    }

    @Override
    public Object getObject(ContentHandler contentHandler) {
        if (contentHandler instanceof UnmarshalHandler) {
            return ((UnmarshalHandler)contentHandler).getObject();
        }
        return null;
    }

    @Override
    public void serialize(Object obj, Writer out) throws IOException {
        this.serialize(obj, out, null);
    }

    @Override
    public void serialize(Object obj, Writer out, QName name) throws IOException {
        Marshaller marshaller = new Marshaller(out);
        marshaller.setResolver(this.m_resolver);
        marshaller.setDebug(false);
        marshaller.setValidation(false);
        marshaller.setMarshalAsDocument(false);
        marshaller.setMarshalExtendedType(false);
        marshaller.setSuppressXSIType(true);
        if (name != null) {
            marshaller.setRootElement(name.getLocalPart());
            marshaller.setNamespaceMapping(TYPES_PREFIX, TYPES_NAMESPACE);
        }
        try {
            marshaller.marshal(obj);
        }
        catch (MarshalException e) {
            throw new EnhancedIOException("cps.services.marshallfailed", new String[]{obj.getClass().getName()}, e);
        }
        catch (ValidationException e) {
            throw new EnhancedIOException("cps.services.validatefailed", new String[]{obj.getClass().getName()}, e);
        }
    }

    public SOAPBody createBody() {
        return new SOAPBody();
    }

    public Detail createDetail() {
        return new Detail();
    }

    public SOAPEnvelope createEnvelope() {
        return new SOAPEnvelope();
    }

    public SOAPFault createFault() {
        return new SOAPFault();
    }

    public SOAPHeader createHeader() {
        return new SOAPHeader();
    }

    static {
        m_factory = new TypeFactory();
    }
}

