/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.wsdl.soap;

import com.cognos.cps.common.io.EnhancedIOException;
import com.cognos.cps.services.wsdl.soap.Address;
import com.cognos.cps.services.wsdl.soap.Binding;
import com.cognos.cps.services.wsdl.soap.Body;
import com.cognos.cps.services.wsdl.soap.ClassDescriptorResolverImpl;
import com.cognos.cps.services.wsdl.soap.Fault;
import com.cognos.cps.services.wsdl.soap.FaultRes;
import com.cognos.cps.services.wsdl.soap.Header;
import com.cognos.cps.services.wsdl.soap.HeaderFault;
import com.cognos.cps.services.wsdl.soap.Operation;
import com.cognos.cps.soap.SOAPObjectHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.ContentHandler;

public class TypeFactory
implements SOAPObjectHandler {
    public static final String TYPES_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String TYPES_PREFIX = "soap";
    private static TypeFactory m_factory = null;
    private Map m_unmarshallerCache = new HashMap();
    private ClassDescriptorResolver m_resolver = new ClassDescriptorResolverImpl();

    private TypeFactory() {
    }

    public static TypeFactory newInstance() {
        return m_factory;
    }

    @Override
    public ContentHandler getContentHandler(String namespaceURI, String localName) {
        if (!namespaceURI.equals(TYPES_NAMESPACE)) {
            return null;
        }
        Unmarshaller unmarshaller = (Unmarshaller)this.m_unmarshallerCache.get(localName);
        if (unmarshaller == null) {
            return null;
        }
        unmarshaller.setValidation(false);
        unmarshaller.setDebug(false);
        unmarshaller.setResolver(this.m_resolver);
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller.createHandler();
    }

    @Override
    public Object getObject(ContentHandler contentHandler) {
        if (contentHandler instanceof UnmarshalHandler) {
            return ((UnmarshalHandler)contentHandler).getObject();
        }
        return null;
    }

    @Override
    public void serialize(Object obj, Writer out) throws IOException {
        this.serialize(obj, out, null);
    }

    @Override
    public void serialize(Object obj, Writer out, QName name) throws IOException {
        Marshaller marshaller = new Marshaller(out);
        marshaller.setResolver(this.m_resolver);
        marshaller.setDebug(false);
        marshaller.setValidation(false);
        marshaller.setMarshalAsDocument(false);
        marshaller.setMarshalExtendedType(false);
        marshaller.setSuppressXSIType(true);
        if (name != null) {
            marshaller.setRootElement(name.getLocalPart());
            marshaller.setNamespaceMapping(TYPES_PREFIX, TYPES_NAMESPACE);
        }
        try {
            marshaller.marshal(obj);
        }
        catch (MarshalException e) {
            throw new EnhancedIOException("cps.services.marshallfailed", new String[]{obj.getClass().getName()}, e);
        }
        catch (ValidationException e) {
            throw new EnhancedIOException("cps.services.validatefailed", new String[]{obj.getClass().getName()}, e);
        }
    }

    public Address createAddress() {
        return new Address();
    }

    public Binding createBinding() {
        return new Binding();
    }

    public Body createBody() {
        return new Body();
    }

    public Fault createFault() {
        return new Fault();
    }

    public Header createHeader() {
        return new Header();
    }

    public HeaderFault createHeaderFault() {
        return new HeaderFault();
    }

    public Operation createOperation() {
        return new Operation();
    }

    public FaultRes createFaultRes() {
        return new FaultRes();
    }

    static {
        m_factory = new TypeFactory();
    }
}

