/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.wsrp.v1;

import com.cognos.cps.services.wsrp.v1.types.AccessDeniedFault;
import com.cognos.cps.services.wsrp.v1.types.Fault;
import com.cognos.cps.services.wsrp.v1.types.InconsistentParametersFault;
import com.cognos.cps.services.wsrp.v1.types.InvalidCookieFault;
import com.cognos.cps.services.wsrp.v1.types.InvalidHandleFault;
import com.cognos.cps.services.wsrp.v1.types.InvalidRegistrationFault;
import com.cognos.cps.services.wsrp.v1.types.InvalidSessionFault;
import com.cognos.cps.services.wsrp.v1.types.InvalidUserCategoryFault;
import com.cognos.cps.services.wsrp.v1.types.MissingParametersFault;
import com.cognos.cps.services.wsrp.v1.types.OperationFailedFault;
import com.cognos.cps.services.wsrp.v1.types.PortletStateChangeRequiredFault;
import com.cognos.cps.services.wsrp.v1.types.UnsupportedLocaleFault;
import com.cognos.cps.services.wsrp.v1.types.UnsupportedMimeTypeFault;
import com.cognos.cps.services.wsrp.v1.types.UnsupportedModeFault;
import com.cognos.cps.services.wsrp.v1.types.UnsupportedWindowStateFault;
import com.cognos.cps.soap.SOAPFault;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public final class WSRPFaultBindings {
    private static HashMap m_bindings = new HashMap();

    public static Fault convert(SOAPFault fault) {
        if (!fault.getFaultCode().getNamespaceURI().equals("urn:oasis:names:tc:wsrp:v1:types")) {
            return null;
        }
        Class wsrpFaultClass = (Class)m_bindings.get(fault.getFaultCode().getLocalPart());
        if (wsrpFaultClass == null) {
            return null;
        }
        Fault wsrpFault = null;
        try {
            Constructor wsrpFaultConstructor = wsrpFaultClass.getConstructor(String.class, String.class);
            wsrpFault = (Fault)wsrpFaultConstructor.newInstance(fault.getFaultString(), fault.getDetail());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return wsrpFault;
    }

    static {
        m_bindings.put("AccessDenied", AccessDeniedFault.class);
        m_bindings.put("InconsistentParameters", InconsistentParametersFault.class);
        m_bindings.put("InvalidRegistration", InvalidRegistrationFault.class);
        m_bindings.put("InvalidCookie", InvalidCookieFault.class);
        m_bindings.put("InvalidHandle", InvalidHandleFault.class);
        m_bindings.put("InvalidSession", InvalidSessionFault.class);
        m_bindings.put("InvalidUserCategory", InvalidUserCategoryFault.class);
        m_bindings.put("MissingParameters", MissingParametersFault.class);
        m_bindings.put("OperationFailed", OperationFailedFault.class);
        m_bindings.put("PortletStateChangeRequired", PortletStateChangeRequiredFault.class);
        m_bindings.put("UnsupportedLocale", UnsupportedLocaleFault.class);
        m_bindings.put("UnsupportedMimeType", UnsupportedMimeTypeFault.class);
        m_bindings.put("UnsupportedMode", UnsupportedModeFault.class);
        m_bindings.put("UnsupportedWindowState", UnsupportedWindowStateFault.class);
    }
}

