/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.wsrp.v1;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.IService;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.helpers.ServiceImpl;
import com.cognos.cps.services.wsrp.v1.WSRP_v1_Markup_PortTypeImpl;
import com.cognos.cps.services.wsrp.v1.WSRP_v1_PortletManagement_PortTypeImpl;
import com.cognos.cps.services.wsrp.v1.WSRP_v1_Registration_PortTypeImpl;
import com.cognos.cps.services.wsrp.v1.WSRP_v1_ServiceDescription_PortTypeImpl;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Markup_PortType;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_PortletManagement_PortType;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_Registration_PortType;
import com.cognos.cps.services.wsrp.v1.intf.WSRP_v1_ServiceDescription_PortType;
import java.io.InputStream;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;

public class WSRPService
extends ServiceImpl
implements IService {
    public static final QName WSRP_SERVICE_NAME = new QName("urn:oasis:names:tc:wsrp:v1:wsdl", "WSRPService");
    public static final String WSRP_WSDL_BINDINGS_NAMESPACE_URI = "urn:oasis:names:tc:wsrp:v1";
    public static final QName WSRP_MARKUP_PORT_TYPE_NAME = new QName("urn:oasis:names:tc:wsrp:v1:wsdl", "WSRPBaseService");
    public static final QName WSRP_SERVICEDESCRIPTION_PORT_TYPE_NAME = new QName("urn:oasis:names:tc:wsrp:v1:wsdl", "WSRPServiceDescriptionService");
    public static final QName WSRP_REGISTRATION_PORT_TYPE_NAME = new QName("urn:oasis:names:tc:wsrp:v1:wsdl", "WSRPRegistrationService");
    public static final QName WSRP_PORTLETMANAGEMENT_PORT_TYPE_NAME = new QName("urn:oasis:names:tc:wsrp:v1:wsdl", "WSRPPortletManagementService");
    private ServiceLogger m_logger = null;
    private String m_portletManagementPortTypeAddress = null;
    private String m_registrationPortTypeAddress = null;
    private String m_markupPortTypeAddress = null;
    private String m_serviceDescriptionPortTypeAddress = null;

    public WSRPService(WSDLLocator locator, ServiceLogger logger) throws ServiceException {
        super(locator, WSRP_SERVICE_NAME);
        this.m_logger = logger;
        this.initialize();
    }

    public WSRPService(String wsdlDocumentLocation, ServiceLogger logger) throws ServiceException {
        super(wsdlDocumentLocation, WSRP_SERVICE_NAME);
        this.m_logger = logger;
        this.initialize();
    }

    public WSRPService(InputStream wsdlStream, ServiceLogger logger) throws ServiceException {
        super(wsdlStream, WSRP_SERVICE_NAME);
        this.m_logger = logger;
        this.initialize();
    }

    private void initialize() {
        this.m_markupPortTypeAddress = super.getPortAddress(WSRP_MARKUP_PORT_TYPE_NAME);
        this.m_serviceDescriptionPortTypeAddress = super.getPortAddress(WSRP_SERVICEDESCRIPTION_PORT_TYPE_NAME);
        this.m_registrationPortTypeAddress = super.getPortAddress(WSRP_REGISTRATION_PORT_TYPE_NAME);
        this.m_portletManagementPortTypeAddress = super.getPortAddress(WSRP_PORTLETMANAGEMENT_PORT_TYPE_NAME);
    }

    public String getPortletManagementPortTypeAddress() {
        return this.m_portletManagementPortTypeAddress;
    }

    public WSRP_v1_PortletManagement_PortType getPortletManagementPortType() throws ServiceException {
        if (this.m_portletManagementPortTypeAddress == null) {
            throw new ServiceException("cps.services.noboundporttype", new Object[]{this.getWSDLDocumentLocation(), WSRP_PORTLETMANAGEMENT_PORT_TYPE_NAME.getLocalPart()});
        }
        return new WSRP_v1_PortletManagement_PortTypeImpl(this.m_portletManagementPortTypeAddress, this.m_logger);
    }

    public WSRP_v1_PortletManagement_PortType getPortletManagementPortType(String portAddress) {
        return new WSRP_v1_PortletManagement_PortTypeImpl(portAddress, this.m_logger);
    }

    public static WSRP_v1_PortletManagement_PortType getPortletManagementPortType(String portAddress, ServiceLogger logger) {
        return new WSRP_v1_PortletManagement_PortTypeImpl(portAddress, logger);
    }

    public String getRegistrationPortTypeAddress() {
        return this.m_registrationPortTypeAddress;
    }

    public WSRP_v1_Registration_PortType getRegistrationPortType() throws ServiceException {
        if (this.m_registrationPortTypeAddress == null) {
            throw new ServiceException("cps.services.noboundporttype", new Object[]{this.getWSDLDocumentLocation(), WSRP_REGISTRATION_PORT_TYPE_NAME.getLocalPart()});
        }
        return new WSRP_v1_Registration_PortTypeImpl(this.m_registrationPortTypeAddress, this.m_logger);
    }

    public WSRP_v1_Registration_PortType getRegistrationPortType(String portAddress) {
        return new WSRP_v1_Registration_PortTypeImpl(portAddress, this.m_logger);
    }

    public static WSRP_v1_Registration_PortType getRegistrationPortType(String portAddress, ServiceLogger logger) {
        return new WSRP_v1_Registration_PortTypeImpl(portAddress, logger);
    }

    public String getMarkupPortTypeAddress() {
        return this.m_markupPortTypeAddress;
    }

    public WSRP_v1_Markup_PortType getMarkupPortType() throws ServiceException {
        if (this.m_markupPortTypeAddress == null) {
            throw new ServiceException("cps.services.noboundporttype", new Object[]{this.getWSDLDocumentLocation(), WSRP_MARKUP_PORT_TYPE_NAME.getLocalPart()});
        }
        return new WSRP_v1_Markup_PortTypeImpl(this.m_markupPortTypeAddress, this.m_logger);
    }

    public WSRP_v1_Markup_PortType getMarkupPortType(String portAddress) {
        return new WSRP_v1_Markup_PortTypeImpl(portAddress, this.m_logger);
    }

    public static WSRP_v1_Markup_PortType getMarkupPortType(String portAddress, ServiceLogger logger) {
        return new WSRP_v1_Markup_PortTypeImpl(portAddress, logger);
    }

    public String getServiceDescriptionPortTypeAddress() {
        return this.m_serviceDescriptionPortTypeAddress;
    }

    public WSRP_v1_ServiceDescription_PortType getServiceDescriptionPortType() throws ServiceException {
        if (this.m_serviceDescriptionPortTypeAddress == null) {
            throw new ServiceException("cps.services.noboundporttype", new Object[]{this.getWSDLDocumentLocation(), WSRP_SERVICEDESCRIPTION_PORT_TYPE_NAME.getLocalPart()});
        }
        return new WSRP_v1_ServiceDescription_PortTypeImpl(this.m_serviceDescriptionPortTypeAddress, this.m_logger);
    }

    public WSRP_v1_ServiceDescription_PortType getServiceDescriptionPortType(String portAddress) {
        return new WSRP_v1_ServiceDescription_PortTypeImpl(portAddress, this.m_logger);
    }

    public static WSRP_v1_ServiceDescription_PortType getServiceDescriptionPortType(String portAddress, ServiceLogger logger) {
        return new WSRP_v1_ServiceDescription_PortTypeImpl(portAddress, logger);
    }
}

