/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.wsrp.v1;

import com.cognos.cps.common.logging.ServiceLogger;
import com.cognos.cps.services.ServiceException;
import com.cognos.cps.services.helpers.ContextImpl;
import com.cognos.cps.services.wsrp.v1.WSRPFaultBindings;
import com.cognos.cps.services.wsrp.v1.types.Fault;
import com.cognos.cps.services.wsrp.v1.types.TypeFactory;
import com.cognos.cps.soap.SOAPConnection;
import com.cognos.cps.soap.SOAPConnectionFactory;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPMessage;
import java.io.IOException;
import org.xml.sax.SAXException;

class WSRPStub
extends ContextImpl {
    private String m_url;
    private ServiceLogger m_logger;

    private WSRPStub() {
    }

    protected WSRPStub(String url, ServiceLogger logger) {
        this.m_url = url;
        this.m_logger = logger;
    }

    protected SOAPMessage sendRequest(SOAPMessage request) throws Fault, ServiceException {
        SOAPConnection soapConnection = (SOAPConnection)this.getProperty("SOAPConnection");
        if (soapConnection == null) {
            soapConnection = SOAPConnectionFactory.newInstance().createConnection(TypeFactory.newInstance(), this.m_logger);
        }
        try {
            SOAPMessage sOAPMessage = soapConnection.call(request, this.m_url);
            return sOAPMessage;
        }
        catch (SOAPFault e) {
            Fault wsrpFault = WSRPFaultBindings.convert(e);
            if (wsrpFault != null) {
                throw wsrpFault;
            }
            throw new ServiceException("cps.services.nonwebservicefault", new String[]{this.m_url, e.getFaultString()}, e);
        }
        catch (IOException e) {
            throw new ServiceException("cps.services.soaprequestfailed", new String[]{this.m_url}, e);
        }
        catch (SAXException e) {
            throw new ServiceException("cps.services.soaprequestfailed", new String[]{this.m_url}, e);
        }
        finally {
            soapConnection.disconnect();
        }
    }
}

