/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.services.wsrp.v1.types;

import com.cognos.cps.services.wsrp.v1.types.Extension;
import com.cognos.cps.services.wsrp.v1.types.LocalizedString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;

public class ItemDescription
implements Serializable {
    private String _itemName;
    private LocalizedString _description;
    private ArrayList _extensionsList = new ArrayList();

    public void addExtensions(Extension vExtensions) throws IndexOutOfBoundsException {
        this._extensionsList.add(vExtensions);
    }

    public void addExtensions(int index, Extension vExtensions) throws IndexOutOfBoundsException {
        this._extensionsList.add(index, vExtensions);
    }

    public void clearExtensions() {
        this._extensionsList.clear();
    }

    public Enumeration enumerateExtensions() {
        return new IteratorEnumeration(this._extensionsList.iterator());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ItemDescription) {
            ItemDescription temp = (ItemDescription)obj;
            if (this._itemName != null) {
                if (temp._itemName == null) {
                    return false;
                }
                if (!this._itemName.equals(temp._itemName)) {
                    return false;
                }
            } else if (temp._itemName != null) {
                return false;
            }
            if (this._description != null) {
                if (temp._description == null) {
                    return false;
                }
                if (!this._description.equals(temp._description)) {
                    return false;
                }
            } else if (temp._description != null) {
                return false;
            }
            if (this._extensionsList != null) {
                if (temp._extensionsList == null) {
                    return false;
                }
                if (!this._extensionsList.equals(temp._extensionsList)) {
                    return false;
                }
            } else if (temp._extensionsList != null) {
                return false;
            }
            return true;
        }
        return false;
    }

    public LocalizedString getDescription() {
        return this._description;
    }

    public Extension getExtensions(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._extensionsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Extension)this._extensionsList.get(index);
    }

    public Extension[] getExtensions() {
        int size = this._extensionsList.size();
        Extension[] mArray = new Extension[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Extension)this._extensionsList.get(index);
        }
        return mArray;
    }

    public int getExtensionsCount() {
        return this._extensionsList.size();
    }

    public String getItemName() {
        return this._itemName;
    }

    public int hashCode() {
        int _hashCode = 17;
        if (this._itemName != null) {
            _hashCode = 37 * _hashCode + this._itemName.hashCode();
        }
        if (this._description != null) {
            _hashCode = 37 * _hashCode + this._description.hashCode();
        }
        if (this._extensionsList != null) {
            _hashCode = 37 * _hashCode + this._extensionsList.hashCode();
        }
        return _hashCode;
    }

    public boolean removeExtensions(Extension vExtensions) {
        boolean removed = this._extensionsList.remove(vExtensions);
        return removed;
    }

    public void setDescription(LocalizedString description) {
        this._description = description;
    }

    public void setExtensions(int index, Extension vExtensions) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._extensionsList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._extensionsList.set(index, vExtensions);
    }

    public void setExtensions(Extension[] extensionsArray) {
        this._extensionsList.clear();
        for (int i = 0; i < extensionsArray.length; ++i) {
            this._extensionsList.add(extensionsArray[i]);
        }
    }

    public void setItemName(String itemName) {
        this._itemName = itemName;
    }
}

