/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cps.soap;

import com.cognos.cps.common.sax.EnhancedSAXException;
import com.cognos.cps.soap.PrefixNamespaceMapping;
import com.cognos.cps.soap.SOAPFault;
import com.cognos.cps.soap.SOAPFaultContentHandler;
import com.cognos.cps.soap.SOAPMessage;
import com.cognos.cps.soap.SOAPObjectHandler;
import com.cognos.cps.soap.helpers.SOAPObjectHandlerImpl;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SOAPEnvelopeContentHandler
implements ContentHandler {
    private SOAPFaultContentHandler m_soapFaultContentHander = null;
    private List m_inScopeNamespacePrefixes = new ArrayList();
    private SOAPObjectHandler m_soapBodyObjectHandler = null;
    private ContentHandler m_currentContentHandler = null;
    private SOAPObjectHandler m_currentObjectHandler = null;
    private SOAPObjectHandler m_soapHeaderHandler;
    private SOAPMessage m_response;
    private int m_messageDepth = 0;
    private boolean m_insideHeader;

    private SOAPEnvelopeContentHandler() {
    }

    public SOAPEnvelopeContentHandler(SOAPObjectHandler soapBodyObjectHandler, SOAPMessage response) {
        this.m_soapBodyObjectHandler = soapBodyObjectHandler;
        this.m_soapHeaderHandler = new SOAPObjectHandlerImpl();
        this.m_response = response;
    }

    public SOAPEnvelopeContentHandler(SOAPObjectHandler soapBodyObjectHandler, SOAPObjectHandler soapHeaderObjectHandler, SOAPMessage response) {
        this.m_soapBodyObjectHandler = soapBodyObjectHandler;
        this.m_soapHeaderHandler = soapHeaderObjectHandler;
        this.m_response = response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.m_messageDepth;
        switch (this.m_messageDepth) {
            case 1: {
                if (localName.equals("Envelope") && uri.equals("http://schemas.xmlsoap.org/soap/envelope/")) break;
                throw new EnhancedSAXException("cps.soap.missingenvelopeelement", new Object[]{localName});
            }
            case 2: {
                if (localName.equals("Body") && uri.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    this.m_currentObjectHandler = this.m_soapBodyObjectHandler;
                    break;
                }
                if (localName.equals("Header") && uri.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    this.m_currentObjectHandler = this.m_soapHeaderHandler;
                    this.m_insideHeader = true;
                    break;
                }
                throw new EnhancedSAXException("cps.soap.invalidsoapmessage", new Object[]{localName});
            }
            case 3: {
                if (localName.equals("Fault") && uri.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                    this.m_soapFaultContentHander = new SOAPFaultContentHandler();
                    this.m_currentContentHandler = this.m_soapFaultContentHander;
                    this.propagateStartPrefixNamespaceMappings();
                    break;
                }
                if (this.m_currentObjectHandler == null) break;
                this.m_currentContentHandler = this.m_currentObjectHandler.getContentHandler(uri, localName);
                if (this.m_currentContentHandler == null) {
                    throw new EnhancedSAXException("cps.soap.failedtoresolveelement", new Object[]{localName, uri});
                }
                this.propagateStartPrefixNamespaceMappings();
                this.m_currentContentHandler.startElement(uri, localName, qName, atts);
                break;
            }
            default: {
                if (this.m_currentContentHandler == null) break;
                this.m_currentContentHandler.startElement(uri, localName, qName, atts);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.m_messageDepth) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.m_insideHeader) break;
                this.m_insideHeader = false;
                break;
            }
            case 3: {
                if (this.m_currentContentHandler == null) break;
                if (this.m_currentContentHandler.equals(this.m_soapFaultContentHander)) {
                    this.propagateEndPrefixNamespaceMappings();
                    throw new EnhancedSAXException("cps.soap.soapfaultencountered", (SOAPFault)this.m_soapFaultContentHander.getObject());
                }
                this.m_currentContentHandler.endElement(uri, localName, qName);
                this.propagateEndPrefixNamespaceMappings();
                Object object = this.m_currentObjectHandler.getObject(this.m_currentContentHandler);
                if (this.m_insideHeader) {
                    this.m_response.addHeader(object);
                } else {
                    this.m_response.setBody(object);
                    this.m_response.setBodyRootElemName(new QName(uri, localName));
                }
                this.m_currentContentHandler = null;
                break;
            }
            default: {
                if (this.m_currentContentHandler == null) break;
                this.m_currentContentHandler.endElement(uri, localName, qName);
            }
        }
        --this.m_messageDepth;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentContentHandler != null) {
            this.m_currentContentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!prefix.startsWith("xml:")) {
            if (this.m_currentContentHandler != null) {
                this.m_currentContentHandler.startPrefixMapping(prefix, uri);
            } else {
                PrefixNamespaceMapping mapping = new PrefixNamespaceMapping(prefix, uri);
                this.m_inScopeNamespacePrefixes.add(mapping);
            }
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (!prefix.startsWith("xml:")) {
            if (this.m_currentContentHandler != null) {
                this.m_currentContentHandler.endPrefixMapping(prefix);
            } else {
                for (int i = this.m_inScopeNamespacePrefixes.size() - 1; i >= 0; --i) {
                    PrefixNamespaceMapping current = (PrefixNamespaceMapping)this.m_inScopeNamespacePrefixes.get(i);
                    if (!current.getPrefix().equals(prefix)) continue;
                    this.m_inScopeNamespacePrefixes.remove(i);
                    break;
                }
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.m_currentContentHandler != null) {
            this.m_currentContentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.m_currentContentHandler != null) {
            this.m_currentContentHandler.processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.m_currentContentHandler != null) {
            this.m_currentContentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.m_currentContentHandler != null) {
            this.m_currentContentHandler.skippedEntity(name);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    private void propagateStartPrefixNamespaceMappings() throws SAXException {
        if (this.m_currentContentHandler != null) {
            for (int i = 0; i < this.m_inScopeNamespacePrefixes.size(); ++i) {
                PrefixNamespaceMapping mapping = (PrefixNamespaceMapping)this.m_inScopeNamespacePrefixes.get(i);
                if (this.m_inScopeNamespacePrefixes.lastIndexOf(mapping) != i) continue;
                this.m_currentContentHandler.startPrefixMapping(mapping.getPrefix(), mapping.getURI());
            }
        }
    }

    private void propagateEndPrefixNamespaceMappings() throws SAXException {
        if (this.m_currentContentHandler != null) {
            for (int i = this.m_inScopeNamespacePrefixes.size() - 1; i >= 0; --i) {
                PrefixNamespaceMapping mapping = (PrefixNamespaceMapping)this.m_inScopeNamespacePrefixes.get(i);
                if (this.m_inScopeNamespacePrefixes.lastIndexOf(mapping) != i) continue;
                this.m_currentContentHandler.endPrefixMapping(mapping.getPrefix());
            }
        }
    }
}

