/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.xml.serializer;

import com.ibm.cognos.xml.serializer.BaseMarkupSerializer;
import com.ibm.cognos.xml.serializer.DOMMessageFormatter;
import com.ibm.cognos.xml.serializer.ElementState;
import com.ibm.cognos.xml.serializer.NamespaceSupport;
import com.ibm.cognos.xml.serializer.OutputFormat;
import com.ibm.cognos.xml.serializer.SymbolTable;
import com.ibm.cognos.xml.serializer.XMLChar;
import com.ibm.cognos.xml.serializer.XMLSymbols;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected static final String PREFIX = "NS";
    protected boolean fNamespaces = false;
    protected boolean fNamespacePrefixes = true;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(output);
    }

    @Override
    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
        if (this.fNSBinder == null) {
            this.fNSBinder = new NamespaceSupport();
            this.fLocalNSBinder = new NamespaceSupport();
            this.fSymbolTable = new SymbolTable();
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        try {
            String value;
            String name;
            String prefix;
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoName", null);
                    throw new SAXException(msg);
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
            }
            this._printer.printText('<');
            this._printer.printText(rawName);
            this._printer.indent();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this._printer.printSpace();
                    name = attrs.getQName(i);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue(i)) == null) {
                        value = "";
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    if (!name.equals("xml:space")) continue;
                    preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                }
            }
            if (this._prefixes != null) {
                Iterator entries = this._prefixes.entrySet().iterator();
                while (entries.hasNext()) {
                    this._printer.printSpace();
                    Map.Entry entry = entries.next();
                    value = (String)entry.getKey();
                    name = (String)entry.getValue();
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this._format.isCDataElement(name);
            state.unescaped = this._format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText("/>");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    @Override
    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this._printer == null) {
                String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "NoWriterSupplied", null);
                throw new IllegalStateException(msg);
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    this._printer.printSpace();
                    String name = attrs.getName(i);
                    String value = attrs.getValue(i);
                    if (value != null) {
                        this._printer.printText(name);
                        this._printer.printText("=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                    }
                    if (!name.equals("xml:space")) continue;
                    preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                }
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer buffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    buffer.append(this._format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                String format_encoding = this._format.getEncoding();
                if (format_encoding != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(format_encoding);
                    buffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this._printer.printText(buffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            for (int i = 0; i < 18 + rootTagName.length(); ++i) {
                                this._printer.printText(" ");
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(dtd, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    this._printer.printText(" [");
                    this.printText(dtd, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    private void printNamespaceAttr(String prefix, String uri) throws IOException {
        this._printer.printSpace();
        if (prefix == XMLSymbols.EMPTY_STRING) {
            this._printer.printText(XMLSymbols.PREFIX_XMLNS);
        } else {
            this._printer.printText("xmlns:" + prefix);
        }
        this._printer.printText("=\"");
        this.printEscaped(uri);
        this._printer.printText('\"');
    }

    @Override
    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        if (attrs == null) {
            return null;
        }
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        for (int i = length - 1; i >= 0; --i) {
            String rawName = attrsOnly.getQName(i);
            if (!rawName.startsWith("xmlns")) continue;
            if (rawName.length() == 5) {
                this.startPrefixMapping("", attrs.getValue(i));
                attrsOnly.removeAttribute(i);
                continue;
            }
            if (rawName.charAt(5) != ':') continue;
            this.startPrefixMapping(rawName.substring(6), attrs.getValue(i));
            attrsOnly.removeAttribute(i);
        }
        return attrsOnly;
    }

    @Override
    protected void printEscaped(String source) throws IOException {
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (!XMLChar.isValid(ch)) {
                if (++i < length) {
                    this.surrogates(ch, source.charAt(i), false);
                    continue;
                }
                this.fatalError("The character '" + (char)ch + "' is an invalid XML character");
                continue;
            }
            if (ch == '\n' || ch == '\r' || ch == '\t') {
                this.printHex(ch);
                continue;
            }
            if (ch == '<') {
                this._printer.printText("&lt;");
                continue;
            }
            if (ch == '&') {
                this._printer.printText("&amp;");
                continue;
            }
            if (ch == '\"') {
                this._printer.printText("&quot;");
                continue;
            }
            if (ch >= ' ' && this._encodingInfo.isPrintable(ch)) {
                this._printer.printText(ch);
                continue;
            }
            this.printHex(ch);
        }
    }

    protected void printXMLChar(int ch) throws IOException {
        if (ch == 13) {
            this.printHex(ch);
        } else if (ch == 60) {
            this._printer.printText("&lt;");
        } else if (ch == 38) {
            this._printer.printText("&amp;");
        } else if (ch == 62) {
            this._printer.printText("&gt;");
        } else if (ch == 10 || ch == 9 || ch >= 32 && this._encodingInfo.isPrintable((char)ch)) {
            this._printer.printText((char)ch);
        } else {
            this.printHex(ch);
        }
    }

    @Override
    protected void printText(String text, boolean preserveSpace, boolean unescaped) throws IOException {
        int length = text.length();
        if (preserveSpace) {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index), true);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                char ch = text.charAt(index);
                if (!XMLChar.isValid(ch)) {
                    if (++index < length) {
                        this.surrogates(ch, text.charAt(index), true);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    @Override
    protected void printText(char[] chars, int start, int length, boolean preserveSpace, boolean unescaped) throws IOException {
        if (preserveSpace) {
            while (length-- > 0) {
                char ch;
                if (!XMLChar.isValid(ch = chars[start++])) {
                    if (length-- > 0) {
                        this.surrogates(ch, chars[start++], true);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        } else {
            while (length-- > 0) {
                char ch;
                if (!XMLChar.isValid(ch = chars[start++])) {
                    if (length-- > 0) {
                        this.surrogates(ch, chars[start++], true);
                        continue;
                    }
                    this.fatalError("The character '" + ch + "' is an invalid XML character");
                    continue;
                }
                if (unescaped) {
                    this._printer.printText(ch);
                    continue;
                }
                this.printXMLChar(ch);
            }
        }
    }

    @Override
    protected void checkUnboundNamespacePrefixedNode(Node node) throws IOException {
        if (this.fNamespaces) {
            Node child = node.getFirstChild();
            while (child != null) {
                Node next = child.getNextSibling();
                String prefix = child.getPrefix();
                String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                if (this.fNSBinder.getURI(prefix) == null && prefix != null) {
                    this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + child.getNodeName() + "' with an undeclared prefix '" + prefix + "'.");
                }
                if (child.getNodeType() == 1) {
                    NamedNodeMap attrs = child.getAttributes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        String attrPrefix = attrs.item(i).getPrefix();
                        String string2 = attrPrefix = attrPrefix == null || attrPrefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(attrPrefix);
                        if (this.fNSBinder.getURI(attrPrefix) != null || attrPrefix == null) continue;
                        this.fatalError("The replacement text of the entity node '" + node.getNodeName() + "' contains an element node '" + child.getNodeName() + "' with an attribute '" + attrs.item(i).getNodeName() + "' an undeclared prefix '" + attrPrefix + "'.");
                    }
                }
                if (child.hasChildNodes()) {
                    this.checkUnboundNamespacePrefixedNode(child);
                }
                child = next;
            }
        }
    }

    @Override
    public boolean reset() {
        super.reset();
        if (this.fNSBinder != null) {
            this.fNSBinder.reset();
            this.fNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        }
        return true;
    }
}

