/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class IdentityKeyGenerator
implements KeyGenerator {
    private static Log _log = LogFactory.getFactory().getInstance(IdentityKeyGenerator.class);
    private final int _sqlType;
    private final String _fName;

    public IdentityKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        String fName = factory.getFactoryName();
        if (!(fName.equals("sybase") || fName.equals("sql-server") || fName.equals("hsql") || fName.equals("mysql") || fName.equals("informix") || fName.equals("db2") || fName.equals("sapdb"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), fName));
        }
        this._fName = fName;
        this._sqlType = sqlType;
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
        if (sqlType != 4 && this._fName.equals("hsql")) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Statement stmt = null;
        try {
            ResultSet rs;
            if (this._fName.equals("hsql")) {
                CallableStatement cstmt = conn.prepareCall("{call IDENTITY()}");
                stmt = cstmt;
                cstmt.execute();
                rs = cstmt.getResultSet();
            } else if (this._fName.equals("mysql")) {
                stmt = conn.prepareStatement("SELECT LAST_INSERT_ID()");
                rs = stmt.executeQuery();
            } else if (this._fName.equals("informix")) {
                stmt = conn.prepareStatement("select dbinfo('sqlca.sqlerrd1') from systables where tabid = 1");
                rs = stmt.executeQuery();
            } else if (this._fName.equals("db2")) {
                stmt = conn.prepareStatement("SELECT IDENTITY_VAL_LOCAL() FROM " + tableName + " FETCH FIRST ROW ONLY");
                rs = stmt.executeQuery();
            } else if (this._fName.equals("sapdb")) {
                stmt = conn.prepareStatement("SELECT " + tableName + ".currval" + " FROM " + tableName);
                rs = stmt.executeQuery();
            } else {
                stmt = conn.prepareStatement("SELECT @@identity");
                rs = stmt.executeQuery();
            }
            if (rs.next()) {
                int value = rs.getInt(1);
                if (this._sqlType == 4) {
                    Integer n = new Integer(value);
                    return n;
                }
                if (this._sqlType == -5) {
                    Long l = new Long(value);
                    return l;
                }
                BigDecimal bigDecimal = new BigDecimal(value);
                return bigDecimal;
            }
            try {
                throw new PersistenceException(Messages.message("persist.keyGenFailed"));
            }
            catch (SQLException ex) {
                throw new PersistenceException(Messages.format("persist.keyGenSQL", ex.toString()));
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    _log.warn((Object)"Problem closing JDBC Statement", (Throwable)ex);
                }
            }
        }
    }

    public final byte getStyle() {
        return 1;
    }

    public final String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

