/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.exolab.castor.jdo.drivers.JDBCQueryExpression;
import org.exolab.castor.persist.spi.PersistenceFactory;

public final class InterbaseQueryExpression
extends JDBCQueryExpression {
    private StringBuffer sql;

    public InterbaseQueryExpression(PersistenceFactory factory) {
        super(factory);
    }

    public String getStatement(boolean lock) {
        Vector<String> done = new Vector<String>();
        this.sql = new StringBuffer();
        this.sql.append("SELECT ");
        if (this._distinct) {
            this.sql.append(" DISTINCT ");
        }
        this.sql.append(this.getColumnList());
        this.sql.append(" FROM ");
        Hashtable tables = (Hashtable)this._tables.clone();
        boolean first = true;
        for (int i = 0; i < this._joins.size(); ++i) {
            JDBCQueryExpression.Join join = (JDBCQueryExpression.Join)this._joins.elementAt(i);
            if (done.contains(join.leftTable)) continue;
            if (first) {
                first = false;
                this.sql.append(this._factory.quoteName(join.leftTable));
            }
            this.appendJoin(join);
            tables.remove(join.leftTable);
            tables.remove(join.rightTable);
            for (int k = i + 1; k < this._joins.size(); ++k) {
                JDBCQueryExpression.Join join2 = (JDBCQueryExpression.Join)this._joins.elementAt(k);
                if (!join.leftTable.equals(join2.leftTable)) continue;
                this.appendJoin(join2);
                tables.remove(join2.rightTable);
            }
            done.addElement(join.leftTable);
        }
        Enumeration theEnum = tables.keys();
        while (theEnum.hasMoreElements()) {
            if (first) {
                first = false;
            } else {
                this.sql.append(",");
            }
            String tableAlias = (String)theEnum.nextElement();
            String tableName = (String)tables.get(tableAlias);
            if (tableAlias.equals(tableName)) {
                this.sql.append(this._factory.quoteName(tableName));
                continue;
            }
            this.sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        first = this.addWhereClause(this.sql, true);
        if (this._order != null) {
            this.sql.append(" ORDER BY ").append(this._order);
        }
        return this.sql.toString();
    }

    void appendJoin(JDBCQueryExpression.Join join) {
        if (join.outer) {
            this.sql.append(" LEFT OUTER JOIN ");
        } else {
            this.sql.append(" INNER JOIN ");
        }
        String tableAlias = join.rightTable;
        String tableName = (String)this._tables.get(tableAlias);
        if (tableAlias.equals(tableName)) {
            this.sql.append(this._factory.quoteName(tableName));
        } else {
            this.sql.append(this._factory.quoteName(tableName) + " " + this._factory.quoteName(tableAlias));
        }
        this.sql.append(" ON ");
        for (int j = 0; j < join.leftColumns.length; ++j) {
            if (j > 0) {
                this.sql.append(" AND ");
            }
            this.sql.append(this._factory.quoteName(join.leftTable + "." + join.leftColumns[j])).append("=");
            this.sql.append(this._factory.quoteName(join.rightTable + "." + join.rightColumns[j]));
        }
    }
}

