/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.JdoConf;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.DTDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOConfLoader {
    private static boolean _loaded = false;
    private static JdoConf _jdoConf = null;

    public static synchronized void loadConfiguration(InputSource source, EntityResolver resolver) throws MappingException {
        if (!_loaded) {
            Unmarshaller unmarshaller = new Unmarshaller(JdoConf.class);
            try {
                if (resolver == null) {
                    unmarshaller.setEntityResolver(new DTDResolver());
                } else {
                    unmarshaller.setEntityResolver(new DTDResolver(resolver));
                }
                _jdoConf = (JdoConf)unmarshaller.unmarshal(source);
            }
            catch (MarshalException e) {
                throw new MappingException(e);
            }
            catch (ValidationException e) {
                throw new MappingException(e);
            }
            _loaded = true;
        }
    }

    public static Database getDatabase(InputSource source, EntityResolver resolver) throws MappingException {
        JDOConfLoader.loadConfiguration(source, resolver);
        return _jdoConf.getDatabase();
    }

    public static TransactionDemarcation getTransactionDemarcation(InputSource source, EntityResolver resolver) throws MappingException {
        JDOConfLoader.loadConfiguration(source, resolver);
        return _jdoConf.getTransactionDemarcation();
    }

    public static Mapping[] getMapping(InputSource source, EntityResolver resolver) throws MappingException {
        JDOConfLoader.loadConfiguration(source, resolver);
        return _jdoConf.getDatabase().getMapping();
    }

    public static synchronized void deleteConfiguration() {
        _loaded = false;
    }

    public static synchronized boolean isLoaded() {
        return _loaded;
    }
}

