/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.io.FileWriter;
import java.io.PrintWriter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.TransactionDemarcation;
import org.exolab.castor.jdo.engine.JDOConfLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOConfigLoaderTest
extends TestCase {
    private InputSource source = null;
    private EntityResolver resolver = null;
    private ClassLoader classLoader = null;
    private PrintWriter writer = null;

    public JDOConfigLoaderTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.source = new InputSource("src/examples/jdo/jdo-conf.xml");
        this.writer = new PrintWriter(new FileWriter("output.log"));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.writer.flush();
        this.writer.close();
    }

    public void testGetDatabase() throws Exception {
        Database database = JDOConfLoader.getDatabase(this.source, this.resolver);
        this.writer.println(database);
    }

    public void testGetTransactionDemarcation() throws Exception {
        TransactionDemarcation transactionDemarcation = JDOConfLoader.getTransactionDemarcation(this.source, this.resolver);
        this.writer.println(transactionDemarcation);
    }

    public void testGetMapping() throws Exception {
    }

    public void testLoadConfigurationLocalMinimal() throws Exception {
        this.source = new InputSource("src/examples/jdo/jdo-conf.minimal.xml");
        JDOConfLoader.deleteConfiguration();
        TransactionDemarcation demarcation = JDOConfLoader.getTransactionDemarcation(this.source, this.resolver);
        JDOConfigLoaderTest.assertNotNull((Object)demarcation);
        JDOConfigLoaderTest.assertNull((Object)demarcation.getTransactionManager());
    }

    public void testLoadConfigurationGlobalJNDI() throws Exception {
        this.source = new InputSource("src/examples/jdo/jdo-conf.global.jndi.xml");
        JDOConfLoader.deleteConfiguration();
        TransactionDemarcation demarcation = JDOConfLoader.getTransactionDemarcation(this.source, this.resolver);
        JDOConfigLoaderTest.assertNotNull((Object)demarcation);
        JDOConfigLoaderTest.assertEquals((String)demarcation.getMode(), (String)"global");
        JDOConfigLoaderTest.assertNotNull((Object)demarcation.getTransactionManager());
        JDOConfigLoaderTest.assertEquals((String)demarcation.getTransactionManager().getName(), (String)"jndi");
    }

    public void testLoadConfigurationGlobalJNDIWithParams() throws Exception {
        this.source = new InputSource("src/examples/jdo/jdo-conf.global.jndi.with-params.xml");
        JDOConfLoader.deleteConfiguration();
        TransactionDemarcation demarcation = JDOConfLoader.getTransactionDemarcation(this.source, this.resolver);
        JDOConfigLoaderTest.assertNotNull((Object)demarcation);
        JDOConfigLoaderTest.assertEquals((String)demarcation.getMode(), (String)"global");
        JDOConfigLoaderTest.assertNotNull((Object)demarcation.getTransactionManager());
        JDOConfigLoaderTest.assertEquals((String)demarcation.getTransactionManager().getName(), (String)"jndi");
        JDOConfigLoaderTest.assertEquals((int)demarcation.getTransactionManager().getParamCount(), (int)1);
    }

    public void testLoadConfigurationMissingTransactionDemarcation() throws Exception {
        this.source = new InputSource("src/examples/jdo/jdo-conf.missing-demarcation.xml");
        JDOConfLoader.deleteConfiguration();
        TransactionDemarcation demarcation = JDOConfLoader.getTransactionDemarcation(this.source, this.resolver);
        JDOConfigLoaderTest.assertNull((Object)demarcation);
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new JDOConfigLoaderTest("testGetDatabase"));
        suite.addTest((Test)new JDOConfigLoaderTest("testGetTransactionDemarcation"));
        suite.addTest((Test)new JDOConfigLoaderTest("testGetMapping"));
        suite.addTest((Test)new JDOConfigLoaderTest("testLoadConfigurationLocalMinimal"));
        suite.addTest((Test)new JDOConfigLoaderTest("testLoadConfigurationMissingTransactionDemarcation"));
        suite.addTest((Test)new JDOConfigLoaderTest("testLoadConfigurationGlobalJNDI"));
        suite.addTest((Test)new JDOConfigLoaderTest("testLoadConfigurationGlobalJNDIWithParams"));
        return suite;
    }
}

