/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorRegistry;
import org.exolab.castor.jdo.engine.SQLTypes;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.CacheTypeMapping;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.mapping.xml.types.DirtyType;
import org.exolab.castor.util.Messages;

public class JDOMappingLoader
extends MappingLoader {
    private Hashtable _keyGenDefs = new Hashtable();
    private Hashtable _keyGenDescs = new Hashtable();
    private BaseFactory _factory;
    private KeyGeneratorRegistry _keyGenReg = new KeyGeneratorRegistry();

    public JDOMappingLoader(ClassLoader loader, PrintWriter logWriter) {
        super(loader, logWriter);
    }

    protected ClassDescriptor createDescriptor(ClassMapping clsMap) throws MappingException {
        CacheTypeMapping cacheMapping;
        if (clsMap.getMapTo() == null || clsMap.getMapTo().getTable() == null) {
            return NoDescriptor;
        }
        ClassDescriptor clsDesc = this.loadClassDescriptor(clsMap.getName());
        if (clsDesc != null && clsDesc instanceof JDOClassDescriptor) {
            return clsDesc;
        }
        clsDesc = super.createDescriptor(clsMap);
        if (clsDesc.getIdentity() == null) {
            throw new MappingException("mapping.noIdentity", clsDesc.getJavaClass().getName());
        }
        String keyGenName = clsMap.getKeyGenerator();
        KeyGeneratorDescriptor keyGenDesc = null;
        if (keyGenName != null) {
            KeyGeneratorDef keyGenDef = (KeyGeneratorDef)this._keyGenDefs.get(keyGenName);
            Properties params = new Properties();
            String keyGenFactoryName = keyGenName;
            if (keyGenDef != null) {
                keyGenFactoryName = keyGenDef.getName();
                Enumeration theEnum = keyGenDef.enumerateParam();
                while (theEnum.hasMoreElements()) {
                    Param par = (Param)theEnum.nextElement();
                    params.put(par.getName(), par.getValue());
                }
            }
            if ((keyGenDesc = (KeyGeneratorDescriptor)this._keyGenDescs.get(keyGenName)) == null) {
                keyGenDesc = new KeyGeneratorDescriptor(keyGenName, keyGenFactoryName, params, this._keyGenReg);
                this._keyGenDescs.put(keyGenName, keyGenDesc);
            }
        }
        JDOClassDescriptor jd = (cacheMapping = clsMap.getCacheTypeMapping()) != null ? new JDOClassDescriptor(clsDesc, clsMap.getMapTo().getTable(), keyGenDesc, cacheMapping.getType().toString(), cacheMapping.getCapacity()) : new JDOClassDescriptor(clsDesc, clsMap.getMapTo().getTable(), keyGenDesc, null, 0);
        jd.setMapping(clsMap);
        return jd;
    }

    protected String[] getSqlTypes(FieldMapping fieldMap) {
        int current;
        if (fieldMap.getSql() == null) {
            return new String[0];
        }
        String sqlType = fieldMap.getSql().getType();
        if (sqlType == null) {
            return new String[0];
        }
        ArrayList<String> types = new ArrayList<String>();
        int begin = 0;
        int state = 0;
        block4: for (current = 0; current < sqlType.length(); ++current) {
            switch (state) {
                case 0: {
                    if (sqlType.charAt(current) == ' ') {
                        types.add(sqlType.substring(begin, current));
                        begin = current + 1;
                        continue block4;
                    }
                    if (sqlType.charAt(current) != '[') continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (sqlType.charAt(current) != ']') continue block4;
                    state = 0;
                }
            }
        }
        types.add(sqlType.substring(begin, current));
        String[] result = new String[types.size()];
        return types.toArray(result);
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        TypeConvertor convertorTo = null;
        TypeConvertor convertorFrom = null;
        String convertorParam = null;
        String typeName = null;
        Class sqlType = null;
        fieldType = Types.typeFromPrimitive(fieldType);
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (fieldMap.getSql() != null && sqlTypes.length > 0) {
            typeName = sqlTypes[0];
            sqlType = SQLTypes.typeFromName(typeName);
        } else {
            sqlType = fieldType;
        }
        if (this._factory != null) {
            sqlType = this._factory.adjustSqlType(sqlType);
        }
        if (fieldType != sqlType) {
            convertorTo = SQLTypes.getConvertor(sqlType, fieldType);
            convertorFrom = SQLTypes.getConvertor(fieldType, sqlType);
            if (typeName != null) {
                convertorParam = SQLTypes.paramFromName(typeName);
            }
        }
        return new TypeInfo(fieldType, convertorTo, convertorFrom, convertorParam, fieldMap.getRequired(), null, colHandler);
    }

    protected FieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        int[] sType;
        if (fieldMap.getSql() == null) {
            return super.createFieldDesc(javaClass, fieldMap);
        }
        FieldDescriptor fieldDesc = super.createFieldDesc(javaClass, fieldMap);
        String[] sqlName = fieldMap.getSql().getName();
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        int len = sqlTypes.length;
        if (len > 0) {
            sType = new int[len];
            for (int i = 0; i < len; ++i) {
                Class sqlType = SQLTypes.typeFromName(sqlTypes[i]);
                if (this._factory != null) {
                    sqlType = this._factory.adjustSqlType(sqlType);
                }
                sType[i] = SQLTypes.getSQLType(sqlType);
            }
        } else {
            Class sqlType = fieldDesc.getFieldType();
            if (this._factory != null) {
                sqlType = this._factory.adjustSqlType(sqlType);
            }
            sType = new int[]{SQLTypes.getSQLType(sqlType)};
        }
        return new JDOFieldDescriptor((FieldDescriptorImpl)fieldDesc, sqlName, sType, !DirtyType.IGNORE.equals(fieldMap.getSql().getDirty()), fieldMap.getSql().getManyTable(), fieldMap.getSql().getManyKey(), fieldMap.getSql().getReadonly());
    }

    public void loadMapping(MappingRoot mapping, Object param) throws MappingException {
        this._factory = (BaseFactory)param;
        Enumeration theEnum = mapping.enumerateKeyGeneratorDef();
        while (theEnum.hasMoreElements()) {
            KeyGeneratorDef keyGenDef = (KeyGeneratorDef)theEnum.nextElement();
            String name = keyGenDef.getAlias();
            if (name == null) {
                name = keyGenDef.getName();
            }
            if (this._keyGenDefs.get(name) != null) {
                throw new MappingException(Messages.format("mapping.dupKeyGen", name));
            }
            this._keyGenDefs.put(name, keyGenDef);
        }
        super.loadMapping(mapping, null);
        this._keyGenDefs = null;
        this._keyGenDescs = null;
        this._keyGenReg = null;
    }
}

