/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.exolab.castor.persist.FieldMolder;

abstract class CollectionProxy {
    CollectionProxy() {
    }

    abstract Object getCollection();

    abstract void add(Object var1, Object var2);

    abstract void close();

    static CollectionProxy create(FieldMolder fm, Object object, ClassLoader cl) {
        Class cls = fm.getCollectionType();
        if (cls == Vector.class) {
            return new ColProxy(fm, object, cl, new Vector());
        }
        if (cls == ArrayList.class) {
            return new ColProxy(fm, object, cl, new ArrayList());
        }
        if (cls == Collection.class) {
            return new ColProxy(fm, object, cl, new ArrayList());
        }
        if (cls == Set.class) {
            return new ColProxy(fm, object, cl, new HashSet());
        }
        if (cls == HashSet.class) {
            return new ColProxy(fm, object, cl, new HashSet());
        }
        if (cls == Hashtable.class) {
            return new MapProxy(fm, object, cl, new Hashtable());
        }
        if (cls == HashMap.class) {
            return new MapProxy(fm, object, cl, new HashMap());
        }
        if (cls == Map.class) {
            return new MapProxy(fm, object, cl, new HashMap());
        }
        throw new IllegalArgumentException("Collection Proxy doesn't exist for this type : " + cls);
    }

    private static class MapProxy
    extends CollectionProxy {
        private Map _map;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private MapProxy(FieldMolder fm, Object object, ClassLoader cl, Map map) {
            this._cl = cl;
            this._map = map;
            this._fm = fm;
            this._object = object;
        }

        Object getCollection() {
            return this._map;
        }

        void add(Object key, Object value) {
            this._map.put(key, value);
        }

        void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._map, this._cl);
            }
        }
    }

    private static class ColProxy
    extends CollectionProxy {
        private Collection _col;
        private FieldMolder _fm;
        private Object _object;
        private ClassLoader _cl;

        private ColProxy(FieldMolder fm, Object object, ClassLoader cl, Collection col) {
            this._cl = cl;
            this._fm = fm;
            this._col = col;
            this._object = object;
        }

        Object getCollection() {
            return this._col;
        }

        void add(Object key, Object value) {
            if (!this._fm.isAddable()) {
                this._col.add(value);
            } else {
                this._fm.addValue(this._object, value, this._cl);
            }
        }

        void close() {
            if (!this._fm.isAddable()) {
                this._fm.setValue(this._object, this._col, this._cl);
            }
        }
    }
}

