/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.exolab.castor.persist.spi.KeyGeneratorFactory;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;

public final class KeyGeneratorFactoryRegistry {
    private static final String KeyGeneratorFactoriesProperty = "org.exolab.castor.jdo.keyGeneratorFactories";
    private static Hashtable _factories;
    static /* synthetic */ Class class$org$exolab$castor$persist$KeyGeneratorFactoryRegistry;

    public static KeyGeneratorFactory getKeyGeneratorFactory(String name) {
        KeyGeneratorFactoryRegistry.load();
        return (KeyGeneratorFactory)_factories.get(name);
    }

    public static String[] getKeyGeneratorFactoryNames() {
        KeyGeneratorFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration theEnum = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)theEnum.nextElement();
        }
        return names;
    }

    private static synchronized void load() {
        if (_factories == null) {
            _factories = new Hashtable();
            String prop = LocalConfiguration.getInstance().getProperty(KeyGeneratorFactoriesProperty, "");
            StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                prop = tokenizer.nextToken();
                try {
                    Class<?> cls = (class$org$exolab$castor$persist$KeyGeneratorFactoryRegistry == null ? KeyGeneratorFactoryRegistry.class$("org.exolab.castor.persist.KeyGeneratorFactoryRegistry") : class$org$exolab$castor$persist$KeyGeneratorFactoryRegistry).getClassLoader().loadClass(prop);
                    KeyGeneratorFactory factory = (KeyGeneratorFactory)cls.newInstance();
                    _factories.put(factory.getName(), factory);
                }
                catch (Exception except) {
                    Logger.getSystemLogger().println(Messages.format("persist.missingKeyGeneratorFactory", prop));
                }
            }
        }
    }
}

