/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.persist.cache.Cache;
import org.exolab.castor.persist.cache.CacheAcquireException;
import org.exolab.castor.persist.cache.CacheFactory;
import org.exolab.castor.persist.cache.InvalidCacheTypeException;
import org.exolab.castor.util.LocalConfiguration;

public final class CacheRegistry {
    private static Log _log = LogFactory.getFactory().getInstance(CacheRegistry.class);
    private static final String CACHE_IMPLEMENTATION_PROPERTY = "org.exolab.castor.jdo.cacheFactories";
    private static final String DEFAULT_CACHE_TYPE = "count-limited";
    private static Hashtable _cacheFactories;

    public static Cache getCache(String cacheType, int capacity) throws CacheAcquireException, InvalidCacheTypeException {
        CacheFactory cacheFactory;
        CacheRegistry.load();
        Cache cache = null;
        if (cacheType == null || cacheType == "") {
            cacheType = DEFAULT_CACHE_TYPE;
        }
        if ((cacheFactory = (CacheFactory)_cacheFactories.get(cacheType)) != null) {
            cache = cacheFactory.getCache();
            cache.setCacheType(cacheType);
            cache.setCapacity(capacity);
        }
        return cache;
    }

    public static String[] getCacheFactories() {
        CacheRegistry.load();
        String[] names = new String[_cacheFactories.size()];
        Enumeration theEnum = _cacheFactories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)theEnum.nextElement();
        }
        return names;
    }

    public static Collection getCaches() {
        CacheRegistry.load();
        return Collections.unmodifiableCollection(_cacheFactories.keySet());
    }

    private static synchronized void load() {
        if (_cacheFactories == null) {
            CacheFactory cacheFactory = null;
            _cacheFactories = new Hashtable();
            String prop = LocalConfiguration.getInstance().getProperty(CACHE_IMPLEMENTATION_PROPERTY, "");
            StringTokenizer tokenizer = new StringTokenizer(prop, ", ");
            while (tokenizer.hasMoreTokens()) {
                prop = tokenizer.nextToken();
                try {
                    Class<?> cls = (class$org$exolab$castor$persist$cache$CacheRegistry == null ? CacheRegistry.class$("org.exolab.castor.persist.cache.CacheRegistry") : class$org$exolab$castor$persist$cache$CacheRegistry).getClassLoader().loadClass(prop);
                    cacheFactory = (CacheFactory)cls.newInstance();
                    _cacheFactories.put(cacheFactory.getName(), cacheFactory);
                }
                catch (Exception except) {
                    _log.error((Object)"Problem instantiating cache implementation.", (Throwable)except);
                }
            }
        }
    }
}

