/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import java.io.IOException;
import org.exolab.castor.net.URIException;
import org.exolab.castor.net.URILocation;
import org.exolab.castor.net.URIResolver;
import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.Sax2ComponentReader;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshaller;
import org.exolab.castor.xml.schema.reader.SchemaUnmarshallerState;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class IncludeUnmarshaller
extends ComponentReader {
    public IncludeUnmarshaller(Schema schema, AttributeSet atts, Resolver resolver, URIResolver uriResolver, Locator locator, SchemaUnmarshallerState state) throws XMLException {
        this.setResolver(resolver);
        this.setURIResolver(uriResolver);
        URILocation uri = null;
        String include = atts.getValue("schemaLocation");
        if (include == null) {
            throw new SchemaException("'schemaLocation' attribute missing on 'include'");
        }
        if (include.indexOf("\\") != -1) {
            String err = include + " is not a valid URI as defined by IETF RFC 2396.";
            err = err + "The URI must not contain '\\'.";
            throw new SchemaException(err);
        }
        try {
            String documentBase = locator.getSystemId();
            if (documentBase != null && !documentBase.endsWith("/")) {
                documentBase = documentBase.substring(0, documentBase.lastIndexOf("/") + 1);
            }
            uri = this.getURIResolver().resolve(include, documentBase);
        }
        catch (URIException ure) {
            throw new XMLException(ure);
        }
        if (uri != null) {
            include = uri.toString();
        }
        if (schema.includeProcessed(include)) {
            return;
        }
        if (include.equals(schema.getSchemaLocation())) {
            return;
        }
        schema.addInclude(include);
        Parser parser = null;
        try {
            parser = state.getConfiguration().getParser();
        }
        catch (RuntimeException rte) {
            // empty catch block
        }
        if (parser == null) {
            throw new SchemaException("Error failed to create parser for include");
        }
        SchemaUnmarshaller schemaUnmarshaller = new SchemaUnmarshaller(true, state, this.getURIResolver());
        schemaUnmarshaller.setSchema(schema);
        Sax2ComponentReader handler = new Sax2ComponentReader(schemaUnmarshaller);
        parser.setDocumentHandler(handler);
        parser.setErrorHandler(handler);
        try {
            InputSource source = new InputSource(uri.getReader());
            source.setSystemId(uri.getAbsoluteURI());
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SchemaException("Error reading include file '" + include + "'");
        }
        catch (SAXException sx) {
            throw new SchemaException(sx);
        }
    }

    public String elementName() {
        return "include";
    }

    public Object getObject() {
        return null;
    }
}

